/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.EntityRepresentation;
import org.neo4j.server.rest.repr.ExceptionRepresentation;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;

public class OutputFormat {
    private static final String UTF8 = "UTF-8";
    private final RepresentationFormat format;
    private final ExtensionInjector extensions;
    private final URI baseUri;

    public OutputFormat(RepresentationFormat format, URI baseUri, ExtensionInjector extensions) {
        this.format = format;
        this.baseUri = baseUri;
        this.extensions = extensions;
    }

    public final Response ok(Representation representation) {
        if (representation.isEmpty()) {
            return this.noContent();
        }
        return this.response(Response.ok(), representation);
    }

    public final <REPR extends Representation> Response created(REPR representation) throws BadInputException {
        return this.response(Response.created((URI)this.uri((EntityRepresentation)representation)), representation);
    }

    public final Response response(Response.Status status, Representation representation) throws BadInputException {
        return this.response(Response.status((Response.Status)status), representation);
    }

    public Response badRequest(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.BAD_REQUEST), (Representation)new ExceptionRepresentation(exception));
    }

    public Response forbidden(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.FORBIDDEN), (Representation)new ExceptionRepresentation(exception));
    }

    public Response notFound(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.NOT_FOUND), (Representation)new ExceptionRepresentation(exception));
    }

    public Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public Response conflict(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.CONFLICT), (Representation)new ExceptionRepresentation(exception));
    }

    public Response serverError(Throwable exception) {
        return this.response(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR), (Representation)new ExceptionRepresentation(exception));
    }

    private URI uri(EntityRepresentation representation) throws BadInputException {
        return URI.create(this.format((Representation)representation.selfUri()));
    }

    protected Response response(Response.ResponseBuilder response, Representation representation) {
        byte[] entityAsBytes;
        String entity = this.format(representation);
        try {
            entityAsBytes = entity.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encode string as UTF-8", e);
        }
        return response.entity((Object)entityAsBytes).header("Content-Encoding", (Object)UTF8).type(this.getMediaType()).build();
    }

    public MediaType getMediaType() {
        return this.format.mediaType;
    }

    public String format(Representation representation) {
        return representation.serialize(this.format, this.baseUri, this.extensions);
    }

    public Response noContent() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response methodNotAllowed(UnsupportedOperationException e) {
        return this.response(Response.status((int)405), (Representation)new ExceptionRepresentation(e));
    }
}

