/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jEdge;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jVertex;
import com.tinkerpop.pipes.util.structures.Table;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.DatabaseRepresentation;
import org.neo4j.server.rest.repr.GremlinTableRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class ObjectToRepresentationConverter {
    public static Representation convert(Object data) {
        if (data instanceof Table) {
            return new GremlinTableRepresentation((Table)data);
        }
        if (data instanceof Iterable) {
            return ObjectToRepresentationConverter.getListRepresentation((Iterable)data);
        }
        if (data instanceof Iterator) {
            Iterator iterator = (Iterator)data;
            return ObjectToRepresentationConverter.getIteratorRepresentation(iterator);
        }
        if (data instanceof Map) {
            return ObjectToRepresentationConverter.getMapRepresentation((Map)data);
        }
        return ObjectToRepresentationConverter.getSingleRepresentation(data);
    }

    public static MappingRepresentation getMapRepresentation(Map data) {
        return new MapRepresentation(data);
    }

    static Representation getIteratorRepresentation(Iterator data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        while (data.hasNext()) {
            Object value = data.next();
            if (value instanceof Iterable) {
                ArrayList<Representation> nested = new ArrayList<Representation>();
                nested.addAll(ObjectToRepresentationConverter.convertValuesToRepresentations((Iterable)value));
                results.add((Representation)new ListRepresentation(ObjectToRepresentationConverter.getType(nested), nested));
            }
            Representation representation = ObjectToRepresentationConverter.getSingleRepresentation(value);
            results.add(representation);
        }
        return new ListRepresentation(ObjectToRepresentationConverter.getType(results), results);
    }

    public static ListRepresentation getListRepresentation(Iterable data) {
        List<Representation> results = ObjectToRepresentationConverter.convertValuesToRepresentations(data);
        return new ListRepresentation(ObjectToRepresentationConverter.getType(results), results);
    }

    static List<Representation> convertValuesToRepresentations(Iterable data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        if (data instanceof Table) {
            results.add((Representation)new GremlinTableRepresentation((Table)data));
        } else {
            for (Object value : data) {
                if (value instanceof Iterable) {
                    ArrayList<Representation> nested = new ArrayList<Representation>();
                    nested.addAll(ObjectToRepresentationConverter.convertValuesToRepresentations((Iterable)value));
                    results.add((Representation)new ListRepresentation(ObjectToRepresentationConverter.getType(nested), nested));
                    continue;
                }
                results.add(ObjectToRepresentationConverter.getSingleRepresentation(value));
            }
        }
        return results;
    }

    static RepresentationType getType(List<Representation> representations) {
        if (representations == null || representations.isEmpty()) {
            return RepresentationType.STRING;
        }
        return representations.get(0).getRepresentationType();
    }

    static Representation getSingleRepresentation(Object result) {
        if (result == null) {
            return ValueRepresentation.string((String)"null");
        }
        if (result instanceof Neo4jVertex) {
            return new NodeRepresentation(((Neo4jVertex)result).getRawVertex());
        }
        if (result instanceof Neo4jEdge) {
            return new RelationshipRepresentation(((Neo4jEdge)result).getRawEdge());
        }
        if (result instanceof GraphDatabaseService) {
            return new DatabaseRepresentation((GraphDatabaseService)result);
        }
        if (result instanceof Node) {
            return new NodeRepresentation((Node)result);
        }
        if (result instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)result);
        }
        if (result instanceof Neo4jGraph) {
            return ValueRepresentation.string((String)((Neo4jGraph)result).getRawGraph().toString());
        }
        if (result instanceof Double || result instanceof Float) {
            return ValueRepresentation.number((double)((Number)result).doubleValue());
        }
        if (result instanceof Long) {
            return ValueRepresentation.number((long)((Long)result));
        }
        if (result instanceof Integer) {
            return ValueRepresentation.number((int)((Integer)result));
        }
        return ValueRepresentation.string((String)result.toString());
    }
}

