/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.ObjectToRepresentationConverter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;

public class GremlinTableRepresentation
extends ObjectRepresentation {
    private final Table queryResult;
    private final ObjectToRepresentationConverter converter = new ObjectToRepresentationConverter();

    public GremlinTableRepresentation(Table result) {
        super(RepresentationType.STRING);
        this.queryResult = result;
    }

    @ObjectRepresentation.Mapping(value="columns")
    public Representation columns() {
        return ListRepresentation.string((Iterable)this.queryResult.getColumnNames());
    }

    @ObjectRepresentation.Mapping(value="data")
    public Representation data() {
        ArrayList<ListRepresentation> rows = new ArrayList<ListRepresentation>();
        for (Row row : this.queryResult) {
            rows.add(new ListRepresentation("row", this.convertRow(row)));
        }
        return new ListRepresentation("data", rows);
    }

    private List<Representation> convertRow(Row row) {
        ArrayList<Representation> fields = new ArrayList<Representation>();
        for (String column : this.queryResult.getColumnNames()) {
            Object fieldValue = row.getColumn(column);
            Representation fieldRepresentation = ObjectToRepresentationConverter.convert(fieldValue);
            fields.add(fieldRepresentation);
        }
        return fields;
    }
}

