/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.RepresentationType;

public class ExceptionRepresentation
extends MappingRepresentation {
    private final Throwable exception;

    public ExceptionRepresentation(Throwable exception) {
        super(RepresentationType.EXCEPTION);
        this.exception = exception;
    }

    protected void serialize(MappingSerializer serializer) {
        String message = this.exception.getMessage();
        if (message != null) {
            serializer.putString("message", message);
        }
        serializer.putString("exception", this.exception.toString());
        StackTraceElement[] trace = this.exception.getStackTrace();
        if (trace != null) {
            String[] lines = new String[trace.length];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = trace[i].toString();
            }
            serializer.putList("stacktrace", ListRepresentation.strings((String[])lines));
        }
    }
}

