/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.RoundRobinJobScheduler;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rrd.RrdFactory;
import org.rrd4j.core.RrdDb;

public class WebAdminModule
implements ServerModule {
    private static final Logger log = Logger.getLogger(WebAdminModule.class);
    private static final String DEFAULT_WEB_ADMIN_PATH = "/webadmin";
    private static final String DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION = "webadmin-html";
    private final RoundRobinJobScheduler jobScheduler = new RoundRobinJobScheduler();

    @Override
    public void start(NeoServerWithEmbeddedWebServer neoServer, StringLogger logger) {
        try {
            this.startRoundRobinDB(neoServer);
        }
        catch (RuntimeException e) {
            log.error(e);
            return;
        }
        neoServer.getWebServer().addStaticContent(DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION, DEFAULT_WEB_ADMIN_PATH);
        log.info("Mounted webadmin at [%s]", DEFAULT_WEB_ADMIN_PATH);
        if (logger != null) {
            logger.logMessage("Mounted webadmin at: /webadmin");
        }
    }

    @Override
    public void stop() {
        this.jobScheduler.stopJobs();
    }

    private void startRoundRobinDB(NeoServerWithEmbeddedWebServer neoServer) {
        Database db = neoServer.getDatabase();
        RrdFactory rrdFactory = new RrdFactory(neoServer.getConfiguration());
        RrdDb rrdDb = rrdFactory.createRrdDbAndSampler(db, this.jobScheduler);
        db.setRrdDb(rrdDb);
    }
}

