/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public final class TransactionConditions {
    private TransactionConditions() {
    }

    static Condition<String> validRFCTimestamp() {
        return new Condition(value -> {
            try {
                ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, "Valid RFC1134 timestamp.", new Object[0]);
    }

    public static Consumer<HTTP.Response> containsNoErrors() {
        return TransactionConditions.hasErrors(new Status[0]);
    }

    public static Consumer<HTTP.Response> hasErrors(Status ... expectedErrors) {
        return response -> {
            try {
                Iterator errors = response.get("errors").iterator();
                Iterator expected = Iterators.iterator((Object[])expectedErrors);
                while (expected.hasNext()) {
                    Assertions.assertThat((boolean)errors.hasNext()).isTrue();
                    Assertions.assertThat((String)((JsonNode)errors.next()).get("code").asText()).isEqualTo(((Status)expected.next()).code().serialize());
                }
                if (errors.hasNext()) {
                    JsonNode error = (JsonNode)errors.next();
                    Assertions.fail((String)("Expected no more errors, but got " + error.get("code") + " - '" + error.get("message") + "'."));
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> hasOneErrorOf(Status ... expectedErrors) {
        return response -> {
            try {
                JsonNode error = response.get("errors").get(0);
                Iterator expected = Iterators.iterator((Object[])expectedErrors);
                boolean errorFound = false;
                while (!errorFound && expected.hasNext()) {
                    errorFound = error.get("code").asText().equals(((Status)expected.next()).code().serialize());
                }
                if (!errorFound) {
                    Assertions.fail((String)("Error " + errorFound + " does not match any of the following expected errors " + Arrays.stream(expectedErrors).map(s -> s.code().serialize()).toList()));
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    static JsonNode getJsonNodeWithName(HTTP.Response response, String name) throws JsonParseException {
        return response.get("results").get(0).get("data").get(0).get(name);
    }

    public static Consumer<HTTP.Response> rowContainsDeletedEntities(int nodes, int rels) {
        return response -> {
            try {
                Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
                int nodeCounter = 0;
                int relCounter = 0;
                block10: for (int i = 0; i < nodes + rels; ++i) {
                    String type;
                    Assertions.assertThat((boolean)meta.hasNext()).isTrue();
                    JsonNode node = (JsonNode)meta.next();
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                    switch (type = node.get("type").asText()) {
                        case "node": {
                            ++nodeCounter;
                            continue block10;
                        }
                        case "relationship": {
                            ++relCounter;
                            continue block10;
                        }
                        default: {
                            Assertions.fail((String)("Unexpected type: " + type));
                        }
                    }
                }
                Assertions.assertThat((int)nodes).isEqualTo(nodeCounter);
                Assertions.assertThat((int)rels).isEqualTo(relCounter);
                while (meta.hasNext()) {
                    JsonNode node = (JsonNode)meta.next();
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isEqualTo((Object)Boolean.FALSE);
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> rowContainsDeletedEntitiesInPath(int nodes, int rels) {
        return response -> {
            try {
                Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
                int nodeCounter = 0;
                int relCounter = 0;
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)meta.hasNext()).describedAs("Expected to find a JSON node, but there was none", new Object[0])).isTrue();
                JsonNode node = (JsonNode)meta.next();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)node.isArray()).describedAs("Expected the node to be a list (for a path)", new Object[0])).isTrue();
                block10: for (JsonNode inner : node) {
                    String type;
                    switch (type = inner.get("type").asText()) {
                        case "node": {
                            if (!inner.get("deleted").asBoolean()) continue block10;
                            ++nodeCounter;
                            continue block10;
                        }
                        case "relationship": {
                            if (!inner.get("deleted").asBoolean()) continue block10;
                            ++relCounter;
                            continue block10;
                        }
                    }
                    Assertions.fail((String)("Unexpected type: " + type));
                }
                Assertions.assertThat((int)nodes).isEqualTo(nodeCounter);
                Assertions.assertThat((int)rels).isEqualTo(relCounter);
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> rowContainsMetaNodesAtIndex(int ... indexes) {
        return response -> TransactionConditions.assertElementAtMetaIndex(response, indexes, "node");
    }

    public static Consumer<HTTP.Response> rowContainsMetaRelsAtIndex(int ... indexes) {
        return response -> TransactionConditions.assertElementAtMetaIndex(response, indexes, "relationship");
    }

    private static void assertElementAtMetaIndex(HTTP.Response response, int[] indexes, String element) {
        try {
            Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
            int i = 0;
            int metaIndex = 0;
            while (meta.hasNext() && i < indexes.length) {
                JsonNode node = (JsonNode)meta.next();
                if (!node.isNull()) {
                    String type = node.get("type").asText();
                    if (type.equals(element)) {
                        ((AbstractIntegerAssert)Assertions.assertThat((int)indexes[i]).describedAs("Expected " + element + " to be at indexes " + Arrays.toString(indexes) + ", but found it at " + metaIndex, new Object[0])).isEqualTo(metaIndex);
                        ++i;
                    } else {
                        ((AbstractIntegerAssert)Assertions.assertThat((int)indexes[i]).describedAs("Expected " + element + " at index " + metaIndex + ", but found " + type, new Object[0])).isNotEqualTo(metaIndex);
                    }
                }
                ++metaIndex;
            }
            Assertions.assertThat((int)indexes.length).isEqualTo(i);
        }
        catch (JsonParseException e) {
            Assertions.assertThat((Throwable)e).isNull();
        }
    }

    public static Consumer<HTTP.Response> rowContainsAMetaListAtIndex(int index) {
        return response -> {
            try {
                Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
                int metaIndex = 0;
                while (meta.hasNext()) {
                    JsonNode node = (JsonNode)meta.next();
                    if (metaIndex == index) {
                        Assertions.assertThat((boolean)node.isArray()).isTrue();
                    }
                    ++metaIndex;
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> restContainsDeletedEntities(int amount) {
        return response -> {
            try {
                Iterator entities = TransactionConditions.getJsonNodeWithName(response, "rest").iterator();
                for (int i = 0; i < amount; ++i) {
                    Assertions.assertThat((boolean)entities.hasNext()).isTrue();
                    JsonNode node = (JsonNode)entities.next();
                    Assertions.assertThat((boolean)node.get("metadata").get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                }
                if (entities.hasNext()) {
                    Assertions.fail((String)"Expected no more entities");
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> graphContainsDeletedNodes(int amount) {
        return response -> {
            try {
                Iterator nodes = TransactionConditions.getJsonNodeWithName(response, "graph").get("nodes").iterator();
                int deleted = 0;
                while (nodes.hasNext()) {
                    JsonNode node = (JsonNode)nodes.next();
                    if (node.get("deleted") == null) continue;
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isTrue();
                    ++deleted;
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)amount).describedAs(String.format("Expected to see %d deleted elements but %d was encountered.", amount, deleted), new Object[0])).isEqualTo(deleted);
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> graphContainsNoDeletedEntities() {
        return response -> {
            try {
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "graph").get("nodes")) {
                    Assertions.assertThat((Iterable)node.get("deleted")).isNull();
                }
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "graph").get("relationships")) {
                    Assertions.assertThat((Iterable)node.get("deleted")).isNull();
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> rowContainsNoDeletedEntities() {
        return response -> {
            try {
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "meta")) {
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isFalse();
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> restContainsNoDeletedEntities() {
        return response -> {
            try {
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "rest")) {
                    Assertions.assertThat((Iterable)node.get("metadata").get("deleted")).isNull();
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static Consumer<HTTP.Response> graphContainsDeletedRelationships(int amount) {
        return response -> {
            try {
                Iterator relationships = TransactionConditions.getJsonNodeWithName(response, "graph").get("relationships").iterator();
                for (int i = 0; i < amount; ++i) {
                    Assertions.assertThat((boolean)relationships.hasNext()).isTrue();
                    JsonNode node = (JsonNode)relationships.next();
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                }
                if (relationships.hasNext()) {
                    JsonNode node = (JsonNode)relationships.next();
                    Assertions.fail((String)("Expected no more nodes, but got a node with id " + node.get("id")));
                }
            }
            catch (JsonParseException e) {
                Assertions.assertThat((Throwable)e).isNull();
            }
        };
    }

    public static long countNodes(GraphDatabaseService graphdb) {
        try (Transaction transaction = graphdb.beginTx();){
            long l = Iterables.count((Iterable)transaction.getAllNodes());
            return l;
        }
    }

    public static Condition<? super HTTP.Response> containsNoStackTraces() {
        return new Condition(response -> {
            Map content = (Map)response.content();
            List errors = (List)content.get("errors");
            for (Map error : errors) {
                if (!error.containsKey("stackTrace")) continue;
                return false;
            }
            return true;
        }, "Contains stack traces.", new Object[0]);
    }
}

