/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.bytedeco.cpython.PyObject;
import org.bytedeco.cpython.global.python;
import org.nd4j.common.io.ClassPathResource;
import org.nd4j.python4j.PythonConstants;
import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonGIL;
import org.nd4j.python4j.PythonObject;
import org.nd4j.python4j.PythonType;
import org.nd4j.python4j.PythonTypes;
import org.nd4j.python4j.PythonVariable;
import org.nd4j.python4j.PythonVariables;

public class PythonExecutioner {
    private static AtomicBoolean init = new AtomicBoolean(false);

    private static synchronized void init() {
        if (init.get()) {
            return;
        }
        init.set(true);
        PythonExecutioner.initPythonPath();
        if (PythonConstants.initializePython()) {
            python.Py_InitializeEx((int)0);
        }
        for (PythonType type : PythonTypes.get()) {
            type.init();
        }
        PythonGIL.setMainThreadState();
        if (python._Py_IsFinalizing() != 1 && PythonConstants.releaseGilAutomatically()) {
            python.PyEval_SaveThread();
        }
    }

    public static void setVariable(String name, PythonObject value) {
        PythonGIL.assertThreadSafe();
        PyObject main = python.PyImport_ImportModule((String)"__main__");
        PyObject globals = python.PyModule_GetDict((PyObject)main);
        python.PyDict_SetItemString((PyObject)globals, (String)name, (PyObject)value.getNativePythonObject());
        python.Py_DecRef((PyObject)main);
    }

    public static void setVariables(List<PythonVariable> pyVars) {
        for (PythonVariable pyVar : pyVars) {
            PythonExecutioner.setVariable(pyVar.getName(), pyVar.getPythonObject());
        }
    }

    public static void setVariables(PythonVariable ... pyVars) {
        PythonExecutioner.setVariables(Arrays.asList(pyVars));
    }

    public static void getVariables(List<PythonVariable> pyVars) {
        for (PythonVariable pyVar : pyVars) {
            pyVar.setValue(PythonExecutioner.getVariable(pyVar.getName(), pyVar.getType()).getValue());
        }
    }

    public static void getVariables(PythonVariable ... pyVars) {
        PythonExecutioner.getVariables(Arrays.asList(pyVars));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonObject getVariable(String name) {
        PythonGIL.assertThreadSafe();
        PyObject main = python.PyImport_ImportModule((String)"__main__");
        PyObject globals = python.PyModule_GetDict((PyObject)main);
        PyObject pyName = python.PyUnicode_FromString((String)name);
        try {
            if (python.PyDict_Contains((PyObject)globals, (PyObject)pyName) == 1) {
                PythonObject pythonObject = new PythonObject(python.PyObject_GetItem((PyObject)globals, (PyObject)pyName), false);
                return pythonObject;
            }
        }
        finally {
            python.Py_DecRef((PyObject)main);
            python.Py_DecRef((PyObject)pyName);
        }
        return new PythonObject(null);
    }

    public static <T> PythonVariable<T> getVariable(String name, PythonType<T> type) {
        PythonObject val = PythonExecutioner.getVariable(name);
        return new PythonVariable<T>(name, type, type.toJava(val));
    }

    public static synchronized void simpleExec(String code) {
        PythonGIL.assertThreadSafe();
        int result = python.PyRun_SimpleStringFlags((String)code, null);
        if (result != 0) {
            throw new PythonException("Execution failed, unable to retrieve python exception.");
        }
    }

    private static void throwIfExecutionFailed() {
        PythonObject ex = PythonExecutioner.getVariable("__python_exception__");
        if (ex != null && !ex.isNone() && !ex.toString().isEmpty()) {
            PythonExecutioner.setVariable("__python_exception__", PythonTypes.STR.toPython(""));
            throw new PythonException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getWrappedCode(String code) {
        ClassPathResource resource = new ClassPathResource("org/nd4j/python4j/pythonexec/pythonexec.py");
        if (!resource.exists()) {
            throw new IllegalStateException("Unable to find class path resource for python script execution: org/nd4j/python4j/pythonexec/pythonexec.py if using via graalvm, please ensure this resource is included in your resources-config.json");
        }
        try (InputStream is = resource.getInputStream();){
            String out;
            String base = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String indentedCode = "    " + code.replace("\n", "\n    ");
            String string = out = base.replace("    pass", indentedCode);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read python code!", e);
        }
    }

    public static void exec(String code) {
        PythonExecutioner.simpleExec(PythonExecutioner.getWrappedCode(code));
        PythonExecutioner.throwIfExecutionFailed();
    }

    public static void exec(String code, List<PythonVariable> inputs, List<PythonVariable> outputs) {
        if (inputs != null) {
            PythonExecutioner.setVariables(inputs.toArray(new PythonVariable[0]));
        }
        PythonExecutioner.exec(code);
        if (outputs != null) {
            PythonExecutioner.getVariables(outputs.toArray(new PythonVariable[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonVariables getAllVariables() {
        PythonGIL.assertThreadSafe();
        PythonVariables ret = new PythonVariables(new PythonVariable[0]);
        PyObject main = python.PyImport_ImportModule((String)"__main__");
        PyObject globals = python.PyModule_GetDict((PyObject)main);
        PyObject keys = python.PyDict_Keys((PyObject)globals);
        PyObject keysIter = python.PyObject_GetIter((PyObject)keys);
        try {
            long n = python.PyObject_Size((PyObject)globals);
            int i = 0;
            while ((long)i < n) {
                block10: {
                    PyObject pyKey = python.PyIter_Next((PyObject)keysIter);
                    try {
                        PythonType pt;
                        if (new PythonObject(pyKey, false).toString().startsWith("_")) break block10;
                        PyObject pyVal = python.PyObject_GetItem((PyObject)globals, (PyObject)pyKey);
                        try {
                            pt = PythonTypes.getPythonTypeForPythonObject(new PythonObject(pyVal, false));
                        }
                        catch (PythonException pe) {
                            pt = null;
                        }
                        if (pt != null) {
                            ret.add(new PythonVariable(new PythonObject(pyKey, false).toString(), pt, pt.toJava(new PythonObject(pyVal, false))));
                        }
                    }
                    finally {
                        python.Py_DecRef((PyObject)pyKey);
                    }
                }
                ++i;
            }
        }
        finally {
            python.Py_DecRef((PyObject)keysIter);
            python.Py_DecRef((PyObject)keys);
            python.Py_DecRef((PyObject)main);
            return ret;
        }
    }

    public static PythonVariables execAndReturnAllVariables(String code, List<PythonVariable> inputs) {
        PythonExecutioner.setVariables(inputs);
        PythonExecutioner.simpleExec(PythonExecutioner.getWrappedCode(code));
        return PythonExecutioner.getAllVariables();
    }

    public static PythonVariables execAndReturnAllVariables(String code) {
        PythonExecutioner.simpleExec(PythonExecutioner.getWrappedCode(code));
        return PythonExecutioner.getAllVariables();
    }

    private static synchronized void initPythonPath() {
        try {
            String path = PythonConstants.defaultPythonPath();
            ArrayList<File> packagesList = new ArrayList<File>();
            packagesList.addAll(Arrays.asList(PythonExecutioner.cachePackages()));
            for (PythonType type : PythonTypes.get()) {
                packagesList.addAll(Arrays.asList(type.packages()));
            }
            packagesList.add(new File(python.cachePackage(), "site-packages"));
            File[] packages = packagesList.toArray(new File[0]);
            if (path == null) {
                python.Py_AddPath((File[])packages);
            } else {
                StringBuffer sb = new StringBuffer();
                JavaCppPathType pathAppendValue = PythonConstants.javaCppPythonAppendType();
                switch (pathAppendValue) {
                    case BEFORE: {
                        for (File cacheDir : packages) {
                            sb.append(cacheDir);
                            sb.append(File.pathSeparator);
                        }
                        sb.append(path);
                        break;
                    }
                    case AFTER: {
                        sb.append(path);
                        for (File cacheDir : packages) {
                            sb.append(cacheDir);
                            sb.append(File.pathSeparator);
                        }
                        break;
                    }
                    case NONE: {
                        sb.append(path);
                    }
                }
                python.Py_AddPath((String[])new String[]{sb.toString()});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File[] cachePackages() throws IOException {
        File[] path = python.cachePackages();
        path = Arrays.copyOf(path, path.length + 1);
        path[path.length - 1] = python.cachePackage();
        return path;
    }

    static {
        PythonExecutioner.init();
    }

    public static enum JavaCppPathType {
        BEFORE,
        AFTER,
        NONE;

    }
}

