/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import org.nd4j.python4j.Python;
import org.nd4j.python4j.PythonGC;
import org.nd4j.python4j.PythonObject;

public class PythonException
extends RuntimeException {
    public PythonException(String message) {
        super(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getExceptionString(PythonObject exception) {
        try (PythonGC gc = PythonGC.watch();){
            if (Python.isinstance(exception, Python.ExceptionType())) {
                String exceptionClass = Python.type(exception).attr("__name__").toString();
                String message = exception.toString();
                String string = exceptionClass + ": " + message;
                return string;
            }
            String string = exception.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while trying to create a PythonException.", e);
        }
    }

    public PythonException(PythonObject exception) {
        this(PythonException.getExceptionString(exception));
    }

    public PythonException(String message, Throwable cause) {
        super(message, cause);
    }

    public PythonException(Throwable cause) {
        super(cause);
    }
}

