/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonObject;
import org.nd4j.python4j.PythonType;
import org.nd4j.python4j.PythonTypes;

public class PythonVariable<T> {
    private String name;
    private String type;
    private T value;

    private static boolean validateVariableName(String s) {
        if (s.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public PythonVariable(String name, PythonType<T> type, Object value) {
        if (!PythonVariable.validateVariableName(name)) {
            throw new PythonException("Invalid identifier: " + name);
        }
        this.name = name;
        this.type = type.getName();
        this.setValue(value);
    }

    public PythonVariable(String name, PythonType<T> type) {
        this(name, type, null);
    }

    public PythonType<T> getType() {
        return PythonTypes.get(this.type);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value == null ? null : this.getType().adapt(value);
    }

    public PythonObject getPythonObject() {
        return this.getType().toPython(this.value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PythonVariable)) {
            return false;
        }
        PythonVariable other = (PythonVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PythonType<T> this$type = this.getType();
        PythonType<T> other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PythonVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PythonType<T> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "PythonVariable(name=" + this.getName() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
    }
}

