/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bytedeco.cpython.PyObject;
import org.bytedeco.cpython.global.python;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.python4j.Python;
import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonExecutioner;
import org.nd4j.python4j.PythonGC;
import org.nd4j.python4j.PythonGIL;
import org.nd4j.python4j.PythonTypes;

public class PythonObject {
    private boolean owned = true;
    private PyObject nativePythonObject;

    public PythonObject(PyObject nativePythonObject, boolean owned) {
        PythonGIL.assertThreadSafe();
        this.nativePythonObject = nativePythonObject;
        this.owned = owned;
        if (owned && nativePythonObject != null) {
            PythonGC.register(this);
        }
    }

    public PythonObject(PyObject nativePythonObject) {
        PythonGIL.assertThreadSafe();
        this.nativePythonObject = nativePythonObject;
        if (nativePythonObject != null) {
            PythonGC.register(this);
        }
    }

    public PyObject getNativePythonObject() {
        return this.nativePythonObject;
    }

    public String toString() {
        return PythonTypes.STR.toJava(this);
    }

    public boolean isNone() {
        if (this.nativePythonObject == null || Pointer.isNull((Pointer)this.nativePythonObject)) {
            return true;
        }
        try (PythonGC _ = PythonGC.pause();){
            PythonObject type = Python.type(this);
            boolean ret = Python.type(this).toString().equals("<class 'NoneType'>") && this.toString().equals("None");
            python.Py_DecRef((PyObject)type.nativePythonObject);
            boolean bl = ret;
            return bl;
        }
    }

    public void del() {
        PythonGIL.assertThreadSafe();
        if (this.owned && this.nativePythonObject != null && !PythonGC.isWatching()) {
            python.Py_DecRef((PyObject)this.nativePythonObject);
            this.nativePythonObject = null;
        }
    }

    public PythonObject callWithArgs(PythonObject args) {
        return this.callWithArgsAndKwargs(args, null);
    }

    public PythonObject callWithKwargs(PythonObject kwargs) {
        if (!Python.callable(this)) {
            throw new PythonException("Object is not callable: " + this.toString());
        }
        PyObject tuple = python.PyTuple_New((long)0L);
        PyObject dict = kwargs.nativePythonObject;
        if (python.PyObject_IsInstance((PyObject)dict, (PyObject)new PyObject((Pointer)python.PyDict_Type())) != 1) {
            throw new PythonException("Expected kwargs to be dict. Received: " + kwargs.toString());
        }
        PythonObject ret = new PythonObject(python.PyObject_Call((PyObject)this.nativePythonObject, (PyObject)tuple, (PyObject)dict));
        python.Py_DecRef((PyObject)tuple);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonObject callWithArgsAndKwargs(PythonObject args, PythonObject kwargs) {
        PythonObject pythonObject;
        block9: {
            PythonGIL.assertThreadSafe();
            PyObject tuple = null;
            boolean ownsTuple = false;
            try {
                if (!Python.callable(this)) {
                    throw new PythonException("Object is not callable: " + this.toString());
                }
                if (python.PyObject_IsInstance((PyObject)args.nativePythonObject, (PyObject)new PyObject((Pointer)python.PyTuple_Type())) == 1) {
                    tuple = args.nativePythonObject;
                } else if (python.PyObject_IsInstance((PyObject)args.nativePythonObject, (PyObject)new PyObject((Pointer)python.PyList_Type())) == 1) {
                    tuple = python.PyList_AsTuple((PyObject)args.nativePythonObject);
                    ownsTuple = true;
                } else {
                    throw new PythonException("Expected args to be tuple or list. Received: " + args.toString());
                }
                if (kwargs != null && python.PyObject_IsInstance((PyObject)kwargs.nativePythonObject, (PyObject)new PyObject((Pointer)python.PyDict_Type())) != 1) {
                    throw new PythonException("Expected kwargs to be dict. Received: " + kwargs.toString());
                }
                pythonObject = new PythonObject(python.PyObject_Call((PyObject)this.nativePythonObject, (PyObject)tuple, (PyObject)(kwargs == null ? null : kwargs.nativePythonObject)));
                if (!ownsTuple) break block9;
            }
            catch (Throwable throwable) {
                if (ownsTuple) {
                    python.Py_DecRef(tuple);
                }
                throw throwable;
            }
            python.Py_DecRef((PyObject)tuple);
        }
        return pythonObject;
    }

    public PythonObject call(Object ... args) {
        return this.callWithArgsAndKwargs(Arrays.asList(args), null);
    }

    public PythonObject callWithArgs(List args) {
        return this.call(args, null);
    }

    public PythonObject callWithKwargs(Map kwargs) {
        return this.call(null, kwargs);
    }

    public PythonObject callWithArgsAndKwargs(List args, Map kwargs) {
        PythonGIL.assertThreadSafe();
        try (PythonGC _ = PythonGC.watch();){
            PythonObject pyArgs;
            if (!Python.callable(this)) {
                throw new PythonException("Object is not callable: " + this.toString());
            }
            if (args == null || args.isEmpty()) {
                pyArgs = new PythonObject(python.PyTuple_New((long)0L));
            } else {
                PythonObject argsList = PythonTypes.convert(args);
                pyArgs = new PythonObject(python.PyList_AsTuple((PyObject)argsList.getNativePythonObject()));
            }
            PythonObject pyKwargs = kwargs == null ? null : PythonTypes.convert(kwargs);
            PythonObject ret = new PythonObject(python.PyObject_Call((PyObject)this.nativePythonObject, (PyObject)pyArgs.nativePythonObject, (PyObject)(pyKwargs == null ? null : pyKwargs.nativePythonObject)));
            PythonGC.keep(ret);
            PythonObject pythonObject = ret;
            return pythonObject;
        }
    }

    public PythonObject attr(String attrName) {
        PythonGIL.assertThreadSafe();
        return new PythonObject(python.PyObject_GetAttrString((PyObject)this.nativePythonObject, (String)attrName));
    }

    public PythonObject(Object javaObject) {
        PythonGIL.assertThreadSafe();
        if (javaObject instanceof PythonObject) {
            this.owned = false;
            this.nativePythonObject = ((PythonObject)javaObject).nativePythonObject;
        } else {
            try (PythonGC _ = PythonGC.pause();){
                this.nativePythonObject = PythonTypes.convert(javaObject).getNativePythonObject();
            }
            PythonGC.register(this);
        }
    }

    public int toInt() {
        return PythonTypes.INT.toJava(this).intValue();
    }

    public long toLong() {
        return PythonTypes.INT.toJava(this);
    }

    public float toFloat() {
        return PythonTypes.FLOAT.toJava(this).floatValue();
    }

    public double toDouble() {
        return PythonTypes.FLOAT.toJava(this);
    }

    public boolean toBoolean() {
        return PythonTypes.BOOL.toJava(this);
    }

    public List toList() {
        return PythonTypes.LIST.toJava(this);
    }

    public Map toMap() {
        return PythonTypes.DICT.toJava(this);
    }

    public PythonObject get(int key) {
        PythonGIL.assertThreadSafe();
        return new PythonObject(python.PyObject_GetItem((PyObject)this.nativePythonObject, (PyObject)python.PyLong_FromLong((long)key)));
    }

    public PythonObject get(String key) {
        PythonGIL.assertThreadSafe();
        return new PythonObject(python.PyObject_GetItem((PyObject)this.nativePythonObject, (PyObject)python.PyUnicode_FromString((String)key)));
    }

    public PythonObject get(PythonObject key) {
        PythonGIL.assertThreadSafe();
        return new PythonObject(python.PyObject_GetItem((PyObject)this.nativePythonObject, (PyObject)key.nativePythonObject));
    }

    public void set(PythonObject key, PythonObject value) {
        PythonGIL.assertThreadSafe();
        python.PyObject_SetItem((PyObject)this.nativePythonObject, (PyObject)key.nativePythonObject, (PyObject)value.nativePythonObject);
    }

    public PythonObject abs() {
        return new PythonObject(python.PyNumber_Absolute((PyObject)this.nativePythonObject));
    }

    public PythonObject add(PythonObject pythonObject) {
        return new PythonObject(python.PyNumber_Add((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject));
    }

    public PythonObject sub(PythonObject pythonObject) {
        return new PythonObject(python.PyNumber_Subtract((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject));
    }

    public PythonObject mod(PythonObject pythonObject) {
        return new PythonObject(python.PyNumber_Divmod((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject));
    }

    public PythonObject mul(PythonObject pythonObject) {
        return new PythonObject(python.PyNumber_Multiply((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject));
    }

    public PythonObject trueDiv(PythonObject pythonObject) {
        return new PythonObject(python.PyNumber_TrueDivide((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject));
    }

    public PythonObject floorDiv(PythonObject pythonObject) {
        return new PythonObject(python.PyNumber_FloorDivide((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject));
    }

    public PythonObject matMul(PythonObject pythonObject) {
        return new PythonObject(python.PyNumber_MatrixMultiply((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject));
    }

    public void addi(PythonObject pythonObject) {
        python.PyNumber_InPlaceAdd((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject);
    }

    public void subi(PythonObject pythonObject) {
        python.PyNumber_InPlaceSubtract((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject);
    }

    public void muli(PythonObject pythonObject) {
        python.PyNumber_InPlaceMultiply((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject);
    }

    public void trueDivi(PythonObject pythonObject) {
        python.PyNumber_InPlaceTrueDivide((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject);
    }

    public void floorDivi(PythonObject pythonObject) {
        python.PyNumber_InPlaceFloorDivide((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject);
    }

    public void matMuli(PythonObject pythonObject) {
        python.PyNumber_InPlaceMatrixMultiply((PyObject)this.nativePythonObject, (PyObject)pythonObject.nativePythonObject);
    }

    static {
        new PythonExecutioner();
    }
}

