/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.ops;

import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOpContext;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueContext;
import org.nd4j.nativeblas.OpaqueRandomGenerator;

public class CpuOpContext
extends BaseOpContext
implements OpContext {
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private OpaqueContext context = this.nativeOps.createGraphContext(1);

    public void close() {
        this.nativeOps.deleteGraphContext(this.context);
    }

    public void setIArguments(long ... arguments) {
        if (arguments.length > 0) {
            super.setIArguments(arguments);
            this.nativeOps.setGraphContextIArguments(this.context, new LongPointer(arguments), arguments.length);
        }
    }

    public void setBArguments(boolean ... arguments) {
        if (arguments.length > 0) {
            super.setBArguments(arguments);
            this.nativeOps.setGraphContextBArguments(this.context, new BooleanPointer(arguments), arguments.length);
        }
    }

    public void setTArguments(double ... arguments) {
        if (arguments.length > 0) {
            super.setTArguments(arguments);
            this.nativeOps.setGraphContextTArguments(this.context, new DoublePointer(arguments), arguments.length);
        }
    }

    public void setRngStates(long rootState, long nodeState) {
        this.nativeOps.setRandomGeneratorStates(this.nativeOps.getGraphContextRandomGenerator(this.context), rootState, nodeState);
    }

    public Pair<Long, Long> getRngStates() {
        OpaqueRandomGenerator g = this.nativeOps.getGraphContextRandomGenerator(this.context);
        return Pair.makePair((Object)this.nativeOps.getRandomGeneratorRootState(g), (Object)this.nativeOps.getRandomGeneratorNodeState(g));
    }

    public void setInputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        this.nativeOps.setGraphContextInputArray(this.context, index, array.isEmpty() ? null : array.data().addressPointer(), array.shapeInfoDataBuffer().addressPointer(), null, null);
        super.setInputArray(index, array);
    }

    public void setOutputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        this.nativeOps.setGraphContextOutputArray(this.context, index, array.isEmpty() ? null : array.data().addressPointer(), array.shapeInfoDataBuffer().addressPointer(), null, null);
        super.setOutputArray(index, array);
    }

    public Pointer contextPointer() {
        return this.context;
    }

    public void markInplace(boolean reallyInplace) {
        this.nativeOps.markGraphContextInplace(this.context, reallyInplace);
    }

    public void allowHelpers(boolean reallyAllow) {
        this.nativeOps.ctxAllowHelpers(this.context, reallyAllow);
    }
}

