/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.blas;

import org.bytedeco.javacpp.openblas;
import org.nd4j.nativeblas.Nd4jBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuBlas
extends Nd4jBlas {
    private static final Logger log = LoggerFactory.getLogger(CpuBlas.class);

    static int convertOrder(int from) {
        switch (from) {
            case 67: 
            case 99: {
                return 101;
            }
            case 70: 
            case 102: {
                return 102;
            }
        }
        return 102;
    }

    static int convertTranspose(int from) {
        switch (from) {
            case 84: 
            case 116: {
                return 112;
            }
            case 78: 
            case 110: {
                return 111;
            }
            case 67: 
            case 99: {
                return 113;
            }
        }
        return 111;
    }

    static int convertUplo(int from) {
        switch (from) {
            case 85: 
            case 117: {
                return 121;
            }
            case 76: 
            case 108: {
                return 122;
            }
        }
        return 121;
    }

    static int convertDiag(int from) {
        switch (from) {
            case 85: 
            case 117: {
                return 132;
            }
            case 78: 
            case 110: {
                return 131;
            }
        }
        return 132;
    }

    static int convertSide(int from) {
        switch (from) {
            case 76: 
            case 108: {
                return 141;
            }
            case 82: 
            case 114: {
                return 142;
            }
        }
        return 141;
    }

    public void setMaxThreads(int num) {
        openblas.blas_set_num_threads((int)num);
    }

    public int getMaxThreads() {
        return openblas.blas_get_num_threads();
    }

    public int getBlasVendorId() {
        return openblas.blas_get_vendor();
    }
}

