/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.util.Properties;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Platform(include={"NativeOps.h"}, compiler={"cpp11"}, link={"nd4j"}, library="jnind4j")
public class NativeOps
extends Pointer {
    private static Logger log = LoggerFactory.getLogger(NativeOps.class);

    public NativeOps() {
        this.allocate();
        this.initializeDevicesAndFunctions();
        String numThreadsString = System.getenv("OMP_NUM_THREADS");
        if (numThreadsString != null && !numThreadsString.isEmpty()) {
            int numThreads = Integer.parseInt(numThreadsString);
            this.setOmpNumThreads(numThreads);
        } else {
            this.setOmpNumThreads(Runtime.getRuntime().availableProcessors());
        }
        log.debug("Number of threads used for linear algebra " + this.ompGetNumThreads());
    }

    private native void allocate();

    public native double execIndexReduceScalarDouble(long[] var1, int var2, long var3, long var5, long var7);

    public native void execIndexReduceDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, int var15);

    public native void execBroadcastDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, int var17);

    public native void execPairwiseTransformDouble(long[] var1, int var2, long var3, int var5, long var6, int var8, long var9, int var11, long var12, long var14);

    public native void execPairwiseTransformDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, long var21);

    public native void execPairwiseTransformDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    public native void execReduceDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public native void execReduceDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, int var15);

    public native double execReduceScalarDouble(long[] var1, int var2, long var3, long var5, long var7);

    public native void execReduce3Double(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    public native double execReduce3ScalarDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public native void execReduce3Double(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, int var19);

    public native void execScalarDouble(long[] var1, int var2, long var3, int var5, long var6, int var8, double var9, long var11, long var13);

    public native void execScalarDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, double var11, long var13);

    public native void execScalarDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, double var11, long var13, long var15, long var17, long var19);

    public native double execSummaryStatsScalarDouble(long[] var1, int var2, long var3, long var5, long var7, boolean var9);

    public native void execSummaryStatsDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, boolean var13);

    public native void execSummaryStatsDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, int var15, boolean var16);

    public native void execTransformDouble(long[] var1, int var2, long var3, int var5, long var6, int var8, long var9, long var11);

    public native void execTransformDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public native void execTransformDouble(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    public native float execIndexReduceScalarFloat(long[] var1, int var2, long var3, long var5, long var7);

    public native void execIndexReduceFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, int var15);

    public native void execBroadcastFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, int var17);

    public native void execPairwiseTransformFloat(long[] var1, int var2, long var3, int var5, long var6, int var8, long var9, int var11, long var12, long var14);

    public native void execPairwiseTransformFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, long var21);

    public native void execPairwiseTransformFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    public native void execReduceFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public native void execReduceFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, int var15);

    public native float execReduceScalarFloat(long[] var1, int var2, long var3, long var5, long var7);

    public native void execReduce3Float(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    public native float execReduce3ScalarFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public native void execReduce3Float(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, int var19);

    public native void execScalarFloat(long[] var1, int var2, long var3, int var5, long var6, int var8, double var9, long var11, long var13);

    public native void execScalarFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, float var11, long var12);

    public native void execScalarFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, double var11, long var13, long var15, long var17);

    public native float execSummaryStatsScalarFloat(long[] var1, int var2, long var3, long var5, long var7, boolean var9);

    public native void execSummaryStatsFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, boolean var13);

    public native void execSummaryStatsFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, int var15, boolean var16);

    public native void execTransformFloat(long[] var1, int var2, long var3, int var5, long var6, int var8, long var9, long var11);

    public native void execTransformFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public native void execTransformFloat(long[] var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    public native void flattenFloat(long[] var1, int var2, char var3, long var4, long var6, long var8, long var10);

    public native void flattenDouble(long[] var1, int var2, char var3, long var4, long var6, long var8, long var10);

    public native void concatDouble(long[] var1, int var2, int var3, long[] var4, long[] var5, long var6, long var8, long[] var10, long[] var11);

    public native void concatFloat(long[] var1, int var2, int var3, long[] var4, long[] var5, long var6, long var8, long[] var10, long[] var11);

    public native int ompGetNumThreads();

    public native void setOmpNumThreads(int var1);

    public native void initializeDevicesAndFunctions();

    public native long mallocHost(long var1, int var3);

    public native long mallocDevice(long var1, long var3, int var5);

    public native long freeHost(long var1);

    public native long freeDevice(long var1, long var3);

    public native long createContext();

    public native long createStream();

    public native long createEvent();

    public native long createBlasHandle();

    public native long registerEvent(long var1, long var3);

    public native long destroyEvent(long var1);

    public native long setBlasStream(long var1, long var3);

    public native long setDevice(long var1);

    public native long streamSynchronize(long var1);

    public native long eventSynchronize(long var1);

    public native long getDeviceFreeMemory(long var1);

    public native long getDeviceTotalMemory(long var1);

    public native long memcpy(long var1, long var3, long var5, int var7, long var8);

    public native long memcpyAsync(long var1, long var3, long var5, int var7, long var8);

    public native long memcpyConstantAsync(long var1, long var3, long var5, int var7, long var8);

    public native long memset(long var1, int var3, long var4, int var6, long var7);

    public native long memsetAsync(long var1, int var3, long var4, int var6, long var7);

    public native long getConstantSpace();

    public native long getAvailableDevices();

    public native void enableDebugMode(boolean var1);

    public native void enableVerboseMode(boolean var1);

    public native void setGridLimit(int var1);

    public native void tadOnlyShapeInfo(long var1, long var3, int var5, long var6, long var8);

    static {
        String platform = Loader.getPlatform();
        Properties properties = Loader.loadProperties((String)(platform + "-nd4j"), (String)platform);
        properties.remove("platform.preloadpath");
        Loader.load(NativeOps.class, (Properties)properties, (boolean)true);
    }
}

