/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.util;

import com.google.common.net.InetAddresses;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nd4j.base.Preconditions;

public class StringUtils {
    public static final String[] emptyStringArray = new String[0];
    public static final char COMMA = ',';
    public static final char ESCAPE_CHAR = '\\';

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static String simpleHostname(String fullHostname) {
        if (InetAddresses.isInetAddress((String)fullHostname)) {
            return fullHostname;
        }
        int offset = fullHostname.indexOf(46);
        if (offset != -1) {
            return fullHostname.substring(0, offset);
        }
        return fullHostname;
    }

    @Deprecated
    public static String humanReadableInt(long number) {
        return TraditionalBinaryPrefix.long2String(number, "", 1);
    }

    public static String format(String format, Object ... objects) {
        return String.format(Locale.ENGLISH, format, objects);
    }

    public static String formatPercent(double fraction, int decimalPlaces) {
        return StringUtils.format("%." + decimalPlaces + "f%%", fraction * 100.0);
    }

    public static String arrayToString(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(strs[0]);
        for (int idx = 1; idx < strs.length; ++idx) {
            sbuf.append(",");
            sbuf.append(strs[idx]);
        }
        return sbuf.toString();
    }

    public static String byteToHexString(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        StringBuilder s = new StringBuilder();
        for (int i = start; i < end; ++i) {
            s.append(StringUtils.format("%02x", bytes[i]));
        }
        return s.toString();
    }

    public static String byteToHexString(byte[] bytes) {
        return StringUtils.byteToHexString(bytes, 0, bytes.length);
    }

    public static String byteToHexString(byte b) {
        return StringUtils.byteToHexString(new byte[]{b});
    }

    public static byte[] hexStringToByte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static String uriToString(URI[] uris) {
        if (uris == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(uris[0].toString());
        for (int i = 1; i < uris.length; ++i) {
            ret.append(",");
            ret.append(uris[i].toString());
        }
        return ret.toString();
    }

    public static URI[] stringToURI(String[] str) {
        if (str == null) {
            return null;
        }
        URI[] uris = new URI[str.length];
        for (int i = 0; i < str.length; ++i) {
            try {
                uris[i] = new URI(str[i]);
                continue;
            }
            catch (URISyntaxException ur) {
                throw new IllegalArgumentException("Failed to create uri for " + str[i], ur);
            }
        }
        return uris;
    }

    public static String formatTimeDiff(long finishTime, long startTime) {
        long timeDiff = finishTime - startTime;
        return StringUtils.formatTime(timeDiff);
    }

    public static String formatTime(long timeDiff) {
        StringBuilder buf = new StringBuilder();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        long seconds = (rem %= 60000L) / 1000L;
        if (hours != 0L) {
            buf.append(hours);
            buf.append("hrs, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append("mins, ");
        }
        buf.append(seconds);
        buf.append("sec");
        return buf.toString();
    }

    public static String formatTimeSortable(long timeDiff) {
        StringBuilder buf = new StringBuilder();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        long seconds = (rem %= 60000L) / 1000L;
        if (hours > 99L) {
            hours = 99L;
            minutes = 59L;
            seconds = 59L;
        }
        buf.append(String.format("%02d", hours));
        buf.append("hrs, ");
        buf.append(String.format("%02d", minutes));
        buf.append("mins, ");
        buf.append(String.format("%02d", seconds));
        buf.append("sec");
        return buf.toString();
    }

    public static String getFormattedTimeWithDiff(String formattedFinishTime, long finishTime, long startTime) {
        StringBuilder buf = new StringBuilder();
        if (0L != finishTime) {
            buf.append(formattedFinishTime);
            if (0L != startTime) {
                buf.append(" (" + StringUtils.formatTimeDiff(finishTime, startTime) + ")");
            }
        }
        return buf.toString();
    }

    public static String[] getStrings(String str) {
        String delim = ",";
        return StringUtils.getStrings(str, delim);
    }

    public static String[] getStrings(String str, String delim) {
        Collection<String> values = StringUtils.getStringCollection(str, delim);
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public static Collection<String> getStringCollection(String str) {
        String delim = ",";
        return StringUtils.getStringCollection(str, delim);
    }

    public static Collection<String> getStringCollection(String str, String delim) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static Collection<String> getTrimmedStringCollection(String str) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(StringUtils.getTrimmedStrings(str)));
        set.remove("");
        return set;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || str.trim().isEmpty()) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*[,\n]\\s*");
    }

    public static String[] split(String str) {
        return StringUtils.split(str, '\\', ',');
    }

    public static String[] split(String str, char escapeChar, char separator) {
        if (str == null) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>();
        StringBuilder split = new StringBuilder();
        int index = 0;
        while ((index = StringUtils.findNext(str, separator, escapeChar, index, split)) >= 0) {
            ++index;
            strList.add(split.toString());
            split.setLength(0);
        }
        strList.add(split.toString());
        int last = strList.size();
        while (--last >= 0 && "".equals(strList.get(last))) {
            strList.remove(last);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String[] split(String str, char separator) {
        if (str.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> strList = new ArrayList<String>();
        int startIndex = 0;
        int nextIndex = 0;
        while ((nextIndex = str.indexOf(separator, startIndex)) != -1) {
            strList.add(str.substring(startIndex, nextIndex));
            startIndex = nextIndex + 1;
        }
        strList.add(str.substring(startIndex));
        int last = strList.size();
        while (--last >= 0 && "".equals(strList.get(last))) {
            strList.remove(last);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static int findNext(String str, char separator, char escapeChar, int start, StringBuilder split) {
        int numPreEscapes = 0;
        for (int i = start; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (numPreEscapes == 0 && curChar == separator) {
                return i;
            }
            split.append(curChar);
            numPreEscapes = curChar == escapeChar ? ++numPreEscapes % 2 : 0;
        }
        return -1;
    }

    public static String[] splitOnCharWithQuoting(String s, char splitChar, char quoteChar, char escapeChar) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int length = s.length();
        StringBuilder b = new StringBuilder();
        block0: while (i < length) {
            char curr = s.charAt(i);
            if (curr == splitChar) {
                if (b.length() > 0) {
                    result.add(b.toString());
                    b = new StringBuilder();
                }
                ++i;
                continue;
            }
            if (curr == quoteChar) {
                ++i;
                while (i < length) {
                    curr = s.charAt(i);
                    if (curr == escapeChar) {
                        b.append(s.charAt(i + 1));
                        i += 2;
                        continue;
                    }
                    if (curr == quoteChar) {
                        ++i;
                        continue block0;
                    }
                    b.append(s.charAt(i));
                    ++i;
                }
                continue;
            }
            b.append(curr);
            ++i;
        }
        if (b.length() > 0) {
            result.add(b.toString());
        }
        return result.toArray(new String[0]);
    }

    public static String escapeString(String str) {
        return StringUtils.escapeString(str, '\\', ',');
    }

    public static String escapeString(String str, char escapeChar, char charToEscape) {
        return StringUtils.escapeString(str, escapeChar, new char[]{charToEscape});
    }

    private static boolean hasChar(char[] chars, char character) {
        for (char target : chars) {
            if (character != target) continue;
            return true;
        }
        return false;
    }

    public static String escapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (curChar == escapeChar || StringUtils.hasChar(charsToEscape, curChar)) {
                result.append(escapeChar);
            }
            result.append(curChar);
        }
        return result.toString();
    }

    public static String unEscapeString(String str) {
        return StringUtils.unEscapeString(str, '\\', ',');
    }

    public static String unEscapeString(String str, char escapeChar, char charToEscape) {
        return StringUtils.unEscapeString(str, escapeChar, new char[]{charToEscape});
    }

    public static String unEscapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean hasPreEscape = false;
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (hasPreEscape) {
                if (curChar != escapeChar && !StringUtils.hasChar(charsToEscape, curChar)) {
                    throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + escapeChar + " at " + (i - 1));
                }
                result.append(curChar);
                hasPreEscape = false;
                continue;
            }
            if (StringUtils.hasChar(charsToEscape, curChar)) {
                throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + curChar + " at " + i);
            }
            if (curChar == escapeChar) {
                hasPreEscape = true;
                continue;
            }
            result.append(curChar);
        }
        if (hasPreEscape) {
            throw new IllegalArgumentException("Illegal escaped string " + str + ", not expecting " + escapeChar + " in the end.");
        }
        return result.toString();
    }

    public static String escapeHTML(String string) {
        char[] chars;
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean lastCharacterWasSpace = false;
        block6: for (char c : chars = string.toCharArray()) {
            if (c == ' ') {
                if (lastCharacterWasSpace) {
                    lastCharacterWasSpace = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastCharacterWasSpace = true;
                sb.append(" ");
                continue;
            }
            lastCharacterWasSpace = false;
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String byteDesc(long len) {
        return TraditionalBinaryPrefix.long2String(len, "B", 2);
    }

    @Deprecated
    public static String limitDecimalTo2(double d) {
        return StringUtils.format("%.2f", d);
    }

    public static String join(CharSequence separator, Iterable<?> strings) {
        Iterator<?> i = strings.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(i.next().toString());
        while (i.hasNext()) {
            sb.append(separator);
            sb.append(i.next().toString());
        }
        return sb.toString();
    }

    public static String join(Iterable<String> strings) {
        return StringUtils.join((CharSequence)" ", strings);
    }

    public static String join(char separator, Iterable<?> strings) {
        return StringUtils.join((CharSequence)(separator + ""), strings);
    }

    public static String join(CharSequence separator, String[] strings) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(char separator, String[] strings) {
        return StringUtils.join((CharSequence)(separator + ""), strings);
    }

    public static String camelize(String s) {
        String[] words;
        StringBuilder sb = new StringBuilder();
        for (String word : words = StringUtils.split(StringUtils.toLowerCase(s), '\\', '_')) {
            sb.append(org.apache.commons.lang3.StringUtils.capitalize((String)word));
        }
        return sb.toString();
    }

    public static String replaceTokens(String template, Pattern pattern, Map<String, String> replacements) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(template);
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            if (replacement == null) {
                replacement = "";
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getStackTrace(Thread t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        StringBuilder str = new StringBuilder();
        for (StackTraceElement e : stackTrace) {
            str.append(e.toString() + "\n");
        }
        return str.toString();
    }

    public static String toLowerCase(String str) {
        return str.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String str) {
        return str.toUpperCase(Locale.ENGLISH);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        Preconditions.checkNotNull(s1);
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String timeUnitToString(long time, TimeUnit unit) {
        String str = String.valueOf(time);
        switch (unit) {
            case MILLISECONDS: {
                str = str + "Millisecond";
                break;
            }
            case SECONDS: {
                str = str + "Second";
                break;
            }
            case MINUTES: {
                str = str + "Minute";
                break;
            }
            case HOURS: {
                str = str + "Hour";
                break;
            }
            case DAYS: {
                str = str + "Day";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (time == 1L) {
            return str;
        }
        return str + "s";
    }

    public static TimeUnit stringToTimeUnit(String str) {
        switch (str.toLowerCase()) {
            case "ms": 
            case "millisecond": 
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": 
            case "sec": 
            case "second": 
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "min": 
            case "minute": 
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "h": 
            case "hour": 
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "day": 
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Unknown time unit: \"" + str + "\"");
    }

    public static enum TraditionalBinaryPrefix {
        KILO(10),
        MEGA(TraditionalBinaryPrefix.KILO.bitShift + 10),
        GIGA(TraditionalBinaryPrefix.MEGA.bitShift + 10),
        TERA(TraditionalBinaryPrefix.GIGA.bitShift + 10),
        PETA(TraditionalBinaryPrefix.TERA.bitShift + 10),
        EXA(TraditionalBinaryPrefix.PETA.bitShift + 10);

        public final long value;
        public final char symbol;
        public final int bitShift;
        public final long bitMask;

        private TraditionalBinaryPrefix(int bitShift) {
            this.bitShift = bitShift;
            this.value = 1L << bitShift;
            this.bitMask = this.value - 1L;
            this.symbol = this.toString().charAt(0);
        }

        public static TraditionalBinaryPrefix valueOf(char symbol) {
            symbol = Character.toUpperCase(symbol);
            for (TraditionalBinaryPrefix prefix : TraditionalBinaryPrefix.values()) {
                if (symbol != prefix.symbol) continue;
                return prefix;
            }
            throw new IllegalArgumentException("Unknown symbol '" + symbol + "'");
        }

        public static long string2long(String s) {
            long prefix;
            int lastpos;
            char lastchar = (s = s.trim()).charAt(lastpos = s.length() - 1);
            if (Character.isDigit(lastchar)) {
                return Long.parseLong(s);
            }
            try {
                prefix = TraditionalBinaryPrefix.valueOf((char)lastchar).value;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid size prefix '" + lastchar + "' in '" + s + "'. Allowed prefixes are k, m, g, t, p, e(case insensitive)");
            }
            long num = Long.parseLong(s.substring(0, lastpos));
            if (num > Long.MAX_VALUE / prefix || num < Long.MIN_VALUE / prefix) {
                throw new IllegalArgumentException(s + " does not fit in a Long");
            }
            return num * prefix;
        }

        public static String long2String(long n, String unit, int decimalPlaces) {
            int i;
            if (unit == null) {
                unit = "";
            }
            if (n == Long.MIN_VALUE) {
                return "-8 " + TraditionalBinaryPrefix.EXA.symbol + unit;
            }
            StringBuilder b = new StringBuilder();
            if (n < 0L) {
                b.append('-');
                n = -n;
            }
            if (n < TraditionalBinaryPrefix.KILO.value) {
                b.append(n);
                return (unit.isEmpty() ? b : b.append(" ").append(unit)).toString();
            }
            for (i = 0; i < TraditionalBinaryPrefix.values().length && n >= TraditionalBinaryPrefix.values()[i].value; ++i) {
            }
            TraditionalBinaryPrefix prefix = TraditionalBinaryPrefix.values()[i - 1];
            if ((n & prefix.bitMask) == 0L) {
                b.append(n >> prefix.bitShift);
            } else {
                String format = "%." + decimalPlaces + "f";
                String s = StringUtils.format(format, (double)n / (double)prefix.value);
                if (s.startsWith("1024")) {
                    prefix = TraditionalBinaryPrefix.values()[i];
                    s = StringUtils.format(format, (double)n / (double)prefix.value);
                }
                b.append(s);
            }
            return b.append(' ').append(prefix.symbol).append(unit).toString();
        }
    }
}

