/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.arrow;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Struct;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.factory.Nd4j;

public class DataBufferStruct
extends Struct {
    private DataBuffer dataBuffer;

    public DataBufferStruct(DataBuffer dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    public DataBufferStruct(ByteBuffer byteBuffer, int offset) {
        this.__init(offset, byteBuffer);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public DataBufferStruct __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public static DataBuffer createFromByteBuffer(ByteBuffer bb, int bb_pos, DataType type, int length) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int elementSize = DataTypeUtil.lengthForDtype((DataType)type);
        DataBuffer ret = Nd4j.createBuffer((ByteBuffer)ByteBuffer.allocateDirect(length * elementSize), (DataType)type, (int)length, (long)0L);
        switch (type) {
            case DOUBLE: {
                int i = 0;
                while ((long)i < ret.length()) {
                    double doubleGet = bb.getDouble(bb.capacity() - bb_pos + i * elementSize);
                    ret.put((long)i, doubleGet);
                    ++i;
                }
                break;
            }
            case FLOAT: {
                int i = 0;
                while ((long)i < ret.length()) {
                    float floatGet = bb.getFloat(bb.capacity() - bb_pos + i * elementSize);
                    ret.put((long)i, floatGet);
                    ++i;
                }
                break;
            }
            case INT: {
                int i = 0;
                while ((long)i < ret.length()) {
                    int intGet = bb.getInt(bb.capacity() - bb_pos + i * elementSize);
                    ret.put((long)i, intGet);
                    ++i;
                }
                break;
            }
            case LONG: {
                int i = 0;
                while ((long)i < ret.length()) {
                    long longGet = bb.getLong(bb.capacity() - bb_pos + i * elementSize);
                    ret.put((long)i, longGet);
                    ++i;
                }
                break;
            }
        }
        return ret;
    }

    public static int createDataBufferStruct(FlatBufferBuilder bufferBuilder, DataBuffer create) {
        bufferBuilder.prep(create.getElementSize(), (int)create.length() * create.getElementSize());
        block6: for (int i = (int)(create.length() - 1L); i >= 0; --i) {
            switch (create.dataType()) {
                case DOUBLE: {
                    double putDouble = create.getDouble((long)i);
                    bufferBuilder.putDouble(putDouble);
                    continue block6;
                }
                case FLOAT: {
                    float putFloat = create.getFloat((long)i);
                    bufferBuilder.putFloat(putFloat);
                    continue block6;
                }
                case INT: {
                    int putInt = create.getInt((long)i);
                    bufferBuilder.putInt(putInt);
                    continue block6;
                }
                case LONG: {
                    long putLong = create.getLong((long)i);
                    bufferBuilder.putLong(putLong);
                }
            }
        }
        return bufferBuilder.offset();
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }
}

