/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.factory.Nd4j;

public class UniformDistribution
extends BaseRandomOp {
    private double from;
    private double to;

    public UniformDistribution() {
    }

    public UniformDistribution(SameDiff sd, double from, double to, long[] shape) {
        super(sd, shape);
        this.from = from;
        this.to = to;
        this.extraArgs = new Object[]{this.from, this.to};
    }

    public UniformDistribution(SameDiff sd, double from, double to, DataType dataType, long[] shape) {
        this(sd, from, to, shape);
        this.dataType = dataType;
    }

    public UniformDistribution(double min, double max, DataType datatype, long ... shape) {
        this(Nd4j.createUninitialized(datatype, shape), min, max);
    }

    public UniformDistribution(@NonNull INDArray z, double from, double to) {
        super(null, null, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        this.from = from;
        this.to = to;
        this.extraArgs = new Object[]{this.from, this.to};
    }

    public UniformDistribution(@NonNull INDArray z) {
        this(z, 0.0, 1.0);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
    }

    public UniformDistribution(@NonNull INDArray z, double to) {
        this(z, 0.0, to);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
    }

    @Override
    public int opNum() {
        return 0;
    }

    @Override
    public String opName() {
        return "distribution_uniform";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "RandomUniformGG";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes == null || inputDataTypes.isEmpty() ? 1 : 0) != 0, (String)"Expected no input datatypes (no args) for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(this.dataType);
    }
}

