/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.PadMode;
import org.nd4j.linalg.api.ops.impl.broadcast.BiasAdd;
import org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNorm;
import org.nd4j.linalg.api.ops.impl.scalar.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.scalar.PRelu;
import org.nd4j.linalg.api.ops.impl.scalar.RectifiedLinear;
import org.nd4j.linalg.api.ops.impl.scalar.Relu6;
import org.nd4j.linalg.api.ops.impl.transforms.Pad;
import org.nd4j.linalg.api.ops.impl.transforms.ReluLayer;
import org.nd4j.linalg.api.ops.impl.transforms.custom.CReLU;
import org.nd4j.linalg.api.ops.impl.transforms.custom.DotProductAttention;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LayerNorm;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LogSoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.custom.MultiHeadDotProductAttention;
import org.nd4j.linalg.api.ops.impl.transforms.custom.SoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.custom.XwPlusB;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.HardTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LeakyReLUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftSignDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftmaxBp;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ELU;
import org.nd4j.linalg.api.ops.impl.transforms.strict.GELU;
import org.nd4j.linalg.api.ops.impl.transforms.strict.HardSigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.strict.HardTanh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.LogSigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.strict.PreciseGELU;
import org.nd4j.linalg.api.ops.impl.transforms.strict.SELU;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Sigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.strict.SoftPlus;
import org.nd4j.linalg.api.ops.impl.transforms.strict.SoftSign;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Swish;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Tanh;
import org.nd4j.linalg.api.ops.random.impl.DropOut;

public class SDNN
extends SDOps {
    public SDNN(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable cReLU(SDVariable x) {
        SDValidation.validateNumerical("CReLU", "x", x);
        return new CReLU(this.sd, x).outputVariable();
    }

    public SDVariable cReLU(String name, SDVariable x) {
        SDValidation.validateNumerical("CReLU", "x", x);
        SDVariable out = new CReLU(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable batchNorm(SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, double epsilon, int ... axis) {
        SDValidation.validateNumerical("batchNorm", "input", input);
        SDValidation.validateNumerical("batchNorm", "mean", mean);
        SDValidation.validateNumerical("batchNorm", "variance", variance);
        SDValidation.validateNumerical("batchNorm", "gamma", gamma);
        SDValidation.validateNumerical("batchNorm", "beta", beta);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        return new BatchNorm(this.sd, input, mean, variance, gamma, beta, epsilon, axis).outputVariable();
    }

    public SDVariable batchNorm(String name, SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, double epsilon, int ... axis) {
        SDValidation.validateNumerical("batchNorm", "input", input);
        SDValidation.validateNumerical("batchNorm", "mean", mean);
        SDValidation.validateNumerical("batchNorm", "variance", variance);
        SDValidation.validateNumerical("batchNorm", "gamma", gamma);
        SDValidation.validateNumerical("batchNorm", "beta", beta);
        Preconditions.checkArgument((axis.length >= 1 ? 1 : 0) != 0, (String)"axis has incorrect size/length. Expected: axis.length >= 1, got %s", (int)axis.length);
        SDVariable out = new BatchNorm(this.sd, input, mean, variance, gamma, beta, epsilon, axis).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable biasAdd(SDVariable input, SDVariable bias, boolean nchw) {
        SDValidation.validateNumerical("biasAdd", "input", input);
        SDValidation.validateNumerical("biasAdd", "bias", bias);
        return new BiasAdd(this.sd, input, bias, nchw).outputVariable();
    }

    public SDVariable biasAdd(String name, SDVariable input, SDVariable bias, boolean nchw) {
        SDValidation.validateNumerical("biasAdd", "input", input);
        SDValidation.validateNumerical("biasAdd", "bias", bias);
        SDVariable out = new BiasAdd(this.sd, input, bias, nchw).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable dotProductAttention(SDVariable queries, SDVariable keys, SDVariable values, SDVariable mask, boolean scaled) {
        SDValidation.validateNumerical("dotProductAttention", "queries", queries);
        SDValidation.validateNumerical("dotProductAttention", "keys", keys);
        SDValidation.validateNumerical("dotProductAttention", "values", values);
        SDValidation.validateNumerical("dotProductAttention", "mask", mask);
        return new DotProductAttention(this.sd, queries, keys, values, mask, scaled, false).outputVariable();
    }

    public SDVariable dotProductAttention(String name, SDVariable queries, SDVariable keys, SDVariable values, SDVariable mask, boolean scaled) {
        SDValidation.validateNumerical("dotProductAttention", "queries", queries);
        SDValidation.validateNumerical("dotProductAttention", "keys", keys);
        SDValidation.validateNumerical("dotProductAttention", "values", values);
        SDValidation.validateNumerical("dotProductAttention", "mask", mask);
        SDVariable out = new DotProductAttention(this.sd, queries, keys, values, mask, scaled, false).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable dropout(SDVariable input, double inputRetainProbability) {
        SDValidation.validateNumerical("dropout", "input", input);
        return new DropOut(this.sd, input, inputRetainProbability).outputVariable();
    }

    public SDVariable dropout(String name, SDVariable input, double inputRetainProbability) {
        SDValidation.validateNumerical("dropout", "input", input);
        SDVariable out = new DropOut(this.sd, input, inputRetainProbability).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable elu(SDVariable x) {
        SDValidation.validateNumerical("elu", "x", x);
        return new ELU(this.sd, x).outputVariable();
    }

    public SDVariable elu(String name, SDVariable x) {
        SDValidation.validateNumerical("elu", "x", x);
        SDVariable out = new ELU(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable gelu(SDVariable x) {
        SDValidation.validateNumerical("gelu", "x", x);
        return new GELU(this.sd, x).outputVariable();
    }

    public SDVariable gelu(String name, SDVariable x) {
        SDValidation.validateNumerical("gelu", "x", x);
        SDVariable out = new GELU(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable hardSigmoid(SDVariable x) {
        SDValidation.validateNumerical("hardSigmoid", "x", x);
        return new HardSigmoid(this.sd, x).outputVariable();
    }

    public SDVariable hardSigmoid(String name, SDVariable x) {
        SDValidation.validateNumerical("hardSigmoid", "x", x);
        SDVariable out = new HardSigmoid(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable hardTanh(SDVariable x) {
        SDValidation.validateNumerical("hardTanh", "x", x);
        return new HardTanh(this.sd, x).outputVariable();
    }

    public SDVariable hardTanh(String name, SDVariable x) {
        SDValidation.validateNumerical("hardTanh", "x", x);
        SDVariable out = new HardTanh(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable hardTanhDerivative(SDVariable x) {
        SDValidation.validateNumerical("hardTanhDerivative", "x", x);
        return new HardTanhDerivative(this.sd, x).outputVariable();
    }

    public SDVariable hardTanhDerivative(String name, SDVariable x) {
        SDValidation.validateNumerical("hardTanhDerivative", "x", x);
        SDVariable out = new HardTanhDerivative(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable layerNorm(SDVariable input, SDVariable gain, SDVariable bias, boolean channelsFirst, int ... dimensions) {
        SDValidation.validateNumerical("layerNorm", "input", input);
        SDValidation.validateNumerical("layerNorm", "gain", gain);
        SDValidation.validateNumerical("layerNorm", "bias", bias);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return new LayerNorm(this.sd, input, gain, bias, channelsFirst, dimensions).outputVariable();
    }

    public SDVariable layerNorm(String name, SDVariable input, SDVariable gain, SDVariable bias, boolean channelsFirst, int ... dimensions) {
        SDValidation.validateNumerical("layerNorm", "input", input);
        SDValidation.validateNumerical("layerNorm", "gain", gain);
        SDValidation.validateNumerical("layerNorm", "bias", bias);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        SDVariable out = new LayerNorm(this.sd, input, gain, bias, channelsFirst, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable layerNorm(SDVariable input, SDVariable gain, boolean channelsFirst, int ... dimensions) {
        SDValidation.validateNumerical("layerNorm", "input", input);
        SDValidation.validateNumerical("layerNorm", "gain", gain);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        return new LayerNorm(this.sd, input, gain, null, channelsFirst, dimensions).outputVariable();
    }

    public SDVariable layerNorm(String name, SDVariable input, SDVariable gain, boolean channelsFirst, int ... dimensions) {
        SDValidation.validateNumerical("layerNorm", "input", input);
        SDValidation.validateNumerical("layerNorm", "gain", gain);
        Preconditions.checkArgument((dimensions.length >= 1 ? 1 : 0) != 0, (String)"dimensions has incorrect size/length. Expected: dimensions.length >= 1, got %s", (int)dimensions.length);
        SDVariable out = new LayerNorm(this.sd, input, gain, null, channelsFirst, dimensions).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable leakyRelu(SDVariable x, double alpha) {
        SDValidation.validateNumerical("leakyRelu", "x", x);
        return new LeakyReLU(this.sd, x, alpha).outputVariable();
    }

    public SDVariable leakyRelu(String name, SDVariable x, double alpha) {
        SDValidation.validateNumerical("leakyRelu", "x", x);
        SDVariable out = new LeakyReLU(this.sd, x, alpha).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable leakyReluDerivative(SDVariable x, double alpha) {
        SDValidation.validateNumerical("leakyReluDerivative", "x", x);
        return new LeakyReLUDerivative(this.sd, x, alpha).outputVariable();
    }

    public SDVariable leakyReluDerivative(String name, SDVariable x, double alpha) {
        SDValidation.validateNumerical("leakyReluDerivative", "x", x);
        SDVariable out = new LeakyReLUDerivative(this.sd, x, alpha).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable linear(SDVariable input, SDVariable weights, SDVariable bias) {
        SDValidation.validateNumerical("linear", "input", input);
        SDValidation.validateNumerical("linear", "weights", weights);
        SDValidation.validateNumerical("linear", "bias", bias);
        return new XwPlusB(this.sd, input, weights, bias).outputVariable();
    }

    public SDVariable linear(String name, SDVariable input, SDVariable weights, SDVariable bias) {
        SDValidation.validateNumerical("linear", "input", input);
        SDValidation.validateNumerical("linear", "weights", weights);
        SDValidation.validateNumerical("linear", "bias", bias);
        SDVariable out = new XwPlusB(this.sd, input, weights, bias).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logSigmoid(SDVariable x) {
        SDValidation.validateNumerical("logSigmoid", "x", x);
        return new LogSigmoid(this.sd, x).outputVariable();
    }

    public SDVariable logSigmoid(String name, SDVariable x) {
        SDValidation.validateNumerical("logSigmoid", "x", x);
        SDVariable out = new LogSigmoid(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logSoftmax(SDVariable x) {
        SDValidation.validateNumerical("logSoftmax", "x", x);
        return new LogSoftMax(this.sd, x).outputVariable();
    }

    public SDVariable logSoftmax(String name, SDVariable x) {
        SDValidation.validateNumerical("logSoftmax", "x", x);
        SDVariable out = new LogSoftMax(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logSoftmax(SDVariable x, int dimension) {
        SDValidation.validateNumerical("logSoftmax", "x", x);
        return new LogSoftMax(this.sd, x, dimension).outputVariable();
    }

    public SDVariable logSoftmax(String name, SDVariable x, int dimension) {
        SDValidation.validateNumerical("logSoftmax", "x", x);
        SDVariable out = new LogSoftMax(this.sd, x, dimension).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable multiHeadDotProductAttention(SDVariable queries, SDVariable keys, SDVariable values, SDVariable Wq, SDVariable Wk, SDVariable Wv, SDVariable Wo, SDVariable mask, boolean scaled) {
        SDValidation.validateNumerical("multiHeadDotProductAttention", "queries", queries);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "keys", keys);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "values", values);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wq", Wq);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wk", Wk);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wv", Wv);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wo", Wo);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "mask", mask);
        return new MultiHeadDotProductAttention(this.sd, queries, keys, values, Wq, Wk, Wv, Wo, mask, scaled, false).outputVariable();
    }

    public SDVariable multiHeadDotProductAttention(String name, SDVariable queries, SDVariable keys, SDVariable values, SDVariable Wq, SDVariable Wk, SDVariable Wv, SDVariable Wo, SDVariable mask, boolean scaled) {
        SDValidation.validateNumerical("multiHeadDotProductAttention", "queries", queries);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "keys", keys);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "values", values);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wq", Wq);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wk", Wk);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wv", Wv);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "Wo", Wo);
        SDValidation.validateNumerical("multiHeadDotProductAttention", "mask", mask);
        SDVariable out = new MultiHeadDotProductAttention(this.sd, queries, keys, values, Wq, Wk, Wv, Wo, mask, scaled, false).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable pad(SDVariable input, SDVariable padding, PadMode PadMode2, double constant) {
        SDValidation.validateNumerical("pad", "input", input);
        SDValidation.validateNumerical("pad", "padding", padding);
        return new Pad(this.sd, input, padding, PadMode2, constant).outputVariable();
    }

    public SDVariable pad(String name, SDVariable input, SDVariable padding, PadMode PadMode2, double constant) {
        SDValidation.validateNumerical("pad", "input", input);
        SDValidation.validateNumerical("pad", "padding", padding);
        SDVariable out = new Pad(this.sd, input, padding, PadMode2, constant).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable pad(SDVariable input, SDVariable padding, double constant) {
        SDValidation.validateNumerical("pad", "input", input);
        SDValidation.validateNumerical("pad", "padding", padding);
        return new Pad(this.sd, input, padding, PadMode.CONSTANT, constant).outputVariable();
    }

    public SDVariable pad(String name, SDVariable input, SDVariable padding, double constant) {
        SDValidation.validateNumerical("pad", "input", input);
        SDValidation.validateNumerical("pad", "padding", padding);
        SDVariable out = new Pad(this.sd, input, padding, PadMode.CONSTANT, constant).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable preciseGelu(SDVariable x) {
        SDValidation.validateNumerical("preciseGelu", "x", x);
        return new PreciseGELU(this.sd, x).outputVariable();
    }

    public SDVariable preciseGelu(String name, SDVariable x) {
        SDValidation.validateNumerical("preciseGelu", "x", x);
        SDVariable out = new PreciseGELU(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable prelu(SDVariable input, SDVariable alpha, int ... sharedAxes) {
        SDValidation.validateNumerical("prelu", "input", input);
        SDValidation.validateNumerical("prelu", "alpha", alpha);
        Preconditions.checkArgument((sharedAxes.length >= 1 ? 1 : 0) != 0, (String)"sharedAxes has incorrect size/length. Expected: sharedAxes.length >= 1, got %s", (int)sharedAxes.length);
        return new PRelu(this.sd, input, alpha, sharedAxes).outputVariable();
    }

    public SDVariable prelu(String name, SDVariable input, SDVariable alpha, int ... sharedAxes) {
        SDValidation.validateNumerical("prelu", "input", input);
        SDValidation.validateNumerical("prelu", "alpha", alpha);
        Preconditions.checkArgument((sharedAxes.length >= 1 ? 1 : 0) != 0, (String)"sharedAxes has incorrect size/length. Expected: sharedAxes.length >= 1, got %s", (int)sharedAxes.length);
        SDVariable out = new PRelu(this.sd, input, alpha, sharedAxes).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable relu(SDVariable x, double cutoff) {
        SDValidation.validateNumerical("relu", "x", x);
        return new RectifiedLinear(this.sd, x, cutoff).outputVariable();
    }

    public SDVariable relu(String name, SDVariable x, double cutoff) {
        SDValidation.validateNumerical("relu", "x", x);
        SDVariable out = new RectifiedLinear(this.sd, x, cutoff).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable relu6(SDVariable x, double cutoff) {
        SDValidation.validateNumerical("relu6", "x", x);
        return new Relu6(this.sd, x, cutoff).outputVariable();
    }

    public SDVariable relu6(String name, SDVariable x, double cutoff) {
        SDValidation.validateNumerical("relu6", "x", x);
        SDVariable out = new Relu6(this.sd, x, cutoff).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable reluLayer(SDVariable input, SDVariable weights, SDVariable bias) {
        SDValidation.validateNumerical("reluLayer", "input", input);
        SDValidation.validateNumerical("reluLayer", "weights", weights);
        SDValidation.validateNumerical("reluLayer", "bias", bias);
        return new ReluLayer(this.sd, input, weights, bias).outputVariable();
    }

    public SDVariable reluLayer(String name, SDVariable input, SDVariable weights, SDVariable bias) {
        SDValidation.validateNumerical("reluLayer", "input", input);
        SDValidation.validateNumerical("reluLayer", "weights", weights);
        SDValidation.validateNumerical("reluLayer", "bias", bias);
        SDVariable out = new ReluLayer(this.sd, input, weights, bias).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable selu(SDVariable x) {
        SDValidation.validateNumerical("selu", "x", x);
        return new SELU(this.sd, x).outputVariable();
    }

    public SDVariable selu(String name, SDVariable x) {
        SDValidation.validateNumerical("selu", "x", x);
        SDVariable out = new SELU(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sigmoid(SDVariable x) {
        SDValidation.validateNumerical("sigmoid", "x", x);
        return new Sigmoid(this.sd, x).outputVariable();
    }

    public SDVariable sigmoid(String name, SDVariable x) {
        SDValidation.validateNumerical("sigmoid", "x", x);
        SDVariable out = new Sigmoid(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sigmoidDerivative(SDVariable x, SDVariable wrt) {
        SDValidation.validateNumerical("sigmoidDerivative", "x", x);
        SDValidation.validateNumerical("sigmoidDerivative", "wrt", wrt);
        return new SigmoidDerivative(this.sd, x, wrt).outputVariable();
    }

    public SDVariable sigmoidDerivative(String name, SDVariable x, SDVariable wrt) {
        SDValidation.validateNumerical("sigmoidDerivative", "x", x);
        SDValidation.validateNumerical("sigmoidDerivative", "wrt", wrt);
        SDVariable out = new SigmoidDerivative(this.sd, x, wrt).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softmax(SDVariable x, int dimension) {
        SDValidation.validateNumerical("softmax", "x", x);
        return new SoftMax(this.sd, x, dimension).outputVariable();
    }

    public SDVariable softmax(String name, SDVariable x, int dimension) {
        SDValidation.validateNumerical("softmax", "x", x);
        SDVariable out = new SoftMax(this.sd, x, dimension).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softmax(SDVariable x) {
        SDValidation.validateNumerical("softmax", "x", x);
        return new SoftMax(this.sd, x, -1).outputVariable();
    }

    public SDVariable softmax(String name, SDVariable x) {
        SDValidation.validateNumerical("softmax", "x", x);
        SDVariable out = new SoftMax(this.sd, x, -1).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softmaxDerivative(SDVariable x, SDVariable wrt, int dimension) {
        SDValidation.validateNumerical("softmaxDerivative", "x", x);
        SDValidation.validateNumerical("softmaxDerivative", "wrt", wrt);
        return new SoftmaxBp(this.sd, x, wrt, (Integer)dimension).outputVariable();
    }

    public SDVariable softmaxDerivative(String name, SDVariable x, SDVariable wrt, int dimension) {
        SDValidation.validateNumerical("softmaxDerivative", "x", x);
        SDValidation.validateNumerical("softmaxDerivative", "wrt", wrt);
        SDVariable out = new SoftmaxBp(this.sd, x, wrt, (Integer)dimension).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softplus(SDVariable x) {
        SDValidation.validateNumerical("softplus", "x", x);
        return new SoftPlus(this.sd, x).outputVariable();
    }

    public SDVariable softplus(String name, SDVariable x) {
        SDValidation.validateNumerical("softplus", "x", x);
        SDVariable out = new SoftPlus(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softsign(SDVariable x) {
        SDValidation.validateNumerical("softsign", "x", x);
        return new SoftSign(this.sd, x).outputVariable();
    }

    public SDVariable softsign(String name, SDVariable x) {
        SDValidation.validateNumerical("softsign", "x", x);
        SDVariable out = new SoftSign(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softsignDerivative(SDVariable x) {
        SDValidation.validateNumerical("softsignDerivative", "x", x);
        return new SoftSignDerivative(this.sd, x).outputVariable();
    }

    public SDVariable softsignDerivative(String name, SDVariable x) {
        SDValidation.validateNumerical("softsignDerivative", "x", x);
        SDVariable out = new SoftSignDerivative(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable swish(SDVariable x) {
        SDValidation.validateNumerical("swish", "x", x);
        return new Swish(this.sd, x).outputVariable();
    }

    public SDVariable swish(String name, SDVariable x) {
        SDValidation.validateNumerical("swish", "x", x);
        SDVariable out = new Swish(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable tanh(SDVariable x) {
        SDValidation.validateNumerical("tanh", "x", x);
        return new Tanh(this.sd, x).outputVariable();
    }

    public SDVariable tanh(String name, SDVariable x) {
        SDValidation.validateNumerical("tanh", "x", x);
        SDVariable out = new Tanh(this.sd, x).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

