/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.factory.Nd4j;

public class LogNormalDistribution
extends BaseRandomOp {
    private double mean;
    private double stddev;

    public LogNormalDistribution() {
    }

    public LogNormalDistribution(SameDiff sd, double mean, double stdev, long ... shape) {
        super(sd, shape);
        this.mean = mean;
        this.stddev = stdev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public LogNormalDistribution(double mean, double stddev, DataType datatype, long ... shape) {
        this(Nd4j.createUninitialized(datatype, shape), mean, stddev);
    }

    public LogNormalDistribution(@NonNull INDArray z, double mean, double stddev) {
        super(z, z, z);
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        this.mean = mean;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public LogNormalDistribution(@NonNull INDArray z, @NonNull INDArray means, double stddev) {
        super(z, means, z);
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        if (means == null) {
            throw new NullPointerException("means is marked @NonNull but is null");
        }
        if (z.length() != means.length()) {
            throw new IllegalStateException("Result length should be equal to provided Means length");
        }
        if (means.elementWiseStride() < 1) {
            throw new IllegalStateException("Means array can't have negative EWS");
        }
        this.mean = 0.0;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public LogNormalDistribution(@NonNull INDArray z) {
        this(z, 0.0, 1.0);
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
    }

    public LogNormalDistribution(@NonNull INDArray z, double stddev) {
        this(z, 0.0, stddev);
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public int opNum() {
        return 10;
    }

    @Override
    public String opName() {
        return "distribution_lognormal";
    }

    @Override
    public void setZ(INDArray z) {
        this.x = z;
        this.y = z;
        this.z = z;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes == null || inputDataTypes.isEmpty() ? 1 : 0) != 0, (String)"Expected no input datatypes (no args) for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(DataType.DOUBLE);
    }
}

