/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape;

import java.util.Arrays;

public class SparseDescriptor {
    int[] flags;
    long[] sparseOffsets;
    int[] hiddenDimension;
    int underlyingRank;

    public SparseDescriptor(int[] flags, long[] sparseOffsets, int[] hiddenDimension, int underlyingRank) {
        this.flags = Arrays.copyOf(flags, flags.length);
        this.sparseOffsets = Arrays.copyOf(sparseOffsets, sparseOffsets.length);
        this.hiddenDimension = Arrays.copyOf(hiddenDimension, hiddenDimension.length);
        this.underlyingRank = underlyingRank;
    }

    public int hashCode() {
        int result = this.underlyingRank;
        result = 31 * result + Arrays.hashCode(this.flags);
        result = 31 * result + Arrays.hashCode(this.sparseOffsets);
        result = 31 * result + Arrays.hashCode(this.hiddenDimension);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseDescriptor that = (SparseDescriptor)o;
        if (!Arrays.equals(this.flags, that.flags)) {
            return false;
        }
        if (!Arrays.equals(this.sparseOffsets, that.sparseOffsets)) {
            return false;
        }
        if (!Arrays.equals(this.hiddenDimension, that.hiddenDimension)) {
            return false;
        }
        return this.underlyingRank == that.underlyingRank;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.flags.length).append(",").append(Arrays.toString(this.flags)).append(",").append(this.sparseOffsets.length).append(",").append(Arrays.toString(this.sparseOffsets)).append(",").append(this.hiddenDimension.length).append(",").append(Arrays.toString(this.hiddenDimension)).append(",").append(this.underlyingRank);
        String result = builder.toString().replaceAll("\\]", "").replaceAll("\\[", "");
        result = "[" + result + "]";
        return result;
    }
}

