/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class FakeQuantWithMinMaxVars
extends DynamicCustomOp {
    protected boolean narrowRange;
    protected int numBits;

    public FakeQuantWithMinMaxVars(SameDiff sd, SDVariable input, SDVariable min, SDVariable max, boolean narrowRange, int numBits) {
        super(sd, new SDVariable[]{input, min, max});
        Preconditions.checkState((numBits >= 2 && numBits <= 16 ? 1 : 0) != 0, (String)"NumBits arg must be in range 2 to 16 inclusive, got %s", (int)numBits);
        this.narrowRange = narrowRange;
        this.numBits = numBits;
        this.addArgs();
    }

    public FakeQuantWithMinMaxVars() {
    }

    protected void addArgs() {
        this.iArguments.clear();
        this.addIArgument(this.numBits, this.narrowRange ? 1 : 0);
    }

    @Override
    public String opName() {
        return "fake_quant_with_min_max_vars";
    }

    @Override
    public String tensorflowName() {
        return "FakeQuantWithMinMaxVars";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("narrow_range")) {
            this.narrowRange = attributesForNode.get("narrow_range").getB();
        }
        this.numBits = (int)attributesForNode.get("num_bits").getI();
        this.addArgs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 3 ? 1 : 0) != 0, (String)"Expected exactly 3 inputs, got %s", inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Arrays.asList(this.sameDiff.zerosLike(this.arg(0)), this.sameDiff.zerosLike(this.arg(1)), this.sameDiff.zerosLike(this.arg(2)));
    }
}

