/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Stack
extends DynamicCustomOp {
    protected int jaxis;

    public Stack() {
    }

    public Stack(INDArray[] inputs, INDArray output, int axis) {
        INDArray[] iNDArrayArray;
        if (output == null) {
            iNDArrayArray = null;
        } else {
            INDArray[] iNDArrayArray2 = new INDArray[1];
            iNDArrayArray = iNDArrayArray2;
            iNDArrayArray2[0] = output;
        }
        super(null, inputs, iNDArrayArray, null, (List<Integer>)null);
        this.jaxis = axis;
        this.addArgs();
    }

    public Stack(SameDiff sameDiff, SDVariable[] values, int axis) {
        super(null, sameDiff, values, false);
        this.jaxis = axis;
        this.addArgs();
    }

    public void addArgs() {
        this.addIArgument(this.jaxis);
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "stack";
    }

    @Override
    public String toString() {
        return this.opName();
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Pack", "Stack"};
    }

    @Override
    public String opName() {
        return "stack";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        throw new UnsupportedOperationException("No analog found for onnx for " + this.opName());
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping axisMapping = PropertyMapping.builder().onnxAttrName("axis").tfAttrName("axis").propertyNames(new String[]{"jaxis"}).build();
        map.put("jaxis", axisMapping);
        for (String name : this.tensorflowNames()) {
            ret.put(name, map);
        }
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Arrays.asList(this.f().unstack(f1.get(0), this.jaxis, this.args().length));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        DataType first = dataTypes.get(0);
        for (int i = 1; i < dataTypes.size(); ++i) {
            DataType dt = dataTypes.get(i);
            Preconditions.checkState((first == dt ? 1 : 0) != 0, (String)"All inputs must have same datatype - got %s and %s for inputs 0 and %s respectively", (Object)first, (Object)dt, (Object)i);
        }
        return Collections.singletonList(first);
    }
}

