/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.util.ConvConfigUtil;

public class Conv1DConfig
extends BaseConvolutionConfig {
    public static final String NCW = "NCW";
    public static final String NWC = "NWC";
    private long k;
    private long s;
    private long p;
    private String dataFormat;
    private boolean isSameMode;

    public Conv1DConfig(long k, long s, long p, String dataFormat, boolean isSameMode) {
        this.k = k;
        this.s = s;
        this.p = p;
        this.dataFormat = dataFormat;
        this.isSameMode = isSameMode;
        this.validate();
    }

    public boolean isNWC() {
        Preconditions.checkState((this.dataFormat.equalsIgnoreCase(NCW) || this.dataFormat.equalsIgnoreCase(NWC) ? 1 : 0) != 0, (String)"Data format must be one of %s or %s, got %s", (Object)NCW, (Object)NWC, (Object)this.dataFormat);
        return this.dataFormat.equalsIgnoreCase(NWC);
    }

    public void isNWC(boolean isNWC) {
        this.dataFormat = isNWC ? NWC : NCW;
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("k", this.k);
        ret.put("s", this.s);
        ret.put("p", this.p);
        ret.put("isSameMode", this.isSameMode);
        ret.put("dataFormat", this.dataFormat);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate1D(this.k, this.s, this.p);
        Preconditions.checkArgument((this.dataFormat != null ? 1 : 0) != 0, (String)"Data format can't be null");
    }

    private static long $default$k() {
        return -1L;
    }

    private static long $default$s() {
        return 1L;
    }

    private static long $default$p() {
        return 0L;
    }

    private static String $default$dataFormat() {
        return NCW;
    }

    public static Conv1DConfigBuilder builder() {
        return new Conv1DConfigBuilder();
    }

    public long getK() {
        return this.k;
    }

    public long getS() {
        return this.s;
    }

    public long getP() {
        return this.p;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public boolean isSameMode() {
        return this.isSameMode;
    }

    public void setK(long k) {
        this.k = k;
    }

    public void setS(long s) {
        this.s = s;
    }

    public void setP(long p) {
        this.p = p;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setSameMode(boolean isSameMode) {
        this.isSameMode = isSameMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conv1DConfig)) {
            return false;
        }
        Conv1DConfig other = (Conv1DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getK() != other.getK()) {
            return false;
        }
        if (this.getS() != other.getS()) {
            return false;
        }
        if (this.getP() != other.getP()) {
            return false;
        }
        String this$dataFormat = this.getDataFormat();
        String other$dataFormat = other.getDataFormat();
        if (this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat)) {
            return false;
        }
        return this.isSameMode() == other.isSameMode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conv1DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $k = this.getK();
        result = result * 59 + (int)($k >>> 32 ^ $k);
        long $s = this.getS();
        result = result * 59 + (int)($s >>> 32 ^ $s);
        long $p = this.getP();
        result = result * 59 + (int)($p >>> 32 ^ $p);
        String $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        result = result * 59 + (this.isSameMode() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Conv1DConfig(k=" + this.getK() + ", s=" + this.getS() + ", p=" + this.getP() + ", dataFormat=" + this.getDataFormat() + ", isSameMode=" + this.isSameMode() + ")";
    }

    public Conv1DConfig() {
        this.k = Conv1DConfig.$default$k();
        this.s = Conv1DConfig.$default$s();
        this.p = Conv1DConfig.$default$p();
        this.dataFormat = Conv1DConfig.$default$dataFormat();
    }

    public static class Conv1DConfigBuilder {
        private boolean k$set;
        private long k;
        private boolean s$set;
        private long s;
        private boolean p$set;
        private long p;
        private boolean dataFormat$set;
        private String dataFormat;
        private boolean isSameMode;

        Conv1DConfigBuilder() {
        }

        public Conv1DConfigBuilder k(long k) {
            this.k = k;
            this.k$set = true;
            return this;
        }

        public Conv1DConfigBuilder s(long s) {
            this.s = s;
            this.s$set = true;
            return this;
        }

        public Conv1DConfigBuilder p(long p) {
            this.p = p;
            this.p$set = true;
            return this;
        }

        public Conv1DConfigBuilder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            this.dataFormat$set = true;
            return this;
        }

        public Conv1DConfigBuilder isSameMode(boolean isSameMode) {
            this.isSameMode = isSameMode;
            return this;
        }

        public Conv1DConfig build() {
            long k = this.k;
            if (!this.k$set) {
                k = Conv1DConfig.$default$k();
            }
            long s = this.s;
            if (!this.s$set) {
                s = Conv1DConfig.$default$s();
            }
            long p = this.p;
            if (!this.p$set) {
                p = Conv1DConfig.$default$p();
            }
            String dataFormat = this.dataFormat;
            if (!this.dataFormat$set) {
                dataFormat = Conv1DConfig.$default$dataFormat();
            }
            return new Conv1DConfig(k, s, p, dataFormat, this.isSameMode);
        }

        public String toString() {
            return "Conv1DConfig.Conv1DConfigBuilder(k=" + this.k + ", s=" + this.s + ", p=" + this.p + ", dataFormat=" + this.dataFormat + ", isSameMode=" + this.isSameMode + ")";
        }
    }
}

