/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conv1D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Conv1D.class);
    protected Conv1DConfig config;
    private static final String INVALID_CONFIGURATION = "Invalid Conv1D configuration : s = %s p = %s ";

    public Conv1D(SameDiff sameDiff, SDVariable[] inputFunctions, Conv1DConfig config) {
        super(sameDiff, inputFunctions);
        this.initConfig(config);
    }

    public Conv1D(INDArray[] inputs, INDArray[] outputs, Conv1DConfig config) {
        super(inputs, outputs);
        this.initConfig(config);
    }

    public Conv1D(@NonNull INDArray input, @NonNull INDArray weights, INDArray bias, INDArray output, @NonNull Conv1DConfig config) {
        this(Conv1D.wrapFilterNull(input, weights, bias), Conv1D.wrapOrNull(output), config);
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
    }

    private void initConfig(Conv1DConfig config) {
        this.config = config;
        Preconditions.checkState((config.getS() >= 1L && config.getP() >= 0L ? 1 : 0) != 0, (String)INVALID_CONFIGURATION, (long)config.getS(), (long)config.getP());
        this.addArgs();
    }

    protected void addArgs() {
        if (this.config == null) {
            this.config = Conv1DConfig.builder().build();
        }
        this.addIArgument(this.config.getK(), this.config.getS(), this.config.getP(), ArrayUtil.fromBoolean((boolean)this.config.isSameMode()), ArrayUtil.fromBoolean((boolean)this.config.isNWC()));
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = Conv1DConfig.builder().s((Long)this.iArguments.get(0)).p((Long)this.iArguments.get(1)).isSameMode((Long)this.iArguments.get(2) == 1L).dataFormat((Long)this.iArguments.get(3) == 1L ? "NCW" : "NWC").build();
        }
        return this.config.getValue(property);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String opName() {
        return "conv1d";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No ONNX op name found for: " + this.getClass().getName());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Conv1DBuilder sameDiffBuilder() {
        return new Conv1DBuilder();
    }

    public Conv1DConfig getConfig() {
        return this.config;
    }

    public Conv1D() {
    }

    public static class Conv1DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private Conv1DConfig config;

        Conv1DBuilder() {
        }

        public Conv1DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Conv1DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Conv1DBuilder config(Conv1DConfig config) {
            this.config = config;
            return this;
        }

        public Conv1D build() {
            return new Conv1D(this.sameDiff, this.inputFunctions, this.config);
        }

        public String toString() {
            return "Conv1D.Conv1DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", config=" + this.config + ")";
        }
    }
}

