/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformStrictOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public abstract class BaseTransformStrictOp
extends BaseTransformOp
implements TransformStrictOp {
    public BaseTransformStrictOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2) {
        super(sameDiff, i_v1, i_v2);
    }

    public BaseTransformStrictOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace) {
        super(sameDiff, i_v1, i_v2, inPlace);
    }

    public BaseTransformStrictOp(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
    }

    public BaseTransformStrictOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        super(sameDiff, i_v, inPlace);
    }

    public BaseTransformStrictOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
    }

    public BaseTransformStrictOp(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs) {
        super(sameDiff, i_v, extraArgs);
    }

    public BaseTransformStrictOp(INDArray x, INDArray z) {
        super(x, z);
    }

    public BaseTransformStrictOp() {
    }

    public BaseTransformStrictOp(INDArray x) {
        super(x);
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.TRANSFORM_STRICT;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.TRANSFORM_STRICT;
    }

    @Override
    public DataType resultType() {
        return this.x().dataType();
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        Preconditions.checkArgument((boolean)this.x().isR(), (String)"Op.X must be one of floating types: x.datatype=%s for op %s", (Object)this.x().dataType(), this.getClass());
        if (this.y() != null) {
            Preconditions.checkArgument((boolean)this.y().isR(), (String)"Op.Y must be one of floating types: y.datatype=%s for op %s", (Object)this.y().dataType(), this.getClass());
            if (!experimentalMode) {
                Preconditions.checkArgument((this.x.dataType() == this.y.dataType() ? 1 : 0) != 0, (String)"Op.X must have same data type as Op.Y");
            }
        }
        if (this.z() != null) {
            Preconditions.checkArgument((this.z().dataType() == this.x().dataType() ? 1 : 0) != 0, (String)"Op.Z must have the same type as Op.X: x.datatype=%s, z.datatype=%s for op %s", (Object)this.x.dataType(), (Object)this.z.dataType(), this.getClass());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(this.x.shape(), this.x.dataType()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        Preconditions.checkState((boolean)dataTypes.get(0).isFPType(), (String)"Only floating point types are supported for strict tranform ops - got %s", (Object)dataTypes.get(0));
        return dataTypes;
    }
}

