/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformSameOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public abstract class BaseTransformSameOp
extends BaseTransformOp
implements TransformSameOp {
    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2) {
        super(sameDiff, i_v1, i_v2);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace) {
        super(sameDiff, i_v1, i_v2, inPlace);
    }

    public BaseTransformSameOp(SameDiff sameDiff) {
        super(sameDiff);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, Object[] extraArgs) {
        super(sameDiff, i_v1, i_v2, extraArgs);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        super(sameDiff, i_v, inPlace);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
    }

    public BaseTransformSameOp(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs) {
        super(sameDiff, i_v, extraArgs);
    }

    public BaseTransformSameOp(INDArray x, INDArray z) {
        super(x, z);
    }

    public BaseTransformSameOp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z);
    }

    public BaseTransformSameOp() {
    }

    public BaseTransformSameOp(INDArray x) {
        super(x);
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.TRANSFORM_SAME;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.TRANSFORM_SAME;
    }

    @Override
    public DataType resultType() {
        return this.x().dataType();
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        if (this.y() != null) {
            Preconditions.checkArgument((this.x().dataType() == this.y().dataType() ? 1 : 0) != 0, (String)"Op.X type must be the same as Op.Y type: x.datatype=%s, y.datatype=%s for op %s", (Object)this.x().dataType(), (Object)this.y().dataType(), this.getClass());
        }
        if (this.z() != null) {
            Preconditions.checkArgument((this.z().dataType() == this.x().dataType() ? 1 : 0) != 0, (String)"Op.Z must be the same as Op.X type: x.datatype=%s, z.datatype=%s for op %s", (Object)this.x().dataType(), (Object)this.z.dataType(), this.getClass());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(this.x.shape(), this.x.dataType()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        return dataTypes;
    }
}

