/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseSparseNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SparseFormat;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndexAll;
import org.nd4j.linalg.indexing.PointIndex;

public abstract class BaseSparseNDArrayCSR
extends BaseSparseNDArray {
    protected static final SparseFormat format = SparseFormat.CSR;
    protected volatile transient DataBuffer values;
    protected volatile transient DataBuffer columnsPointers;
    protected volatile transient DataBuffer pointerB;
    protected volatile transient DataBuffer pointerE;

    public BaseSparseNDArrayCSR(double[] data, int[] columnsPointers, int[] pointerB, int[] pointerE, long[] shape) {
        Preconditions.checkArgument((data.length == columnsPointers.length ? 1 : 0) != 0);
        Preconditions.checkArgument((pointerB.length == pointerE.length ? 1 : 0) != 0);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, Nd4j.dataType()));
        this.init(shape);
        int valuesSpace = (int)((double)data.length * 2.0);
        this.values = Nd4j.getDataBufferFactory().createDouble((long)valuesSpace);
        this.values.setData(data);
        this.columnsPointers = Nd4j.getDataBufferFactory().createInt((long)valuesSpace);
        this.columnsPointers.setData(columnsPointers);
        this.length = columnsPointers.length;
        long pointersSpace = this.rows;
        this.pointerB = Nd4j.getDataBufferFactory().createInt(pointersSpace);
        this.pointerB.setData(pointerB);
        this.pointerE = Nd4j.getDataBufferFactory().createInt(pointersSpace);
        this.pointerE.setData(pointerE);
    }

    public BaseSparseNDArrayCSR(float[] data, int[] columnsPointers, int[] pointerB, int[] pointerE, long[] shape) {
        this(Nd4j.createBuffer(data), columnsPointers, pointerB, pointerE, shape);
    }

    public BaseSparseNDArrayCSR(DataBuffer data, int[] columnsPointers, int[] pointerB, int[] pointerE, long[] shape) {
        Preconditions.checkArgument((pointerB.length == pointerE.length ? 1 : 0) != 0);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, Nd4j.dataType()));
        this.init(shape);
        this.values = data;
        this.columnsPointers = Nd4j.getDataBufferFactory().createInt(data.length());
        this.columnsPointers.setData(columnsPointers);
        this.length = columnsPointers.length;
        long pointersSpace = this.rows;
        this.pointerB = Nd4j.getDataBufferFactory().createInt(pointersSpace);
        this.pointerB.setData(pointerB);
        this.pointerE = Nd4j.getDataBufferFactory().createInt(pointersSpace);
        this.pointerE.setData(pointerE);
    }

    public INDArray putScalar(int row, int col, double value) {
        Preconditions.checkArgument(((long)row < this.rows && 0L <= this.rows ? 1 : 0) != 0);
        Preconditions.checkArgument(((long)col < this.columns && 0L <= this.columns ? 1 : 0) != 0);
        int idx = this.pointerB.getInt((long)row);
        int idxNextRow = this.pointerE.getInt((long)row);
        while (this.columnsPointers.getInt((long)idx) < col && this.columnsPointers.getInt((long)idx) < idxNextRow) {
            ++idx;
        }
        if (this.columnsPointers.getInt((long)idx) == col) {
            this.values.put((long)idx, value);
        } else {
            this.values = this.addAtPosition(this.values, this.length, idx, value);
            this.columnsPointers = this.addAtPosition(this.columnsPointers, this.length, idx, col);
            ++this.length;
            this.pointerE.put((long)row, this.pointerE.getInt((long)row) + 1);
            int i = row + 1;
            while ((long)i < this.rows) {
                this.pointerB.put((long)i, this.pointerB.getInt((long)i) + 1);
                this.pointerE.put((long)i, this.pointerE.getInt((long)i) + 1);
                ++i;
            }
        }
        return this;
    }

    @Override
    public INDArray get(INDArrayIndex ... indexes) {
        if (indexes.length == 1 && indexes[0] instanceof NDArrayIndexAll || indexes.length == 2 && (this.isRowVector() && indexes[0] instanceof PointIndex && indexes[0].offset() == 0L && indexes[1] instanceof NDArrayIndexAll || this.isColumnVector() && indexes[1] instanceof PointIndex && indexes[0].offset() == 0L && indexes[0] instanceof NDArrayIndexAll)) {
            return this;
        }
        indexes = NDArrayIndex.resolve(this.javaShapeInformation, indexes);
        throw new UnsupportedOperationException("Not implemeted");
    }

    @Override
    public DataBuffer getVectorCoordinates() {
        return Nd4j.getDataBufferFactory().create(this.columnsPointers, 0L, this.length());
    }

    public double[] getDoubleValues() {
        return this.values.getDoublesAt(0L, (int)this.length);
    }

    public double[] getColumns() {
        return this.columnsPointers.getDoublesAt(0L, (int)this.length);
    }

    public int[] getPointerBArray() {
        return this.pointerB.asInt();
    }

    public int[] getPointerEArray() {
        return this.pointerE.asInt();
    }

    @Override
    public SparseFormat getFormat() {
        return format;
    }

    public DataBuffer getPointerB() {
        return Nd4j.getDataBufferFactory().create(this.pointerB, 0L, (long)this.rows());
    }

    public DataBuffer getPointerE() {
        return Nd4j.getDataBufferFactory().create(this.pointerE, 0L, (long)this.rows());
    }

    private DataBuffer addAtPosition(DataBuffer buf, long dataSize, int pos, double value) {
        DataBuffer buffer = buf.length() == dataSize ? this.reallocate(buf) : buf;
        double[] tail = buffer.getDoublesAt((long)pos, (int)dataSize - pos);
        buffer.put((long)pos, value);
        for (int i = 0; i < tail.length; ++i) {
            buffer.put((long)(i + pos + 1), tail[i]);
        }
        return buffer;
    }

    @Override
    public DataBuffer data() {
        return Nd4j.getDataBufferFactory().create(this.values, 0L, this.length());
    }

    @Override
    public INDArray toDense() {
        INDArray result = Nd4j.zeros(this.shape());
        int[] pointersB = this.pointerB.asInt();
        int[] pointersE = this.pointerE.asInt();
        for (int row = 0; row < this.rows(); ++row) {
            for (int idx = pointersB[row]; idx < pointersE[row]; ++idx) {
                result.put(row, this.columnsPointers.getInt((long)idx), this.values.getNumber((long)idx));
            }
        }
        return result;
    }

    @Override
    public DataBuffer shapeInfoDataBuffer() {
        return this.shapeInformation;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof INDArray)) {
            return false;
        }
        INDArray n = (INDArray)o;
        if (n.isSparse()) {
            BaseSparseNDArray s = (BaseSparseNDArray)n;
            switch (s.getFormat()) {
                case CSR: {
                    BaseSparseNDArrayCSR csrArray = (BaseSparseNDArrayCSR)s;
                    return csrArray.rows() == this.rows() && csrArray.columns() == this.columns() && csrArray.getVectorCoordinates().equals(this.getVectorCoordinates()) && csrArray.data().equals(this.data()) && csrArray.getPointerB().equals(this.getPointerB()) && csrArray.getPointerE().equals(this.getPointerE());
                }
                default: {
                    INDArray dense = this.toDense();
                    INDArray oDense = s.toDense();
                    return dense.equals(oDense);
                }
            }
        }
        INDArray dense = this.toDense();
        return dense.equals(o);
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public boolean wasClosed() {
        return false;
    }

    @Override
    public int underlyingRank() {
        return this.rank;
    }

    @Override
    public INDArray putiColumnVector(INDArray columnVector) {
        return null;
    }

    @Override
    public INDArray putiRowVector(INDArray rowVector) {
        return null;
    }
}

