/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import lombok.NonNull;
import org.apache.commons.math3.util.FastMath;
import org.bytedeco.javacpp.BytePointer;
import org.nd4j.autodiff.samediff.serde.FlatBuffersMapper;
import org.nd4j.base.Preconditions;
import org.nd4j.graph.FlatArray;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.DataTypeEx;
import org.nd4j.linalg.api.buffer.Utf8Buffer;
import org.nd4j.linalg.api.iter.FirstAxisIterator;
import org.nd4j.linalg.api.iter.NdIndexIterator;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.JvmShapeInfo;
import org.nd4j.linalg.api.ndarray.SparseFormat;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.api.ops.impl.controlflow.Where;
import org.nd4j.linalg.api.ops.impl.reduce.HashCode;
import org.nd4j.linalg.api.ops.impl.reduce.bool.All;
import org.nd4j.linalg.api.ops.impl.reduce.bool.Any;
import org.nd4j.linalg.api.ops.impl.reduce.floating.AMean;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Entropy;
import org.nd4j.linalg.api.ops.impl.reduce.floating.LogEntropy;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Mean;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Norm1;
import org.nd4j.linalg.api.ops.impl.reduce.floating.Norm2;
import org.nd4j.linalg.api.ops.impl.reduce.floating.NormMax;
import org.nd4j.linalg.api.ops.impl.reduce.floating.ShannonEntropy;
import org.nd4j.linalg.api.ops.impl.reduce.longer.MatchCondition;
import org.nd4j.linalg.api.ops.impl.reduce.same.AMax;
import org.nd4j.linalg.api.ops.impl.reduce.same.AMin;
import org.nd4j.linalg.api.ops.impl.reduce.same.Max;
import org.nd4j.linalg.api.ops.impl.reduce.same.Min;
import org.nd4j.linalg.api.ops.impl.reduce.same.Prod;
import org.nd4j.linalg.api.ops.impl.reduce.same.Sum;
import org.nd4j.linalg.api.ops.impl.reduce3.EqualsWithEps;
import org.nd4j.linalg.api.ops.impl.reduce3.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.ManhattanDistance;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarRemainder;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSet;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEps;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.shape.Tile;
import org.nd4j.linalg.api.ops.impl.summarystats.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.api.ops.impl.transforms.any.Assign;
import org.nd4j.linalg.api.ops.impl.transforms.bool.MatchConditionTransform;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Eps;
import org.nd4j.linalg.api.ops.impl.transforms.custom.EqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.custom.GreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LessThan;
import org.nd4j.linalg.api.ops.impl.transforms.custom.NotEqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.DivOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.FModOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.FloorModOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.MulOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.RDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.RSubOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.RemainderOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.SubOp;
import org.nd4j.linalg.api.ops.impl.transforms.same.Negative;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.exception.Nd4jNoSuchWorkspaceException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.IntervalIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndexAll;
import org.nd4j.linalg.indexing.NewAxis;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.indexing.SpecifiedIndex;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.linalg.memory.MemcpyDirection;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.primitives.Triple;
import org.nd4j.linalg.string.NDArrayStrings;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.NDArrayMath;
import org.nd4j.linalg.workspace.WorkspaceUtils;
import org.nd4j.shade.guava.primitives.Ints;
import org.nd4j.shade.guava.primitives.Longs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNDArray
implements INDArray,
Iterable {
    private static final Logger log = LoggerFactory.getLogger(BaseNDArray.class);
    private static final long serialVersionUID = 3285982317165542614L;
    protected volatile transient DataBuffer shapeInformation;
    protected volatile transient DataBuffer data;
    protected transient boolean compressed = false;
    protected transient boolean released = false;
    protected transient JvmShapeInfo jvmShapeInfo;
    private static final int[][] tadFinalPermuteDimensions = new int[32][0];

    public BaseNDArray() {
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public void markAsCompressed(boolean reallyCompressed) {
        this.compressed = reallyCompressed;
    }

    public BaseNDArray(DataBuffer buffer) {
        this.data = buffer;
        if (buffer.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of buffer can not be >= Integer.MAX_VALUE");
        }
        long[] shape = new long[]{1L, (int)buffer.length()};
        long[] stride = Nd4j.getStrides(shape);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 1L, Nd4j.order().charValue(), buffer.dataType(), false));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        this.data = offset > 0L ? Nd4j.createBuffer(buffer, offset, Shape.lengthOfBuffer(shape, stride)) : buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), ArrayUtil.toLongArray((int[])stride), Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, buffer.dataType(), false));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, long[] stride, long offset, char ordering) {
        this(buffer, shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, long[] stride, long offset, long ews, char ordering) {
        Shape.assertValidOrder(ordering);
        this.data = offset > 0L ? Nd4j.createBuffer(buffer, offset, Shape.lengthOfBuffer(shape, stride)) : buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, ews, ordering, buffer.dataType(), false));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, long[] stride, long offset, char ordering, DataType dataType) {
        this(buffer, shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, dataType);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, long[] stride, long offset, long ews, char ordering, DataType dataType) {
        this.data = offset > 0L ? Nd4j.createBuffer(buffer, offset, Shape.lengthOfBuffer(shape, stride)) : buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, ews, ordering, dataType, false));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, long[] stride, char ordering, DataType type) {
        this.data = buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, type, false));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, long[] stride, char ordering, DataType type, MemoryWorkspace workspace) {
        this.data = buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, type, false));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, DataType dataType, long[] shape, long[] stride, long offset, char ordering) {
        this.data = offset > 0L ? Nd4j.createBuffer(buffer, offset, Shape.lengthOfBuffer(shape, stride)) : buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, dataType, false));
        this.init(shape, stride);
    }

    public BaseNDArray(double[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(double[][] data, char ordering) {
        this(BaseNDArray.internalCreateBuffer(ordering == 'c' ? ArrayUtil.flatten((double[][])data) : ArrayUtil.flattenF((double[][])data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0L, ordering);
        int c = this.columns();
        for (int r = 0; r < this.rows(); ++r) {
            Preconditions.checkState((data[r].length == c ? 1 : 0) != 0, (String)"data[%s].length=%s must be equal to number of columns %s", (int)r, (int)data[r].length, (int)c);
        }
    }

    public BaseNDArray(int[] shape, DataBuffer buffer) {
        this.data = buffer;
        this.init(shape, Nd4j.getStrides(shape));
    }

    public BaseNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, 0L, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getStrides(shape, ordering), offset);
    }

    public BaseNDArray(double[] data, long[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getStrides(shape, ordering), offset);
    }

    public BaseNDArray(float[] data, long[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getStrides(shape, ordering), offset);
    }

    public BaseNDArray(int[] shape, int[] stride, long offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape)), shape, stride, offset, ordering);
    }

    public BaseNDArray(long[] shape, long[] stride, long offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape)), shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, long offset, char ordering, boolean initialize) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape), initialize), shape, stride, offset, ordering);
    }

    public BaseNDArray(long[] shape, long[] stride, long offset, char ordering, boolean initialize) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape), initialize), shape, stride, offset, ordering);
    }

    public BaseNDArray(DataType type, long[] shape, long[] stride, long offset, char ordering, boolean initialize) {
        this(Nd4j.createBuffer(type, ArrayUtil.prodLong((long[])shape), initialize), type, shape, stride, offset, ordering);
    }

    public BaseNDArray(DataType type, long[] shape, long[] stride, long offset, char ordering, boolean initialize, MemoryWorkspace workspace) {
        this(Nd4j.createBuffer(type, ArrayUtil.prodLong((long[])shape), initialize, workspace), type, shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0L, ordering);
    }

    public BaseNDArray(int[] shape, long offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(long[] shape, long offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(int[] shape) {
        this(shape, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(long[] shape) {
        this(shape, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(int newRows, int newColumns, char ordering) {
        Shape.assertValidOrder(ordering);
        this.data = Nd4j.createBuffer((long)newRows * (long)newColumns);
        long[] shape = new long[]{newRows, newColumns};
        long[] stride = Nd4j.getStrides(shape, ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, Nd4j.dataType(), false));
        this.init(shape, stride);
    }

    public BaseNDArray(long newRows, long newColumns, char ordering) {
        Shape.assertValidOrder(ordering);
        this.data = Nd4j.createBuffer(newRows * newColumns);
        long[] shape = new long[]{newRows, newColumns};
        long[] stride = Nd4j.getStrides(shape, ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, Nd4j.dataType(), false));
        this.init(shape, stride);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, char ordering) {
        this(slices, shape, Nd4j.getStrides(shape, ordering), ordering);
    }

    public BaseNDArray(List<INDArray> slices, long[] shape, char ordering) {
        this(slices, shape, Nd4j.getStrides(shape, ordering), ordering);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride, char ordering) {
        DataBuffer ret;
        Shape.assertValidOrder(ordering);
        this.data = ret = slices.get(0).data().dataType() == DataType.FLOAT ? Nd4j.createBuffer(new float[ArrayUtil.prod((int[])shape)]) : Nd4j.createBuffer(new double[ArrayUtil.prod((int[])shape)]);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), ArrayUtil.toLongArray((int[])stride), Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, slices.get(0).dataType(), false));
        this.init(shape, stride);
        if (slices.get(0).isScalar()) {
            int i = 0;
            while ((long)i < this.length()) {
                this.putScalar((long)i, slices.get(i).getDouble(0L));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.slices()) {
                this.putSlice(i, slices.get(i));
                ++i;
            }
        }
    }

    public BaseNDArray(List<INDArray> slices, long[] shape, long[] stride, char ordering) {
        DataBuffer ret;
        this.data = ret = Nd4j.createBuffer(slices.get(0).dataType(), Shape.lengthOf(shape), false);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, slices.get(0).dataType(), false));
        this.init(shape, stride);
        if (slices.get(0).isScalar()) {
            int i = 0;
            while ((long)i < this.length()) {
                this.putScalar((long)i, slices.get(i).getDouble(0L));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.slices()) {
                this.putSlice(i, slices.get(i));
                ++i;
            }
        }
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0L, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), ArrayUtil.toLongArray((int[])stride), Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, DataType.FLOAT, data == null || data.length <= 0));
        if (data != null && data.length > 0) {
            long perfD = PerformanceTracker.getInstance().helperStartTransaction();
            this.data = BaseNDArray.internalCreateBuffer(data, offset);
            PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, data.length * Nd4j.sizeOfDataType(DataType.FLOAT), MemcpyDirection.HOST_TO_HOST);
            if (offset >= (long)data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape, stride);
    }

    public BaseNDArray(float[] data, long[] shape, long[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, DataType.FLOAT, data == null || data.length <= 0));
        if (data != null && data.length > 0) {
            this.data = Nd4j.createTypedBuffer(data, DataType.FLOAT);
            if (offset >= (long)data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape, stride);
    }

    public BaseNDArray(double[] data, long[] shape, long[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering, DataType.DOUBLE, data == null || data.length <= 0));
        if (data != null && data.length > 0) {
            this.data = Nd4j.createBuffer(data, offset);
            if (offset >= (long)data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer data, int[] shape, int[] stride, long offset) {
        this.data = Nd4j.createBuffer(data, offset, ArrayUtil.prodLong((int[])shape));
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), ArrayUtil.toLongArray((int[])stride), Shape.elementWiseStride(shape, stride, Nd4j.order().charValue() == 'f'), Nd4j.order().charValue(), data.dataType(), false));
        this.init(shape, stride);
    }

    public BaseNDArray(int[] data, int[] shape, int[] strides) {
        this(BaseNDArray.internalCreateBuffer(data), shape, strides);
    }

    public BaseNDArray(DataBuffer data, int[] shape) {
        this(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer data, long[] shape) {
        this(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, long offset) {
        this(Nd4j.createBuffer(buffer, offset, ArrayUtil.prodLong((int[])shape)), shape, Nd4j.getStrides(shape), offset, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), 0L, ordering);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), 0L, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, char ordering) {
        this(Nd4j.createBuffer(data), shape, ordering);
    }

    public BaseNDArray(double[] data, long[] shape, char ordering) {
        this(Nd4j.createBuffer(data), shape, ordering);
    }

    public BaseNDArray(float[] data, long[] shape, char ordering) {
        this(Nd4j.createBuffer(data), shape, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        this(BaseNDArray.internalCreateBuffer(data, offset), shape, stride, offset, ordering);
    }

    public BaseNDArray(float[] data, char order) {
        this(BaseNDArray.internalCreateBuffer(data), order);
    }

    protected static DataBuffer internalCreateBuffer(float[] data) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(buffer.dataType()), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(double[] data) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(buffer.dataType()), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(int[] data) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(buffer.dataType()), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(float[] data, long offset) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data, offset);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(buffer.dataType()), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(double[] data, long offset) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data, offset);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(buffer.dataType()), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    public BaseNDArray(DataBuffer floatBuffer, char order) {
        this(floatBuffer, new int[]{(int)floatBuffer.length()}, Nd4j.getStrides(new int[]{(int)floatBuffer.length()}, order), 0L, order);
        Shape.assertValidOrder(order);
        if (floatBuffer.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of buffer can not be >= Integer.MAX_VALUE");
        }
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] strides) {
        this(buffer, shape, strides, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape) {
        this(data, shape, 0L);
    }

    public BaseNDArray(float[] data, int[] shape, long offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride, long offset) {
        this(new float[ArrayUtil.prod((int[])shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(long[] shape, long[] stride, long offset) {
        this(new float[ArrayUtil.prod((long[])shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0L);
    }

    public BaseNDArray(int[] shape, long offset) {
        this(shape, Nd4j.getStrides(shape), offset);
    }

    public BaseNDArray(int[] shape, char ordering) {
        this(shape, 0L, ordering);
    }

    public BaseNDArray(int newRows, int newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(long newRows, long newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, long[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, long[] shape, long[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(double[] data, long[] shape, long[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, long[] shape, long[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data) {
        this(Nd4j.createBuffer(data));
    }

    public BaseNDArray(float[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(float[][] data, char ordering) {
        this(BaseNDArray.internalCreateBuffer(ordering == 'c' ? ArrayUtil.flatten((float[][])data) : ArrayUtil.flattenF((float[][])data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0L, ordering);
        int c = this.columns();
        for (int r = 0; r < this.rows(); ++r) {
            Preconditions.checkState((data[r].length == c ? 1 : 0) != 0, (String)"data[%s].length=%s must be equal to number of columns %s", (int)r, (int)data[r].length, (int)c);
        }
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, long offset, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.linearIndex(this.length() - 1L);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected INDArray create(DataBuffer data, int[] shape, long offset) {
        return Nd4j.create(data, shape, offset);
    }

    @Override
    public int elementWiseStride() {
        return Shape.elementWiseStride(this.shapeInfoDataBuffer());
    }

    @Override
    public long tensorsAlongDimension(int ... dimension) {
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank() || dimension.length == 1 && dimension[0] == Integer.MAX_VALUE) {
            return 1L;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        long[] tensorShape = ArrayUtil.keep((long[])this.shape(), (int[])dimension);
        long len = ArrayUtil.prodLong((long[])tensorShape);
        if (len == 0L) {
            throw new IllegalStateException("Illegal length found after removing index");
        }
        long length = this.length();
        if (length / len >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tensors along dimension can not be >= Integer.MAX_VALUE");
        }
        return length / len;
    }

    @Override
    public INDArray tensorAlongDimension(long index, int ... dimension) {
        long tads;
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0, (String)"tensorAlongDimension(...) can't be used on empty tensors");
        if (dimension.length >= this.rank() || dimension.length == 1 && dimension[0] == Integer.MAX_VALUE) {
            return this;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension.length > 1) {
            dimension = Ints.toArray(new ArrayList(new TreeSet(Ints.asList((int[])dimension))));
        }
        if (dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if (index >= (tads = this.tensorsAlongDimension(dimension))) {
            throw new IllegalArgumentException("Illegal index " + index + " out of tads " + tads);
        }
        if (dimension.length == 1) {
            if (dimension[0] == 0 && this.isColumnVector()) {
                return this.transpose();
            }
            if (dimension[0] == 1 && this.isRowVector()) {
                return this;
            }
        }
        Pair<DataBuffer, DataBuffer> tadInfo = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(this, dimension);
        DataBuffer shapeInfo = (DataBuffer)tadInfo.getFirst();
        long[] shape = Shape.shape(shapeInfo);
        long[] stride = Shape.stride(shapeInfo).asLong();
        long offset = this.offset() + ((DataBuffer)tadInfo.getSecond()).getLong(index);
        long ews = shapeInfo.getLong(shapeInfo.getLong(0L) * 2L + 2L);
        char tadOrder = (char)shapeInfo.getInt(shapeInfo.getLong(0L) * 2L + 3L);
        INDArray toTad = Nd4j.create(this.data(), shape, stride, offset, ews, tadOrder);
        return toTad;
    }

    private void setShapeInformation(Pair<DataBuffer, long[]> shapeInfo) {
        this.shapeInformation = (DataBuffer)shapeInfo.getFirst();
        this.jvmShapeInfo = new JvmShapeInfo((long[])shapeInfo.getSecond());
    }

    private INDArray doTad(int index, int ... dimension) {
        long tads;
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank()) {
            return this;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if ((long)index >= (tads = this.tensorsAlongDimension(dimension))) {
            throw new IllegalArgumentException("Illegal index " + index + " out of tads " + tads);
        }
        if (dimension.length == 1) {
            if (dimension[0] == 0 && this.isColumnVector()) {
                return this.transpose();
            }
            if (dimension[0] == 1 && this.isRowVector()) {
                return this;
            }
        }
        long[] tensorShape = ArrayUtil.keep((long[])this.shape(), (int[])dimension);
        int[] reverseDimensions = ArrayUtil.reverseCopy((int[])dimension);
        int[] remove = ArrayUtil.removeIndex((int[])ArrayUtil.range((int)0, (int)this.rank()), (int[])dimension);
        int[] newPermuteDims = Ints.concat((int[][])new int[][]{remove, reverseDimensions});
        int[] finalPermuteDims = tadFinalPermuteDimensions[dimension.length];
        INDArray permuted = this.permute(newPermuteDims);
        long sliceIdx = NDArrayMath.sliceOffsetForTensor(index, permuted, tensorShape);
        INDArray ret2 = permuted.slice(sliceIdx);
        if (dimension.length == tensorShape.length && ArrayUtil.prodLong((long[])tensorShape) == ret2.length()) {
            if (dimension.length == 1 && ret2.isRowVector()) {
                return ret2;
            }
            if (finalPermuteDims.length != ret2.rank()) {
                finalPermuteDims = new int[ret2.rank()];
                int count = 0;
                int i = finalPermuteDims.length - 1;
                while (i >= 0) {
                    finalPermuteDims[count++] = i--;
                }
            }
            return ret2.permutei(finalPermuteDims);
        }
        int length = ArrayUtil.prod((long[])tensorShape);
        int tensorLength = ArrayUtil.prod((long[])tensorShape);
        long offset = (long)(index * tensorLength) / NDArrayMath.lengthPerSlice(ret2);
        if (sliceIdx == 0L && (long)length == NDArrayMath.lengthPerSlice(ret2)) {
            ret2 = ret2.slice((int)offset);
            if (dimension.length == 1 && ret2.isRowVectorOrScalar()) {
                return ret2;
            }
            return ret2.permutei(finalPermuteDims);
        }
        if ((long)length == NDArrayMath.lengthPerSlice(ret2)) {
            offset -= ret2.slices() * (offset / ret2.slices());
            ret2 = ret2.slice((int)offset);
            if (dimension.length == 1 && ret2.isRowVectorOrScalar()) {
                return ret2;
            }
            return ret2.permutei(finalPermuteDims);
        }
        while (ret2.length() > (long)length) {
            sliceIdx = NDArrayMath.sliceOffsetForTensor(index, ret2, tensorShape);
            sliceIdx -= ret2.slices() * (sliceIdx / ret2.slices());
            ret2 = ret2.slice(sliceIdx);
        }
        if (dimension.length == 1 && ret2.isRowVectorOrScalar()) {
            return ret2;
        }
        return ret2.permutei(finalPermuteDims);
    }

    @Override
    public long vectorsAlongDimension(int dimension) {
        if (dimension == 0 && this.isVector() || this.isRowVectorOrScalar()) {
            return 1L;
        }
        if (this.size(dimension) == 1L && !this.isVector()) {
            for (int i = dimension; i < this.rank(); ++i) {
                if (this.size(i) == 1L) continue;
                return this.vectorsAlongDimension(i);
            }
            return this.length();
        }
        if (this.size(0) == 1L && !this.isVectorOrScalar()) {
            int realDimension = this.rank() - this.getLeadingOnes();
            long length = this.length();
            if (length / this.size(realDimension) >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
            }
            return length / this.size(realDimension);
        }
        long length = this.length();
        if (dimension >= this.jvmShapeInfo.rank) {
            if (length / this.size(this.jvmShapeInfo.rank - 1) >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
            }
            return (int)(length / this.size(this.jvmShapeInfo.rank - 1));
        }
        if (length / this.size(dimension) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
        }
        return length / this.size(dimension);
    }

    @Override
    public INDArray vectorAlongDimension(int index, int dimension) {
        if (dimension < 0) {
            dimension = this.jvmShapeInfo.getRank() + dimension;
        }
        if (dimension == this.jvmShapeInfo.getRank() - 1 && this.size(dimension) == 1L && this.rank() > 2 || this.rank() > 2 && dimension == 0 && this.size(dimension) == 1L) {
            return this;
        }
        return this.tensorAlongDimension(index, dimension);
    }

    @Override
    public void setOrder(char order) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(this.shape(), this.stride(), this.elementWiseStride(), order, this.dataType(), this.isEmpty()));
    }

    @Override
    public void setShapeAndStride(int[] shape, int[] stride) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), ArrayUtil.toLongArray((int[])stride), 0L, this.ordering(), this.dataType(), false));
    }

    @Override
    public INDArray cumsumi(int dimension) {
        this.validateNumericalArray("cumsumi", true);
        if (this.isScalar() || this.isEmpty()) {
            return this;
        }
        if (this.isVector()) {
            double s = 0.0;
            int i = 0;
            while ((long)i < this.length()) {
                this.putScalar((long)i, s += this.getDouble((long)i));
                ++i;
            }
        } else {
            if (dimension == Integer.MAX_VALUE) {
                INDArray flattened = this.ravel();
                double prevVal = flattened.getDouble(0L);
                int i = 1;
                while ((long)i < flattened.length()) {
                    double d = prevVal + flattened.getDouble((long)i);
                    flattened.putScalar((long)i, d);
                    prevVal = d;
                    ++i;
                }
                return flattened;
            }
            int i = 0;
            while ((long)i < this.vectorsAlongDimension(dimension)) {
                INDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
                ++i;
            }
        }
        return this;
    }

    @Override
    public Number normmaxNumber() {
        return this.normmax(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number norm2Number() {
        return this.norm2(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number norm1Number() {
        return this.norm1(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number stdNumber() {
        return this.std(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number prodNumber() {
        if (this.isScalar()) {
            return this.getNumber(0L);
        }
        return this.prod(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number meanNumber() {
        this.validateNumericalArray("meanNumber", false);
        if (this.isScalar()) {
            return this.getNumber(0L);
        }
        return this.mean(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number ameanNumber() {
        return this.amean(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number varNumber() {
        return this.var(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number maxNumber() {
        if (this.isScalar()) {
            return this.getNumber(0L);
        }
        return this.max(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number amaxNumber() {
        return this.amax(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number minNumber() {
        if (this.isScalar()) {
            return this.getNumber(0L);
        }
        return this.min(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number aminNumber() {
        return this.amin(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number scan(Condition condition) {
        MatchCondition op = new MatchCondition((INDArray)this, condition, new int[0]);
        return Nd4j.getExecutioner().exec(op).getDouble(0L);
    }

    @Override
    public Number sumNumber() {
        this.validateNumericalArray("sum", false);
        if (this.isScalar()) {
            return this.getNumber(0L);
        }
        INDArray scalar = this.sum(Integer.MAX_VALUE);
        Nd4j.getExecutioner().commit();
        return scalar.getDouble(0L);
    }

    @Override
    public Number entropyNumber() {
        return this.entropy(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number shannonEntropyNumber() {
        return this.shannonEntropy(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number logEntropyNumber() {
        return this.logEntropy(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public INDArray cumsum(int dimension) {
        this.validateNumericalArray("cumsum", true);
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        Preconditions.checkState((this.isScalar() && arr.isScalar() || this.isVector() && arr.isVector() || Shape.shapeEqualWithSqueeze(this.shape(), arr.shape()) ? 1 : 0) != 0, (String)"Cannot assign arrays: arrays must both be scalars, both vectors, or shapes must be equal other than size 1 dimensions. Attempting to do x.assign(y) with x.shape=%ndShape and y.shape=%ndShape", (Object)this, (Object)arr);
        Preconditions.checkArgument((this.length() == arr.length() ? 1 : 0) != 0, (String)"Length of both arrays must be equal");
        Nd4j.getExecutioner().exec(new Assign(arr, this));
        return this;
    }

    @Override
    public INDArray putScalar(long i, double value) {
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || value == 0.0 || value == 1.0 ? 1 : 0) != 0, (String)"Cannot put value %s into boolean array - only putScalar with values 0 or 1 is allowed on boolean arrays", (double)value);
        if (i < 0L) {
            i += (long)this.rank();
        }
        if (this.isScalar()) {
            this.autoProcessScalarCall();
            this.data.put(i, value);
            return this;
        }
        if (this.rank() == 1) {
            this.data.put(i * (long)this.stride(0), value);
            return this;
        }
        if (this.isRowVector() && this.rank() == 2) {
            return this.putScalar(0L, i, value);
        }
        if (this.isColumnVector() && this.rank() == 2) {
            return this.putScalar(i, 0L, value);
        }
        long[] indexes = this.ordering() == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        return this.putScalar(indexes, value);
    }

    @Override
    public INDArray putScalar(long i, float value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(long i, int value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || value == 0.0 || value == 1.0 ? 1 : 0) != 0, (String)"Cannot put value %s into boolean array - only putScalar with values 0 or 1 is allowed on boolean arrays", (double)value);
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0) continue;
            int n = i;
            indexes[n] = (int)((long)indexes[n] + this.size(i));
        }
        if (indexes.length == 1) {
            return this.putScalar((long)indexes[0], value);
        }
        if (indexes.length == 2) {
            return this.putScalar(indexes[0], indexes[1], value);
        }
        if (indexes.length == 3) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], value);
        }
        if (indexes.length == 4) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], indexes[3], value);
        }
        this.autoProcessScalarCall();
        long offset = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long[] indexes, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || value == 0.0 || value == 1.0 ? 1 : 0) != 0, (String)"Cannot put value %s into boolean array - only putScalar with values 0 or 1 is allowed on boolean arrays", (double)value);
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0L) continue;
            int n = i;
            indexes[n] = indexes[n] + this.size(i);
        }
        if (indexes.length == 1) {
            return this.putScalar(indexes[0], value);
        }
        if (indexes.length == 2) {
            return this.putScalar(indexes[0], indexes[1], value);
        }
        if (indexes.length == 3) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], value);
        }
        if (indexes.length == 4) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], indexes[3], value);
        }
        this.autoProcessScalarCall();
        long offset = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long[] indexes, float value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(long row, long col, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        this.autoProcessScalarCall();
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || value == 0.0 || value == 1.0 ? 1 : 0) != 0, (String)"Cannot put value %s into boolean array - only putScalar with values 0 or 1 is allowed on boolean arrays", (double)value);
        if (this.rank() > 2) {
            throw new IllegalStateException("Cannot use putScalar(int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = Shape.getOffsetUnsafe(this.jvmShapeInfo.javaShapeInformation, row, col);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long dim0, long dim1, long dim2, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        this.autoProcessScalarCall();
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || value == 0.0 || value == 1.0 ? 1 : 0) != 0, (String)"Cannot put value %s into boolean array - only putScalar with values 0 or 1 is allowed on boolean arrays", (double)value);
        if (this.rank() != 3) {
            throw new IllegalStateException("Cannot use putScalar(int,int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = 0L;
        long size_0 = this.jvmShapeInfo.javaShapeInformation[1];
        long size_1 = this.jvmShapeInfo.javaShapeInformation[2];
        long size_2 = this.jvmShapeInfo.javaShapeInformation[3];
        if (size_0 != 1L) {
            offset += dim0 * this.jvmShapeInfo.javaShapeInformation[4];
        }
        if (size_1 != 1L) {
            offset += dim1 * this.jvmShapeInfo.javaShapeInformation[5];
        }
        if (size_2 != 1L) {
            offset += dim2 * this.jvmShapeInfo.javaShapeInformation[6];
        }
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long dim0, long dim1, long dim2, long dim3, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        this.autoProcessScalarCall();
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || value == 0.0 || value == 1.0 ? 1 : 0) != 0, (String)"Cannot put value %s into boolean array - only putScalar with values 0 or 1 is allowed on boolean arrays", (double)value);
        if (this.rank() != 4) {
            throw new IllegalStateException("Cannot use putScalar(int,int,int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = Shape.getOffsetUnsafe(this.jvmShapeInfo.javaShapeInformation, dim0, dim1, dim2, dim3);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, float value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, int value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(long[] indexes, int value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray eps(Number other) {
        this.validateNumericalArray("eps", true);
        return Nd4j.getExecutioner().exec(new ScalarEps((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), other));
    }

    @Override
    public INDArray eps(INDArray other) {
        this.validateNumericalArray("eps", true);
        return Nd4j.getExecutioner().exec(new Eps(this, other, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering())));
    }

    @Override
    public INDArray lt(Number other) {
        this.validateNumericalArray("less than (lt)", false);
        return Nd4j.getExecutioner().exec(new ScalarLessThan((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), other));
    }

    @Override
    public INDArray lte(Number other) {
        this.validateNumericalArray("less than or equals (lte)", false);
        return Nd4j.getExecutioner().exec(new ScalarLessThanOrEqual((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), other));
    }

    @Override
    public INDArray eq(Number other) {
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || other.doubleValue() == 0.0 || other.doubleValue() == 1.0 ? 1 : 0) != 0, (String)"Scalar equality on boolean arrays can only be applied with values 0 or 1: got value %s", (Object)other);
        return Nd4j.getExecutioner().exec(new ScalarEquals((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), other));
    }

    @Override
    public INDArray gt(Number other) {
        this.validateNumericalArray("greater than (gt)", false);
        return Nd4j.getExecutioner().exec(new ScalarGreaterThan((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), other));
    }

    @Override
    public INDArray gte(Number other) {
        this.validateNumericalArray("greater than or equals (gte)", false);
        return Nd4j.getExecutioner().exec(new ScalarGreaterThanOrEqual((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), other));
    }

    @Override
    public INDArray lt(INDArray other) {
        this.validateNumericalArray("less than (lt)", false);
        if (Shape.shapeEquals(this.shape(), other.shape())) {
            return Nd4j.getExecutioner().exec(new LessThan(this, other, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering())))[0];
        }
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return Nd4j.exec(new LessThan(new INDArray[]{this, other}, new INDArray[]{Nd4j.createUninitialized(DataType.BOOL, Shape.broadcastOutputShape(this.shape(), other.shape()))}))[0];
        }
        throw new IllegalArgumentException("Shapes must be broadcastable");
    }

    @Override
    public INDArray neq(Number other) {
        Preconditions.checkArgument((this.dataType() != DataType.BOOL || other.doubleValue() == 0.0 || other.doubleValue() == 1.0 ? 1 : 0) != 0, (String)"Scalar non-equality on boolean arrays can only be applied with values 0 or 1: got value %s", (Object)other);
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"Cannot perform operation neq (not equal) on empty array");
        return Nd4j.getExecutioner().exec(new ScalarNotEquals((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), other));
    }

    @Override
    public INDArray neq(INDArray other) {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"Cannot perform operation neq (not equal) on empty array");
        return Nd4j.getExecutioner().exec(new NotEqualTo(this, other, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering())))[0];
    }

    @Override
    public INDArray eq(INDArray other) {
        if (Shape.shapeEquals(this.shape(), other.shape())) {
            return Nd4j.getExecutioner().exec(new EqualTo(this, other, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering())))[0];
        }
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return Nd4j.exec(new EqualTo(new INDArray[]{this, other}, new INDArray[]{Nd4j.createUninitialized(DataType.BOOL, Shape.broadcastOutputShape(this.shape(), other.shape()))}))[0];
        }
        throw new IllegalArgumentException("Shapes must be broadcastable");
    }

    @Override
    public INDArray gt(INDArray other) {
        this.validateNumericalArray("greater than (gt)", false);
        if (Shape.shapeEquals(this.shape(), other.shape())) {
            return Nd4j.getExecutioner().exec(new GreaterThan(this, other, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering())))[0];
        }
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return Nd4j.exec(new GreaterThan(new INDArray[]{this, other}, new INDArray[]{Nd4j.createUninitialized(DataType.BOOL, Shape.broadcastOutputShape(this.shape(), other.shape()))}))[0];
        }
        throw new IllegalArgumentException("Shapes must be broadcastable");
    }

    @Override
    public INDArray isInfinite() {
        this.validateNumericalArray("isInfinite", true);
        if (this.isEmpty()) {
            return Nd4j.empty(DataType.BOOL);
        }
        return Nd4j.getExecutioner().exec(new MatchConditionTransform((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), Conditions.isInfinite()));
    }

    @Override
    public INDArray isNaN() {
        this.validateNumericalArray("isNaN", true);
        if (this.isEmpty()) {
            return Nd4j.empty(DataType.BOOL);
        }
        return Nd4j.getExecutioner().exec(new MatchConditionTransform((INDArray)this, Nd4j.createUninitialized(DataType.BOOL, this.shape(), this.ordering()), Conditions.isNan()));
    }

    @Override
    public INDArray neg() {
        this.validateNumericalArray("negative (neg)", true);
        if (this.isEmpty()) {
            return this;
        }
        return Nd4j.getExecutioner().exec(new Negative(this, Nd4j.createUninitialized(this.dataType(), this.shape(), this.ordering())));
    }

    @Override
    public INDArray negi() {
        this.validateNumericalArray("negative (negi)", true);
        if (this.isEmpty()) {
            return this;
        }
        Nd4j.getExecutioner().exec(new Negative(this));
        return this;
    }

    @Override
    public INDArray rdiv(Number n, INDArray result) {
        return this.rdivi(n, result);
    }

    @Override
    public INDArray rdivi(Number n, INDArray result) {
        this.validateNumericalArray("rdivi", false);
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseDivision(this, null, result, n));
        return result;
    }

    @Override
    public INDArray rsub(Number n, INDArray result) {
        return this.rsubi(n, result);
    }

    @Override
    public INDArray rsubi(Number n, INDArray result) {
        this.validateNumericalArray("rsubi", false);
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseSubtraction((INDArray)this, result, n));
        return result;
    }

    @Override
    public INDArray div(Number n, INDArray result) {
        return this.divi(n, result);
    }

    @Override
    public INDArray divi(Number n, INDArray result) {
        this.validateNumericalArray("divi", false);
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarDivision(this, null, result, n));
        return result;
    }

    @Override
    public INDArray mul(Number n, INDArray result) {
        return this.muli(n, result);
    }

    @Override
    public INDArray muli(Number n, INDArray result) {
        this.validateNumericalArray("muli", false);
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarMultiplication(this, null, result, n));
        return result;
    }

    @Override
    public INDArray sub(Number n, INDArray result) {
        return this.subi(n, result);
    }

    @Override
    public INDArray subi(Number n, INDArray result) {
        this.validateNumericalArray("subi", false);
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarSubtraction(this, null, result, n));
        return result;
    }

    @Override
    public INDArray add(Number n, INDArray result) {
        return this.addi(n, result);
    }

    @Override
    public INDArray addi(Number n, INDArray result) {
        this.validateNumericalArray("addi", false);
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarAdd(this, null, result, n));
        return result;
    }

    @Override
    public INDArray getScalar(long row, long column) {
        return this.getScalar(new long[]{row, column});
    }

    @Override
    public INDArray dup() {
        return this.dup(Nd4j.order().charValue());
    }

    @Override
    public INDArray dup(char order) {
        WorkspaceUtils.assertValidArray(this, "Cannot duplicate INDArray");
        if (this.isCompressed() && this.ordering() == order) {
            INDArray ret = Nd4j.createArrayFromShapeBuffer(this.data().dup(), this.shapeInfoDataBuffer());
            ret.markAsCompressed(true);
            return ret;
        }
        if (this.isEmpty()) {
            return this;
        }
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isS()) {
            ArrayList<String> list = new ArrayList<String>();
            int e = 0;
            while ((long)e < this.length()) {
                list.add(this.getString(e));
                ++e;
            }
            return Nd4j.create(list, this.shape(), this.ordering());
        }
        INDArray z = Nd4j.createUninitialized(this.dataType(), this.shape(), order);
        z.assign(this);
        return z;
    }

    @Override
    public int getInt(int ... indices) {
        return (int)this.getDouble(indices);
    }

    @Override
    public long getLong(long index) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"Unable to get value from empty array");
        if (index >= this.length()) {
            throw new IllegalArgumentException("Unable to get linear index " + index + ": values is greater than length (" + this.length() + ")");
        }
        this.autoProcessScalarCall();
        if (index == 0L) {
            return this.data().getLong(index);
        }
        long[] dimensions = this.ordering() == 'c' ? Shape.ind2subC(this, index) : Shape.ind2sub(this, index);
        Shape.assertShapeLessThan(dimensions, this.shape());
        return this.getLong(dimensions);
    }

    @Override
    public long getLong(long ... indices) {
        if (this.isScalar()) {
            return this.data().getLong(0L);
        }
        return Shape.getLong(this, indices);
    }

    @Override
    public double getDouble(int ... indices) {
        this.autoProcessScalarCall();
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"Unable to get value from empty array");
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0) continue;
            int n = i;
            indices[n] = indices[n] + this.rank();
        }
        if (indices.length == 1) {
            if (this.rank() == 1) {
                return Shape.getDouble((INDArray)this, indices[0]);
            }
            if (this.isRowVector()) {
                return Shape.getDouble((INDArray)this, 0L, indices[0]);
            }
            if (this.isColumnVector()) {
                return Shape.getDouble((INDArray)this, indices[0], 0L);
            }
            if ((this.isScalar() || this.length() == 1L) && indices[0] == 0) {
                return this.data().getDouble(0L);
            }
        }
        return Shape.getDouble((INDArray)this, indices);
    }

    @Override
    public double getDouble(long ... indices) {
        this.autoProcessScalarCall();
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"Unable to get value from empty array");
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0L) continue;
            int n = i;
            indices[n] = indices[n] + (long)this.rank();
        }
        if (indices.length == 1) {
            if (this.rank() == 1) {
                return Shape.getDouble((INDArray)this, indices[0]);
            }
            if (this.isRowVector()) {
                return Shape.getDouble((INDArray)this, 0L, indices[0]);
            }
            if (this.isColumnVector()) {
                return Shape.getDouble((INDArray)this, indices[0], 0L);
            }
            if (this.isScalar() && indices[0] == 0L) {
                return this.data().getDouble(0L);
            }
            throw new IllegalStateException("Indexes length must be > 1 for non vectors and scalars");
        }
        return Shape.getDouble((INDArray)this, indices);
    }

    @Override
    public float getFloat(int ... indices) {
        return (float)this.getDouble(indices);
    }

    @Override
    public float getFloat(long ... indices) {
        return (float)this.getDouble(indices);
    }

    @Override
    public boolean isScalar() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.jvmShapeInfo.rank == 0) {
            return true;
        }
        if (this.jvmShapeInfo.rank > 2) {
            return false;
        }
        if (this.jvmShapeInfo.rank == 1) {
            return this.shape()[0] == 1L;
        }
        if (this.jvmShapeInfo.rank == 2) {
            return this.shape()[0] == 1L && this.shape()[1] == 1L || this.length() == 1L;
        }
        return false;
    }

    @Override
    public INDArray put(int[] indices, INDArray element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        if (this.isRowVector() && indices[0] == 0 && indices.length == 2) {
            int ix = 0;
            for (int i = 1; i < indices.length; ++i) {
                ix += indices[i] * this.stride(i);
            }
            if ((long)ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put((long)ix, element.getDouble(0L));
        } else {
            int ix = 0;
            for (int i = 0; i < indices.length; ++i) {
                if (this.size(i) == 1L) continue;
                ix += indices[i] * this.stride(i);
            }
            if ((long)ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put((long)ix, element.getDouble(0L));
        }
        return this;
    }

    @Override
    public INDArray match(INDArray comp, Condition condition) {
        return Nd4j.getExecutioner().exec(new MatchConditionTransform((INDArray)this, comp, condition));
    }

    @Override
    public INDArray match(Number comp, Condition condition) {
        return Nd4j.getExecutioner().exec(new MatchConditionTransform((INDArray)this, comp.doubleValue(), condition));
    }

    @Override
    public INDArray getWhere(INDArray comp, Condition condition) {
        return BooleanIndexing.chooseFrom(new INDArray[]{this, comp}, condition);
    }

    @Override
    public INDArray getWhere(Number comp, Condition condition) {
        return BooleanIndexing.chooseFrom(new INDArray[]{this}, Arrays.asList(comp.doubleValue()), Collections.emptyList(), condition);
    }

    @Override
    public INDArray putWhere(INDArray comp, INDArray put, Condition condition) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        MatchConditionTransform matchCondition = new MatchConditionTransform((INDArray)this, comp, condition);
        Nd4j.getExecutioner().exec(matchCondition);
        return this.putWhereWithMask(matchCondition.z(), put);
    }

    @Override
    public INDArray putWhere(Number comp, INDArray put, Condition condition) {
        return this.putWhere(Nd4j.scalar(comp), put, condition);
    }

    @Override
    public INDArray putWhere(Number comp, Number put, Condition condition) {
        return this.putWhere(Nd4j.scalar(comp), Nd4j.scalar(put), condition);
    }

    @Override
    public INDArray putWhereWithMask(INDArray mask, INDArray put) {
        INDArray output = this.dup();
        Nd4j.getExecutioner().execAndReturn(new Where(new INDArray[]{mask, this, put}, new INDArray[]{output}));
        return output;
    }

    @Override
    public INDArray putWhereWithMask(INDArray mask, Number put) {
        return this.putWhereWithMask(mask, Nd4j.scalar(put));
    }

    @Override
    public INDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public INDArray put(int i, int j, Number element) {
        return this.putScalar(new int[]{i, j}, element.doubleValue());
    }

    @Override
    public INDArray putSlice(int slice, INDArray put) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isScalar()) {
            Preconditions.checkState((boolean)put.isScalar(), (String)"Invalid dimension. Can only insert a scalar in to another scalar");
            this.put(0, put.getScalar(0L));
            return this;
        }
        if (this.isVector()) {
            Preconditions.checkState((put.isVectorOrScalar() && put.length() == this.length() ? 1 : 0) != 0, (String)"Invalid dimension on insertion. Can only insert scalars/vectors into other scalar/vectors");
            if (put.isScalar()) {
                this.putScalar((long)slice, put.getDouble(0L));
            } else {
                int i = 0;
                while ((long)i < this.length()) {
                    this.putScalar((long)i, put.getDouble((long)i));
                    ++i;
                }
            }
            return this;
        }
        this.assertSlice(put, slice);
        INDArray view = this.slice(slice);
        if (put.length() == 1L) {
            this.putScalar((long)slice, put.getDouble(0L));
        } else {
            if (!(view.isVector() && put.isVector() && view.length() == put.length() || view.equalShapes(put))) {
                throw new IllegalStateException("Cannot put slice: array to be put (" + Arrays.toString(put.shape()) + ") and slice array (" + Arrays.toString(view.shape()) + ") have different shapes");
            }
            view.assign(put);
        }
        return this;
    }

    protected void assertSlice(INDArray put, long slice) {
        Preconditions.checkArgument((slice < this.slices() ? 1 : 0) != 0, (String)"Invalid slice specified: slice %s must be in range 0 (inclusive) to numSlices=%s (exclusive)", (long)slice, (long)this.slices());
        long[] sliceShape = put.shape();
        if (Shape.isRowVectorShape(sliceShape)) {
            return;
        }
        long[] requiredShape = ArrayUtil.removeIndex((long[])this.shape(), (int)0);
        if (put.isScalar()) {
            return;
        }
        if (this.isVector() && put.isVector() && put.length() < this.length()) {
            return;
        }
        if (Shape.isColumnVectorShape(sliceShape)) {
            return;
        }
        if (!(Shape.shapeEquals(sliceShape, requiredShape) || Shape.isRowVectorShape(requiredShape) || Shape.isRowVectorShape(sliceShape))) {
            throw new IllegalStateException(String.format("Invalid shape size of %s . Should have been %s ", Arrays.toString(sliceShape), Arrays.toString(requiredShape)));
        }
    }

    @Override
    public boolean isMatrix() {
        return this.rank() == 2;
    }

    protected INDArray newShape(long[] newShape, char ordering) {
        return Nd4j.create(this.data(), newShape, this.stride(), 0L, ordering);
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset, char ordering) {
        return Nd4j.create(data, newShape, newStrides, offset, ordering);
    }

    protected INDArray create(DataBuffer data, long[] newShape, long[] newStrides, long offset, char ordering) {
        return Nd4j.create(data, newShape, newStrides, offset, ordering);
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset) {
        return Nd4j.create(data, newShape, newStrides, offset);
    }

    protected INDArray create(int[] shape) {
        return Nd4j.create(shape, this.getStrides(shape, Nd4j.order().charValue()), 0L);
    }

    protected INDArray create(int[] shape, int[] strides, long offset) {
        return Nd4j.create(shape, strides, offset);
    }

    protected int[] getStrides(int[] shape, char ordering) {
        return Nd4j.getStrides(shape, ordering);
    }

    @Override
    public double squaredDistance(INDArray other) {
        this.validateNumericalArray("squaredDistance", false);
        double d2 = this.distance2(other);
        return d2 * d2;
    }

    @Override
    public double distance2(INDArray other) {
        this.validateNumericalArray("distance2", false);
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Nd4j.getExecutioner().execAndReturn(new EuclideanDistance((INDArray)this, other, new int[0])).getFinalResult().doubleValue();
    }

    @Override
    public double distance1(INDArray other) {
        this.validateNumericalArray("distance1", false);
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Nd4j.getExecutioner().execAndReturn(new ManhattanDistance((INDArray)this, other, new int[0])).getFinalResult().doubleValue();
    }

    @Override
    public INDArray get(INDArray indices) {
        ArrayList<INDArray> arrList;
        block9: {
            block8: {
                if (indices.rank() > 2) {
                    throw new ND4JIllegalArgumentException("Indices must be a vector or matrix.");
                }
                if (indices.rows() == this.rank()) {
                    INDArray ret = Nd4j.create(indices.dataType(), indices.columns());
                    for (int i = 0; i < indices.columns(); ++i) {
                        int[] specifiedIndex = indices.getColumn(i).dup().data().asInt();
                        double v = this.getDouble(specifiedIndex);
                        ret.putScalar((long)i, v);
                    }
                    return ret;
                }
                arrList = new ArrayList<INDArray>();
                if (!indices.isMatrix() && !indices.isColumnVector() && (!indices.isScalar() || indices.rank() != 2)) break block8;
                for (int i = 0; i < indices.rows(); ++i) {
                    int j;
                    INDArray row;
                    if (i == 0) {
                        row = indices.getRow(i);
                        j = 0;
                        while ((long)j < row.length()) {
                            arrList.add(this.slice(row.getInt(j++)));
                        }
                        continue;
                    }
                    row = indices.slice(i);
                    j = 0;
                    while ((long)j < row.length()) {
                        INDArray put = ((INDArray)arrList.get(j)).slice(row.getInt(j));
                        put = put.reshape(Longs.concat((long[][])new long[][]{{1L}, put.shape()}));
                        arrList.set(j, put);
                        ++j;
                    }
                }
                break block9;
            }
            if (!indices.isRowVector()) break block9;
            int i = 0;
            while ((long)i < indices.length()) {
                INDArray add = this.slice(indices.getInt(i++));
                add = add.reshape(Longs.concat((long[][])new long[][]{{1L}, add.shape()}));
                arrList.add(add);
            }
        }
        return Nd4j.concat(0, arrList.toArray(new INDArray[arrList.size()]));
    }

    @Override
    public INDArray put(INDArray indices, INDArray element) {
        block6: {
            ArrayList<INDArray> arrList;
            block7: {
                block5: {
                    if (indices.rank() > 2) {
                        throw new ND4JIllegalArgumentException("Indices must be a vector or matrix.");
                    }
                    if (indices.rows() != this.rank()) break block5;
                    NdIndexIterator ndIndexIterator = new NdIndexIterator(element.shape());
                    for (int i = 0; i < indices.columns(); ++i) {
                        int[] specifiedIndex = indices.getColumn(i).dup().data().asInt();
                        this.putScalar(specifiedIndex, element.getDouble(ndIndexIterator.next()));
                    }
                    break block6;
                }
                arrList = new ArrayList<INDArray>();
                if (!indices.isMatrix() && !indices.isColumnVector()) break block7;
                for (int i = 0; i < indices.rows(); ++i) {
                    INDArray row = indices.getRow(i);
                    int j = 0;
                    while ((long)j < row.length()) {
                        INDArray slice = this.slice(row.getInt(j));
                        Nd4j.getExecutioner().execAndReturn(new org.nd4j.linalg.api.ops.impl.transforms.custom.Assign(new INDArray[]{slice, element}, new INDArray[]{slice}));
                        arrList.add(this.slice(row.getInt(j++)));
                    }
                }
                break block6;
            }
            if (!indices.isRowVector()) break block6;
            int i = 0;
            while ((long)i < indices.length()) {
                arrList.add(this.slice(indices.getInt(i++)));
            }
        }
        return this;
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, INDArray element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        boolean isSpecifiedIndex = false;
        for (INDArrayIndex idx : indices) {
            if (!(idx instanceof SpecifiedIndex)) continue;
            isSpecifiedIndex = true;
            break;
        }
        if (!isSpecifiedIndex) {
            return this.get(indices).assign(element);
        }
        int numSpecified = 0;
        ArrayList<long[]> specifiedIdxs = new ArrayList<long[]>();
        ArrayList<Integer> specifiedIdxDims = new ArrayList<Integer>();
        INDArrayIndex[] destinationIndices = (INDArrayIndex[])indices.clone();
        INDArrayIndex[] sourceIndices = (INDArrayIndex[])indices.clone();
        for (int i = 0; i < indices.length; ++i) {
            INDArrayIndex idx = indices[i];
            if (idx instanceof SpecifiedIndex) {
                ++numSpecified;
                long[] idxs = ((SpecifiedIndex)idx).getIndexes();
                specifiedIdxs.add(idxs);
                specifiedIdxDims.add(i);
                continue;
            }
            if (!(idx instanceof PointIndex)) continue;
            sourceIndices[i] = NDArrayIndex.point(0L);
        }
        int[] counts = new int[specifiedIdxs.size()];
        int[] dims = new int[specifiedIdxDims.size()];
        for (int i = 0; i < specifiedIdxs.size(); ++i) {
            counts[i] = ((long[])specifiedIdxs.get(i)).length;
            dims[i] = (Integer)specifiedIdxDims.get(i);
        }
        NdIndexIterator iter = new NdIndexIterator(counts);
        while (iter.hasNext()) {
            long[] iterationIdxs = iter.next();
            for (int i = 0; i < iterationIdxs.length; ++i) {
                long[] indicesForDim = (long[])specifiedIdxs.get(i);
                destinationIndices[dims[i]] = NDArrayIndex.point(indicesForDim[(int)iterationIdxs[i]]);
                sourceIndices[dims[i]] = NDArrayIndex.point(iterationIdxs[i]);
            }
            INDArray sourceView = element.get(sourceIndices);
            INDArray destinationView = this.get(destinationIndices);
            destinationView.assign(sourceView);
        }
        return this;
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, Number element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        INDArray get = this.get(indices);
        int i = 0;
        while ((long)i < get.length()) {
            get.putScalar((long)i, element.doubleValue());
            ++i;
        }
        return this;
    }

    @Override
    public INDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range((int)0, (int)this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public boolean isView() {
        if (this.isEmpty() || this.isS()) {
            return false;
        }
        return Shape.offset(this.jvmShapeInfo.javaShapeInformation) > 0 || this.length() < this.data().length() && this.data.dataType() != DataType.INT || this.data().originalDataBuffer() != null;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public DataBuffer data() {
        return this.data;
    }

    @Override
    public void setData(DataBuffer data) {
        this.data = data;
    }

    @Override
    public long slices() {
        return this.size(0);
    }

    protected INDArray create(DataBuffer buffer) {
        return Nd4j.create(buffer);
    }

    @Override
    public INDArray cond(Condition condition) {
        if (this.isEmpty()) {
            return Nd4j.empty(DataType.BOOL);
        }
        INDArray ret = Nd4j.createUninitialized(DataType.BOOL, this.shape());
        Nd4j.getExecutioner().exec(new MatchConditionTransform((INDArray)this, ret, condition));
        return ret;
    }

    protected void init(int[] shape, int[] stride) {
        if (this.shapeInformation == null || this.jvmShapeInfo == null || this.ordering() == '\u0000') {
            Pair<DataBuffer, long[]> si = Nd4j.getShapeInfoProvider().createShapeInformation(ArrayUtil.toLongArray((int[])shape), ArrayUtil.toLongArray((int[])stride), 1L, Nd4j.order().charValue(), this.dataType(), false);
            this.setShapeInformation(si);
        }
    }

    protected void init(long[] shape, long[] stride) {
        if (this.shapeInformation == null || this.jvmShapeInfo == null || this.ordering() == '\u0000') {
            Pair<DataBuffer, long[]> si = Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 1L, Nd4j.order().charValue(), this.dataType(), false);
            this.setShapeInformation(si);
        }
    }

    @Override
    public INDArray getScalar(long i) {
        if (i >= this.length()) {
            throw new ND4JIllegalStateException("Index can't be greater then array length");
        }
        if (i < 0L) {
            i += this.length();
        }
        long idx = this.isScalar() ? 0L : Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, Shape.ind2subC(this.shape(), i));
        DataBuffer buffer = Nd4j.createBuffer(this.data(), this.data().originalOffset() + idx, 1L);
        Pair<DataBuffer, long[]> shape = Nd4j.getShapeInfoProvider().createShapeInformation(new long[0], new long[0], 1L, 'c', this.dataType(), false);
        return Nd4j.createArrayFromShapeBuffer(buffer, shape);
    }

    protected INDArray doColumnWise(INDArray columnVector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (columnVector.isScalar()) {
            switch (operation) {
                case 'a': {
                    this.addi(columnVector.getDouble(0L));
                    break;
                }
                case 'p': {
                    this.assign(columnVector.getDouble(0L));
                    break;
                }
                case 's': {
                    this.subi(columnVector.getDouble(0L));
                    break;
                }
                case 'm': {
                    this.muli(columnVector.getDouble(0L));
                    break;
                }
                case 'd': {
                    this.divi(columnVector.getDouble(0L));
                    break;
                }
                case 'h': {
                    this.rsubi(columnVector.getDouble(0L));
                    break;
                }
                case 't': {
                    this.rdivi(columnVector.getDouble(0L));
                }
            }
            return this;
        }
        if (this.isScalar()) {
            switch (operation) {
                case 'a': {
                    return columnVector.addi(this.getDouble(0L));
                }
                case 'p': {
                    return columnVector.assign(this.getDouble(0L));
                }
                case 's': {
                    return columnVector.subi(this.getDouble(0L));
                }
                case 'm': {
                    return columnVector.muli(this.getDouble(0L));
                }
                case 'd': {
                    return columnVector.divi(this.getDouble(0L));
                }
                case 'h': {
                    return columnVector.rsubi(this.getDouble(0L));
                }
                case 't': {
                    return columnVector.rdivi(this.getDouble(0L));
                }
            }
        }
        if (!columnVector.isColumnVector() && columnVector.rank() > 1 || this.size(0) != columnVector.size(0) || columnVector.length() <= 1L) {
            throw new IllegalStateException("Mismatched shapes (shape = " + Arrays.toString(this.shape()) + ", column vector shape =" + Arrays.toString(columnVector.shape()) + ")");
        }
        if (columnVector.data().sameUnderlyingData(this.data())) {
            return this.doColumnWise(columnVector.dup(), operation);
        }
        if (this.equalShapes(columnVector)) {
            switch (operation) {
                case 'a': {
                    this.addi(columnVector);
                    break;
                }
                case 'p': {
                    this.assign(columnVector);
                    break;
                }
                case 's': {
                    this.subi(columnVector);
                    break;
                }
                case 'm': {
                    this.muli(columnVector);
                    break;
                }
                case 'd': {
                    this.divi(columnVector);
                    break;
                }
                case 'h': {
                    this.rsubi(columnVector);
                    break;
                }
                case 't': {
                    this.rdivi(columnVector);
                }
            }
            return this;
        }
        if (this.rows() == 1 && columnVector.isScalar()) {
            this.applyScalarOp(columnVector, operation);
        } else if (this.rank() == 2 && this.elementWiseStride() == 1 && this.ordering() == 'c' && columnVector.elementWiseStride() == 1) {
            switch (operation) {
                case 'a': {
                    ScalarAdd op = new ScalarAdd(this, columnVector, this, 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'p': {
                    ScalarSet op = new ScalarSet(this, columnVector, this, 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 's': {
                    ScalarSubtraction op = new ScalarSubtraction(this, columnVector, this, 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'm': {
                    ScalarMultiplication op = new ScalarMultiplication(this, columnVector, this, 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'd': {
                    ScalarDivision op = new ScalarDivision(this, columnVector, this, 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'h': {
                    ScalarReverseSubtraction op = new ScalarReverseSubtraction(this, columnVector, this, 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 't': {
                    ScalarReverseDivision op = new ScalarReverseDivision(this, columnVector, this, 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
            }
        } else {
            this.applyBroadcastOp(columnVector, operation);
        }
        return this;
    }

    protected INDArray doRowWise(INDArray rowVector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (rowVector.isScalar()) {
            switch (operation) {
                case 'a': {
                    this.addi(rowVector.getDouble(0L));
                    break;
                }
                case 'p': {
                    this.assign(rowVector.getDouble(0L));
                    break;
                }
                case 's': {
                    this.subi(rowVector.getDouble(0L));
                    break;
                }
                case 'm': {
                    this.muli(rowVector.getDouble(0L));
                    break;
                }
                case 'd': {
                    this.divi(rowVector.getDouble(0L));
                    break;
                }
                case 'h': {
                    this.rsubi(rowVector.getDouble(0L));
                    break;
                }
                case 't': {
                    this.rdivi(rowVector.getDouble(0L));
                }
            }
            return this;
        }
        if (this.isScalar()) {
            switch (operation) {
                case 'a': {
                    return rowVector.addi(this.getDouble(0L));
                }
                case 'p': {
                    return rowVector.assign(this.getDouble(0L));
                }
                case 's': {
                    return rowVector.subi(this.getDouble(0L));
                }
                case 'm': {
                    return rowVector.muli(this.getDouble(0L));
                }
                case 'd': {
                    return rowVector.divi(this.getDouble(0L));
                }
                case 'h': {
                    return rowVector.rsubi(this.getDouble(0L));
                }
                case 't': {
                    return rowVector.rdivi(this.getDouble(0L));
                }
            }
        }
        if (!rowVector.isRowVector() || this.rank() > 1 && rowVector.rank() > 1 && this.size(1) != rowVector.size(1) || rowVector.length() <= 1L) {
            throw new IllegalStateException("Mismatched shapes (shape = " + Arrays.toString(this.shape()) + ", row vector shape =" + Arrays.toString(rowVector.shape()) + ")");
        }
        if (rowVector.data().sameUnderlyingData(this.data())) {
            return this.doRowWise(rowVector.dup(), operation);
        }
        if (this.isVector()) {
            switch (operation) {
                case 'a': {
                    this.addi(rowVector);
                    break;
                }
                case 'p': {
                    this.assign(rowVector);
                    break;
                }
                case 's': {
                    this.subi(rowVector);
                    break;
                }
                case 'm': {
                    this.muli(rowVector);
                    break;
                }
                case 'd': {
                    this.divi(rowVector);
                    break;
                }
                case 'h': {
                    this.rsubi(rowVector);
                    break;
                }
                case 't': {
                    this.rdivi(rowVector);
                }
            }
            return this;
        }
        if (this.rank() == 2 && this.columns() == 1 && rowVector.isScalar()) {
            this.applyScalarOp(rowVector, operation);
        } else if (this.rank() == 2 && this.elementWiseStride() == 1 && this.ordering() == 'f' && rowVector.elementWiseStride() == 1) {
            switch (operation) {
                case 'a': {
                    ScalarAdd op = new ScalarAdd(this, rowVector, this, 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'p': {
                    ScalarSet op = new ScalarSet(this, rowVector, this, 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 's': {
                    ScalarSubtraction op = new ScalarSubtraction(this, rowVector, this, 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'm': {
                    ScalarMultiplication op = new ScalarMultiplication(this, rowVector, this, 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'd': {
                    ScalarDivision op = new ScalarDivision(this, rowVector, this, 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'h': {
                    ScalarReverseSubtraction op = new ScalarReverseSubtraction(this, rowVector, this, 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 't': {
                    ScalarReverseDivision op = new ScalarReverseDivision(this, rowVector, this, 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
            }
        } else {
            this.applyBroadcastOp(rowVector, operation);
        }
        return this;
    }

    private void applyBroadcastOp(INDArray vector, char operation) {
        int alongDimension;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int n = alongDimension = Shape.isRowVectorShape(vector.shape()) ? 1 : 0;
        if (this.data() == vector.data()) {
            vector = vector.dup();
        }
        switch (operation) {
            case 'a': {
                Nd4j.getExecutioner().exec(new BroadcastAddOp(this, vector, this, alongDimension));
                return;
            }
            case 's': {
                Nd4j.getExecutioner().exec(new BroadcastSubOp(this, vector, this, alongDimension));
                return;
            }
            case 'm': {
                Nd4j.getExecutioner().exec(new BroadcastMulOp(this, vector, this, alongDimension));
                return;
            }
            case 'd': {
                Nd4j.getExecutioner().exec(new BroadcastDivOp(this, vector, this, alongDimension));
                return;
            }
            case 'h': {
                Nd4j.getExecutioner().exec(new BroadcastRSubOp(this, vector, this, alongDimension));
                return;
            }
            case 't': {
                Nd4j.getExecutioner().exec(new BroadcastRDivOp(this, vector, this, alongDimension));
                return;
            }
            case 'p': {
                Nd4j.getExecutioner().exec(new BroadcastCopyOp(this, vector, this, alongDimension));
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + operation);
    }

    private void applyScalarOp(INDArray vector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        switch (operation) {
            case 'a': {
                this.addi(vector.getDouble(0L));
                break;
            }
            case 's': {
                this.subi(vector.getDouble(0L));
                break;
            }
            case 'm': {
                this.muli(vector.getDouble(0L));
                break;
            }
            case 'd': {
                this.divi(vector.getDouble(0L));
                break;
            }
            case 'h': {
                this.rsubi(vector.getDouble(0L));
                break;
            }
            case 't': {
                this.rdivi(vector.getDouble(0L));
            }
        }
    }

    protected DataBuffer shapeOf() {
        return Shape.shapeOf(this.shapeInfoDataBuffer());
    }

    protected DataBuffer strideOf() {
        return Shape.stride(this.shapeInfoDataBuffer());
    }

    @Override
    public int stride(int dimension) {
        int rank = this.jvmShapeInfo.rank;
        Preconditions.checkArgument((dimension < rank ? 1 : 0) != 0, (String)"Cannot get stride for dimension %s from rank %s array: dimension indices must be in range -rank <= dimension < rank", (int)dimension, (int)rank);
        if (dimension < 0) {
            return (int)this.stride()[dimension + rank];
        }
        return (int)this.stride()[dimension];
    }

    @Override
    public INDArray rdiviColumnVector(INDArray columnVector) {
        this.validateNumericalArray("rdiviColumnVector", false);
        return this.doColumnWise(columnVector, 't');
    }

    @Override
    public INDArray rdivColumnVector(INDArray columnVector) {
        this.validateNumericalArray("rdivColumnVector", false);
        return this.dup().rdiviColumnVector(columnVector);
    }

    @Override
    public INDArray rdiviRowVector(INDArray rowVector) {
        this.validateNumericalArray("rdiviRowVector", false);
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public INDArray rdivRowVector(INDArray rowVector) {
        this.validateNumericalArray("rdivRowVector", false);
        return this.dup().rdiviRowVector(rowVector);
    }

    @Override
    public INDArray rsubiColumnVector(INDArray columnVector) {
        this.validateNumericalArray("rsubiColumnVector", false);
        return this.doColumnWise(columnVector, 'h');
    }

    @Override
    public INDArray rsubColumnVector(INDArray columnVector) {
        this.validateNumericalArray("rsubColumnVector", false);
        return this.dup().rsubiColumnVector(columnVector);
    }

    @Override
    public INDArray rsubiRowVector(INDArray rowVector) {
        this.validateNumericalArray("rsubiRowVector", false);
        return this.doRowWise(rowVector, 'h');
    }

    @Override
    public INDArray rsubRowVector(INDArray rowVector) {
        this.validateNumericalArray("rsubRowVector", false);
        return this.dup().rsubiRowVector(rowVector);
    }

    @Override
    public INDArray put(int i, INDArray element) {
        Preconditions.checkArgument((boolean)element.isScalar(), (String)"Element must be a scalar: element has shape %ndShape", (Object)element);
        return this.putScalar((long)i, element.getDouble(0L));
    }

    @Override
    public INDArray diviColumnVector(INDArray columnVector) {
        this.validateNumericalArray("diviColumnVector", false);
        return this.doColumnWise(columnVector, 'd');
    }

    @Override
    public INDArray divColumnVector(INDArray columnVector) {
        this.validateNumericalArray("divColumnVector", false);
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public INDArray diviRowVector(INDArray rowVector) {
        this.validateNumericalArray("diviRowVector", false);
        return this.doRowWise(rowVector, 'd');
    }

    @Override
    public INDArray divRowVector(INDArray rowVector) {
        this.validateNumericalArray("divRowVector", false);
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public INDArray muliColumnVector(INDArray columnVector) {
        this.validateNumericalArray("muliColumnVector", false);
        return this.doColumnWise(columnVector, 'm');
    }

    @Override
    public INDArray mulColumnVector(INDArray columnVector) {
        this.validateNumericalArray("mulColumnVector", false);
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public INDArray muliRowVector(INDArray rowVector) {
        this.validateNumericalArray("muliRowVector", false);
        return this.doRowWise(rowVector, 'm');
    }

    @Override
    public INDArray mulRowVector(INDArray rowVector) {
        this.validateNumericalArray("mulRowVector", false);
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public INDArray subiColumnVector(INDArray columnVector) {
        this.validateNumericalArray("subiColumnVector", false);
        return this.doColumnWise(columnVector, 's');
    }

    @Override
    public INDArray subColumnVector(INDArray columnVector) {
        this.validateNumericalArray("subColumnVector", false);
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public INDArray subiRowVector(INDArray rowVector) {
        this.validateNumericalArray("subiRowVector", false);
        return this.doRowWise(rowVector, 's');
    }

    @Override
    public INDArray subRowVector(INDArray rowVector) {
        this.validateNumericalArray("subRowVector", false);
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public INDArray addiColumnVector(INDArray columnVector) {
        this.validateNumericalArray("addiColumnVector", false);
        return this.doColumnWise(columnVector, 'a');
    }

    @Override
    public INDArray putiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'p');
    }

    @Override
    public INDArray addColumnVector(INDArray columnVector) {
        this.validateNumericalArray("addColumnVector", false);
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public INDArray addiRowVector(INDArray rowVector) {
        this.validateNumericalArray("addiRowVector", false);
        return this.doRowWise(rowVector, 'a');
    }

    @Override
    public INDArray putiRowVector(INDArray rowVector) {
        this.validateNumericalArray("putiRowVector", false);
        return this.doRowWise(rowVector, 'p');
    }

    @Override
    public INDArray addRowVector(INDArray rowVector) {
        this.validateNumericalArray("addRowVector", false);
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result, MMulTranspose mMulTranspose) {
        return mMulTranspose.exec(this, other, result);
    }

    @Override
    public INDArray mmul(INDArray other, MMulTranspose mMulTranspose) {
        return mMulTranspose.exec(this, other, null);
    }

    @Override
    public INDArray mmul(INDArray other) {
        Preconditions.checkState((this.dataType() == other.dataType() ? 1 : 0) != 0, (String)"Matrix multiplication: arrays must have same dtype: %s vs. %s", (Object)this.dataType(), (Object)other.dataType());
        long[] shape = new long[]{this.rows(), other.rank() == 1 ? 1L : (long)other.columns()};
        INDArray result = Nd4j.createUninitialized(this.dataType(), shape, 'f');
        if (result.isScalar()) {
            return Nd4j.scalar(this.dataType(), Nd4j.getBlasWrapper().dot(this, other)).reshape(1L, 1L);
        }
        return this.mmuli(other, result);
    }

    protected INDArray create(int[] shape, char ordering) {
        return Nd4j.create(shape, ordering);
    }

    @Override
    public double[][] toDoubleMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix! Shape: " + Shape.shapeToStringShort(this));
        }
        if (this.size(0) > Integer.MAX_VALUE || this.size(1) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        double[][] ret = new double[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asDouble();
        }
        return ret;
    }

    @Override
    public double[] toDoubleVector() {
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector! Shape: " + Shape.shapeToStringShort(this));
        }
        return this.dup().data().asDouble();
    }

    @Override
    public float[] toFloatVector() {
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector! Shape: " + Shape.shapeToStringShort(this));
        }
        return this.dup().data().asFloat();
    }

    @Override
    public float[][] toFloatMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix! Shape: " + Shape.shapeToStringShort(this));
        }
        if (this.rows() > Integer.MAX_VALUE || this.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        float[][] ret = new float[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asFloat();
        }
        return ret;
    }

    @Override
    public int[] toIntVector() {
        if (this.isEmpty()) {
            return new int[0];
        }
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector! Shape: " + Shape.shapeToStringShort(this));
        }
        if (this.isView() || this.elementWiseStride() != 1) {
            return this.dup().data().asInt();
        }
        return this.data().asInt();
    }

    @Override
    public long[] toLongVector() {
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector! Shape: " + Shape.shapeToStringShort(this));
        }
        if (this.isView() || this.elementWiseStride() != 1) {
            return this.dup().data().asLong();
        }
        return this.data().asLong();
    }

    @Override
    public long[][] toLongMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix! Shape: " + Shape.shapeToStringShort(this));
        }
        if (this.rows() > Integer.MAX_VALUE || this.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        long[][] ret = new long[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asLong();
        }
        return ret;
    }

    @Override
    public int[][] toIntMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix! Shape: " + Shape.shapeToStringShort(this));
        }
        if (this.rows() > Integer.MAX_VALUE || this.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int[][] ret = new int[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asInt();
        }
        return ret;
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result) {
        return this.mmuli(other, result);
    }

    @Override
    public INDArray div(INDArray other) {
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return this.divi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), Shape.broadcastOutputShape(this.shape(), other.shape()), this.ordering()));
        }
        return this.divi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), this.shape(), this.ordering()));
    }

    @Override
    public INDArray div(INDArray other, INDArray result) {
        this.validateNumericalArray("div", true);
        return this.divi(other, result);
    }

    @Override
    public INDArray mul(INDArray other) {
        this.validateNumericalArray("mul", false);
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return this.muli(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), Shape.broadcastOutputShape(this.shape(), other.shape()), this.ordering()));
        }
        INDArray z = Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), this.shape(), this.ordering());
        return this.muli(other, z);
    }

    @Override
    public INDArray mul(INDArray other, INDArray result) {
        return this.muli(other, result);
    }

    @Override
    public INDArray sub(INDArray other) {
        this.validateNumericalArray("sub", false);
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return this.subi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), Shape.broadcastOutputShape(this.shape(), other.shape()), this.ordering()));
        }
        return this.subi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), this.shape(), this.ordering()));
    }

    @Override
    public INDArray sub(INDArray other, INDArray result) {
        return this.subi(other, result);
    }

    @Override
    public INDArray add(INDArray other) {
        this.validateNumericalArray("add", false);
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return this.addi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), Shape.broadcastOutputShape(this.shape(), other.shape()), this.ordering()));
        }
        return this.addi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), this.shape(), this.ordering()));
    }

    @Override
    public INDArray add(INDArray other, INDArray result) {
        this.validateNumericalArray("add", false);
        return this.addi(other, result);
    }

    @Override
    public INDArray mmuli(INDArray other, MMulTranspose transpose) {
        this.validateNumericalArray("mmuli", false);
        return this.dup().mmuli(other, this, transpose);
    }

    @Override
    public INDArray mmuli(INDArray other) {
        this.validateNumericalArray("mmuli", false);
        return this.dup().mmuli(other, this);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result, MMulTranspose transpose) {
        return transpose.exec(this, other, result);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result) {
        this.validateNumericalArray("mmuli", false);
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.rank() == 1) {
            Preconditions.checkState((result.length() == this.size(0) && this.size(1) == other.size(0) ? 1 : 0) != 0, (String)"Invalid matrix multiplication: %ndShape x %ndShape with result shape %ndShape", (Object)this, (Object)other, (Object)result);
        } else {
            Preconditions.checkState((result.rank() == 2 && result.size(0) == this.size(0) && result.size(1) == other.size(1) ? 1 : 0) != 0, (String)"Invalid result array shape: expected shape [%s,%s], got shape %ndShape result array for %ndShape x %ndShape", (Object)this.size(0), (Object)other.size(1), (Object)result, (Object)this, (Object)other);
        }
        if (other.isScalar()) {
            return this.muli(other.getDouble(0L), result);
        }
        if (this.isScalar()) {
            return other.muli(this.getDouble(0L), result);
        }
        if (result == this || result == other) {
            INDArray temp = Nd4j.create(result.dataType(), result.shape(), Nd4j.getStrides(result.shape(), 'f'), 'f');
            if (other.columns() == 1 || other.rank() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), 1.0, this, other, 0.0, temp);
            } else {
                Nd4j.getBlasWrapper().level3().gemm(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(temp), 1.0, this, other, 0.0, temp);
            }
            result.assign(temp);
        } else {
            boolean requiresTemp = result.ordering() != 'f' || result.isView() || !Shape.hasDefaultStridesForShape(result);
            INDArray gemmResultArr = requiresTemp ? Nd4j.createUninitialized(result.dataType(), result.shape(), 'f') : result;
            if (other.columns() == 1 || other.rank() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(this.ordering(), BlasBufferUtil.getCharForTranspose(other), 1.0, this, other, 0.0, gemmResultArr);
            } else {
                Nd4j.getBlasWrapper().level3().gemm(this.ordering(), BlasBufferUtil.getCharForTranspose(other), BlasBufferUtil.getCharForTranspose(gemmResultArr), 1.0, this, other, 0.0, gemmResultArr);
            }
            if (requiresTemp) {
                result.assign(gemmResultArr);
            }
        }
        if (other.rank() == 1) {
            result = result.reshape(result.length());
        }
        return result;
    }

    private INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride);
    }

    @Override
    public INDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public INDArray divi(INDArray other, INDArray result) {
        this.validateNumericalArray("divi", false);
        Shape.assertBroadcastable("divi", this, other, result);
        Nd4j.exec(new DivOp(this, other, result));
        return result;
    }

    @Override
    public INDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public INDArray muli(INDArray other, INDArray result) {
        this.validateNumericalArray("muli", false);
        Shape.assertBroadcastable("muli", this, other, result);
        Nd4j.exec(new MulOp(this, other, result));
        return result;
    }

    @Override
    public INDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public INDArray subi(INDArray other, INDArray result) {
        this.validateNumericalArray("subi", false);
        Shape.assertBroadcastable("subi", this, other, result);
        Nd4j.exec(new SubOp(this, other, result));
        return result;
    }

    @Override
    public INDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public INDArray addi(INDArray other, INDArray result) {
        this.validateNumericalArray("addi", false);
        Shape.assertBroadcastable("addi", this, other, result);
        Nd4j.exec(new AddOp(this, other, result));
        return result;
    }

    @Override
    public INDArray normmax(boolean keepDims, int ... dimension) {
        this.validateNumericalArray("normmax", false);
        return Nd4j.getExecutioner().exec(new NormMax((INDArray)this, keepDims, dimension));
    }

    @Override
    public INDArray normmax(int ... dimension) {
        return this.normmax(false, dimension);
    }

    @Override
    public INDArray rdiv(INDArray other) {
        this.validateNumericalArray("rdiv", false);
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return this.rdivi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), Shape.broadcastOutputShape(this.shape(), other.shape()), this.ordering()));
        }
        return this.rdivi(other, this.ulike());
    }

    @Override
    public INDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public INDArray rdiv(INDArray other, INDArray result) {
        this.validateNumericalArray("rdiv", false);
        return this.dup().rdivi(other, result);
    }

    @Override
    public INDArray rdivi(INDArray other, INDArray result) {
        this.validateNumericalArray("rdivi", false);
        Shape.assertBroadcastable("rdivi", this, other, result);
        Nd4j.exec(new RDivOp(this, other, result));
        return result;
    }

    @Override
    public INDArray rsub(INDArray other, INDArray result) {
        this.validateNumericalArray("rsub", false);
        return this.rsubi(other, result);
    }

    @Override
    public INDArray rsub(INDArray other) {
        this.validateNumericalArray("rsub", false);
        if (Shape.areShapesBroadcastable(this.shape(), other.shape())) {
            return this.rsubi(other, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), other.dataType()), Shape.broadcastOutputShape(this.shape(), other.shape()), this.ordering()));
        }
        return this.rsubi(other, this.ulike());
    }

    @Override
    public INDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public INDArray rsubi(INDArray other, INDArray result) {
        this.validateNumericalArray("rsubi", false);
        Shape.assertBroadcastable("rsubi", this, other, result);
        Nd4j.exec(new RSubOp(this, other, result));
        return result;
    }

    @Override
    public INDArray assign(Number value) {
        Preconditions.checkState((this.dataType() != DataType.BOOL || value.doubleValue() == 0.0 || value.doubleValue() == 1.0 ? 1 : 0) != 0, (String)"Only values 0 or 1 are allowed for scalar assign on boolean arrays: got value %s on to assign to boolean array with shape %ndShape", (Object)value, (Object)this);
        Nd4j.getExecutioner().exec(new ScalarSet((INDArray)this, value));
        return this;
    }

    @Override
    public INDArray assign(boolean value) {
        return this.assign(value ? 1 : 0);
    }

    @Override
    public INDArray assignIf(INDArray arr, Condition condition) {
        BooleanIndexing.assignIf(this, arr, condition);
        return this;
    }

    @Override
    public INDArray replaceWhere(INDArray arr, Condition condition) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        BooleanIndexing.replaceWhere((INDArray)this, arr, condition);
        return this;
    }

    @Override
    @Deprecated
    public long linearIndex(long i) {
        long idx = i;
        for (int j = 0; j < this.jvmShapeInfo.rank - 1; ++j) {
            if (this.size((int)i) == 1L) continue;
            idx += i * (long)this.stride(j);
        }
        return (long)Shape.offset(this.jvmShapeInfo.javaShapeInformation) + idx;
    }

    @Override
    public INDArray slice(long slice) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long slices = this.slices();
        if (slice >= slices) {
            throw new IllegalArgumentException("Illegal slice " + slice);
        }
        if (this.jvmShapeInfo.rank == 0) {
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (slice < 0L) {
            slice += (long)this.rank();
        }
        INDArrayIndex[] indexes = new INDArrayIndex[this.rank()];
        indexes[0] = NDArrayIndex.point(slice);
        for (int i = 1; i < this.rank(); ++i) {
            indexes[i] = NDArrayIndex.all();
        }
        return this.get(indexes);
    }

    protected INDArray createScalarForIndex(long i, boolean applyOffset) {
        if (this.isVector()) {
            return this.getScalar(i);
        }
        return Nd4j.create(this.data(), new long[]{1L, 1L}, new long[]{1L, 1L}, i);
    }

    protected INDArray createScalar(double d) {
        return Nd4j.scalar(d);
    }

    @Override
    public int getTrailingOnes() {
        int numLeadingOnes = 0;
        for (int i = this.rank() - 1; i > 0; --i) {
            if (this.size(i) != 1L) continue;
            ++numLeadingOnes;
        }
        return numLeadingOnes;
    }

    @Override
    public int getLeadingOnes() {
        int numLeadingOnes = 0;
        for (int i = 0; i < this.rank(); ++i) {
            if (this.size(i) != 1L) continue;
            ++numLeadingOnes;
        }
        return numLeadingOnes;
    }

    @Override
    public INDArray slice(long slice, int dimension) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long slices = this.size(dimension);
        if (slice >= slices) {
            throw new IllegalArgumentException("Illegal slice " + slice);
        }
        if (this.jvmShapeInfo.rank == 0) {
            if (slice == 0L) {
                return this.createScalarForIndex(slice, true);
            }
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (slice < 0L) {
            slice += (long)this.rank();
        }
        INDArrayIndex[] indexes = new INDArrayIndex[this.rank()];
        indexes[dimension] = NDArrayIndex.point(slice);
        for (int i = 0; i < this.rank(); ++i) {
            if (i == dimension) continue;
            indexes[i] = NDArrayIndex.all();
        }
        return this.get(indexes);
    }

    @Override
    public INDArray getScalar(int[] indexes) {
        if (indexes.length > this.rank()) {
            throw new ND4JIllegalStateException("Indexes can't be longer then array rank");
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0) continue;
            int n = i;
            indexes[n] = (int)((long)indexes[n] + this.size(i));
        }
        long idx = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        DataBuffer buffer = Nd4j.createBuffer(this.data(), idx, 1L);
        Pair<DataBuffer, long[]> shape = Nd4j.getShapeInfoProvider().createShapeInformation(new long[0], new long[0], 1L, 'c', this.dataType(), false);
        return Nd4j.createArrayFromShapeBuffer(buffer, shape);
    }

    @Override
    public INDArray getScalar(long ... indexes) {
        if (indexes.length > this.rank()) {
            throw new ND4JIllegalStateException("Indexes can't be longer then array rank");
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0L) continue;
            int n = i;
            indexes[n] = indexes[n] + this.size(i);
        }
        long idx = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        DataBuffer buffer = Nd4j.createBuffer(this.data(), idx, 1L);
        Pair<DataBuffer, long[]> shape = Nd4j.getShapeInfoProvider().createShapeInformation(new long[0], new long[0], 1L, 'c', this.dataType(), false);
        return Nd4j.createArrayFromShapeBuffer(buffer, shape);
    }

    @Override
    public INDArray rdiv(Number n) {
        return this.rdivi(n, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), n), this.shape(), this.ordering()));
    }

    @Override
    public INDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public INDArray rsub(Number n) {
        this.validateNumericalArray("rsub", false);
        return this.rsubi(n, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), n), this.shape(), this.ordering()));
    }

    @Override
    public INDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public INDArray div(Number n) {
        this.validateNumericalArray("div", false);
        return this.divi(n, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), n), this.shape(), this.ordering()));
    }

    @Override
    public INDArray divi(Number n) {
        return this.divi(n, (INDArray)this);
    }

    @Override
    public INDArray mul(Number n) {
        this.validateNumericalArray("mul", false);
        return this.muli(n, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), n), this.shape(), this.ordering()));
    }

    @Override
    public INDArray muli(Number n) {
        return this.muli(n, (INDArray)this);
    }

    @Override
    public INDArray sub(Number n) {
        this.validateNumericalArray("sub", false);
        return this.subi(n, Nd4j.createUninitialized(this.dataType(), this.shape(), this.ordering()));
    }

    @Override
    public INDArray subi(Number n) {
        return this.subi(n, (INDArray)this);
    }

    @Override
    public INDArray add(Number n) {
        this.validateNumericalArray("add", false);
        return this.addi(n, Nd4j.createUninitialized(Shape.pickPairwiseDataType(this.dataType(), n), this.shape(), this.ordering()));
    }

    @Override
    public INDArray addi(Number n) {
        return this.addi(n, (INDArray)this);
    }

    @Override
    public INDArray repmat(int[] shape) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long rows = this.rows() * shape[0];
        long cols = this.columns() * shape[1];
        INDArray ret = this.reshape(1L, this.length()).repeat(0, shape[0]).reshape(rows, (long)this.columns()).repeat(0, shape[1]);
        return ret.reshape(rows, cols);
    }

    @Override
    public INDArray repeat(int dimension, long ... repeats) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        DynamicCustomOp op = DynamicCustomOp.builder("repeat").addInputs(this).addIntegerArguments(ArrayUtil.toInts((long[])repeats)).build();
        op.addIArgument(new int[]{dimension});
        LongShapeDescriptor l = op.calculateOutputShape().get(0);
        INDArray out = Nd4j.create(l);
        op.addOutputArgument(out);
        Nd4j.exec(op);
        return out;
    }

    @Override
    public INDArray putRow(long row, INDArray toPut) {
        if (this.isRowVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.point(row), NDArrayIndex.all()}, toPut);
    }

    @Override
    public INDArray putColumn(int column, INDArray toPut) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isColumnVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.point(column)}, toPut);
    }

    @Override
    public Number getNumber(long i) {
        switch (this.dataType()) {
            case DOUBLE: 
            case FLOAT: 
            case HALF: {
                return this.getDouble(i);
            }
            case LONG: 
            case INT: 
            case SHORT: 
            case UBYTE: 
            case BYTE: 
            case BOOL: {
                return this.getLong(i);
            }
        }
        throw new UnsupportedOperationException("Cannot get number from array of datatype: " + this.dataType());
    }

    @Override
    public Number getNumber(long ... idx) {
        switch (this.dataType()) {
            case DOUBLE: 
            case FLOAT: 
            case HALF: {
                return this.getDouble(idx);
            }
            case LONG: 
            case INT: 
            case SHORT: 
            case UBYTE: 
            case BYTE: 
            case BOOL: {
                return this.getLong(idx);
            }
        }
        throw new UnsupportedOperationException("Cannot get number from array of datatype: " + this.dataType());
    }

    @Override
    public double getDouble(long i) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"Unable to get value from empty array");
        if (i >= this.length()) {
            throw new IllegalArgumentException("Unable to get linear index " + i + ": values is greater than length (" + this.length() + ")");
        }
        this.autoProcessScalarCall();
        if (i == 0L) {
            return this.data().getDouble(i);
        }
        long[] dimensions = this.ordering() == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        Shape.assertShapeLessThan(dimensions, this.shape());
        return this.getDouble(dimensions);
    }

    @Override
    public double getDouble(long i, long j) {
        return this.getDouble(new long[]{i, j});
    }

    @Override
    public float getFloat(long i) {
        return (float)this.getDouble(i);
    }

    @Override
    public float getFloat(long i, long j) {
        return (float)this.getDouble(i, j);
    }

    @Override
    public INDArray transpose() {
        Preconditions.checkState((this.rank() >= 2 ? 1 : 0) != 0, (String)"Can't transpose array with rank < 2: array shape %ndShape", (Object)this);
        return this.permute(ArrayUtil.reverseCopy((int[])ArrayUtil.range((int)0, (int)this.rank())));
    }

    @Override
    public INDArray transposei() {
        Preconditions.checkState((this.rank() >= 2 ? 1 : 0) != 0, (String)"Can't transpose array with rank < 2: array shape %ndShape", (Object)this);
        return this.permutei(ArrayUtil.reverseCopy((int[])ArrayUtil.range((int)0, (int)this.rank())));
    }

    protected INDArray create(DataBuffer data, int[] shape, int[] strides) {
        return Nd4j.create(data, shape, strides, 0L, this.ordering());
    }

    @Override
    public INDArray reshape(char order, int ... newShape) {
        return this.reshape(order, ArrayUtil.toLongArray((int[])newShape));
    }

    @Override
    public INDArray reshape(char order, long ... newShape) {
        return this.reshape(order, false, newShape);
    }

    @Override
    public INDArray reshape(char order, boolean enforceView, long ... newShape) {
        long prod;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.length() == 1L && (newShape == null || newShape.length == 0) && this.elementWiseStride() == 1) {
            return Nd4j.create(this.data(), new int[0], new int[0], 0L);
        }
        if (newShape == null || newShape.length < 1) {
            throw new ND4JIllegalStateException("Can't reshape(long...) without shape arguments. Got empty shape instead.");
        }
        if (newShape.length == 1 && newShape[0] == -1L) {
            newShape[0] = this.length();
        }
        int numberNegativesOnes = 0;
        long[] shape = ArrayUtil.copy((long[])newShape);
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 0L) continue;
            if (numberNegativesOnes >= 1) {
                throw new IllegalArgumentException("Only one dimension can be negative ones. Got shape " + Arrays.toString(newShape));
            }
            ++numberNegativesOnes;
            int shapeLength = 1;
            for (int j = 0; j < shape.length; ++j) {
                if (shape[j] < 1L) continue;
                shapeLength = (int)((long)shapeLength * shape[j]);
            }
            long realShape = Math.abs(this.length() / (long)shapeLength);
            long[] thisNewShape = new long[shape.length];
            for (int j = 0; j < shape.length; ++j) {
                thisNewShape[j] = i != j ? shape[j] : realShape;
            }
            shape = thisNewShape;
            break;
        }
        if ((prod = ArrayUtil.prodLong((long[])shape)) != this.length()) {
            throw new ND4JIllegalStateException("New shape length doesn't match original length: [" + prod + "] vs [" + this.length() + "]. Original shape: " + Arrays.toString(this.shape()) + " New Shape: " + Arrays.toString(newShape));
        }
        INDArray reshapeAttempt = Shape.newShapeNoCopy((INDArray)this, shape, order == 'f');
        if (reshapeAttempt != null) {
            return reshapeAttempt;
        }
        if (enforceView) {
            throw new ND4JIllegalStateException("Unable to reshape array as view, called with enforceView=true. Use enforceView=false to return a copy instead, or call reshape on a non-strided array. Array shape info: " + this.shapeInfoToString().replaceAll("\n", ""));
        }
        if (order != this.ordering()) {
            INDArray ret = Nd4j.createUninitialized(this.dataType(), shape, order);
            ret.setData(this.dup(order).data());
            return ret;
        }
        INDArray ret = this.dup(order);
        return Nd4j.create(ret.data(), shape);
    }

    @Override
    public double getDoubleUnsafe(long offset) {
        return this.data().getDouble(offset);
    }

    @Override
    public INDArray putScalarUnsafe(long offset, double value) {
        this.autoProcessScalarCall();
        this.data().put(offset, value);
        return this;
    }

    @Override
    public INDArray reshape(char order, int rows, int columns) {
        return this.reshape(order, new long[]{rows, columns});
    }

    @Override
    public INDArray reshape(int[] shape) {
        return this.reshape(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray reshape(long ... shape) {
        return this.reshape(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray prod(boolean keepDims, int ... dimension) {
        this.validateNumericalArray("prod", false);
        return Nd4j.getExecutioner().exec(new Prod((INDArray)this, keepDims, dimension));
    }

    @Override
    public INDArray prod(int ... dimension) {
        return this.prod(false, dimension);
    }

    @Override
    public INDArray mean(boolean keepDims, int ... dimension) {
        this.validateNumericalArray("mean", false);
        return Nd4j.getExecutioner().exec(new Mean((INDArray)this, keepDims, dimension));
    }

    @Override
    public INDArray mean(int ... dimension) {
        return this.mean(false, dimension);
    }

    @Override
    public INDArray amean(int ... dimension) {
        this.validateNumericalArray("amean", false);
        return Nd4j.getExecutioner().exec(new AMean((INDArray)this, dimension));
    }

    @Override
    public INDArray mean(@NonNull INDArray result, boolean keepDims, int ... dimension) {
        if (result == null) {
            throw new NullPointerException("result is marked @NonNull but is null");
        }
        this.validateNumericalArray("mean", false);
        return Nd4j.getExecutioner().exec(new Mean((INDArray)this, result, keepDims, dimension));
    }

    @Override
    public INDArray mean(@NonNull INDArray result, int ... dimension) {
        if (result == null) {
            throw new NullPointerException("result is marked @NonNull but is null");
        }
        return this.mean(result, false, dimension);
    }

    @Override
    public INDArray var(int ... dimension) {
        this.validateNumericalArray("var", false);
        return Nd4j.getExecutioner().exec(new Variance((INDArray)this, dimension));
    }

    @Override
    public INDArray var(boolean biasCorrected, int ... dimension) {
        this.validateNumericalArray("var", false);
        return Nd4j.getExecutioner().exec(new Variance((INDArray)this, biasCorrected, dimension));
    }

    @Override
    public INDArray max(boolean keepDims, int ... dimension) {
        this.validateNumericalArray("max", false);
        return Nd4j.getExecutioner().exec(new Max((INDArray)this, keepDims, dimension));
    }

    @Override
    public INDArray max(int ... dimension) {
        return this.max(false, dimension);
    }

    @Override
    public INDArray amax(int ... dimension) {
        this.validateNumericalArray("amax", false);
        return Nd4j.getExecutioner().exec(new AMax((INDArray)this, dimension));
    }

    @Override
    public INDArray min(boolean keepDims, int ... dimension) {
        this.validateNumericalArray("min", false);
        return Nd4j.getExecutioner().exec(new Min((INDArray)this, keepDims, dimension));
    }

    @Override
    public INDArray min(int ... dimension) {
        return this.min(false, dimension);
    }

    @Override
    public INDArray amin(int ... dimension) {
        this.validateNumericalArray("amin", false);
        return Nd4j.getExecutioner().exec(new AMin((INDArray)this, dimension));
    }

    @Override
    public INDArray sum(int ... dimension) {
        this.validateNumericalArray("sum", true);
        return Nd4j.getExecutioner().exec(new Sum((INDArray)this, dimension));
    }

    @Override
    public INDArray sum(boolean keepDim, int ... dimension) {
        this.validateNumericalArray("sum", true);
        return Nd4j.getExecutioner().exec(new Sum((INDArray)this, null, keepDim, dimension));
    }

    @Override
    public INDArray entropy(int ... dimension) {
        this.validateNumericalArray("entropy", false);
        return Nd4j.getExecutioner().exec(new Entropy((INDArray)this, dimension));
    }

    @Override
    public INDArray shannonEntropy(int ... dimension) {
        this.validateNumericalArray("shannonEntropy", false);
        return Nd4j.getExecutioner().exec(new ShannonEntropy((INDArray)this, dimension));
    }

    @Override
    public INDArray logEntropy(int ... dimension) {
        this.validateNumericalArray("logEntropy", false);
        return Nd4j.getExecutioner().exec(new LogEntropy((INDArray)this, dimension));
    }

    @Override
    public INDArray sum(@NonNull INDArray result, boolean keepDims, int ... dimension) {
        if (result == null) {
            throw new NullPointerException("result is marked @NonNull but is null");
        }
        this.validateNumericalArray("sum", true);
        return Nd4j.getExecutioner().exec(new Sum((INDArray)this, result, keepDims, dimension));
    }

    @Override
    public INDArray sum(@NonNull INDArray result, int ... dimension) {
        if (result == null) {
            throw new NullPointerException("result is marked @NonNull but is null");
        }
        return this.sum(result, false, dimension);
    }

    @Override
    public INDArray norm1(int ... dimension) {
        return this.norm1(false, dimension);
    }

    @Override
    public INDArray norm1(boolean keepDims, int ... dimension) {
        this.validateNumericalArray("norm1", false);
        return Nd4j.getExecutioner().exec(new Norm1((INDArray)this, keepDims, dimension));
    }

    @Override
    public INDArray std(int ... dimension) {
        return this.std(true, dimension);
    }

    @Override
    public INDArray std(boolean biasCorrected, int ... dimension) {
        return this.std(biasCorrected, false, dimension);
    }

    @Override
    public INDArray std(boolean biasCorrected, boolean keepDims, int ... dimension) {
        this.validateNumericalArray("std", false);
        return Nd4j.getExecutioner().exec(new StandardDeviation((INDArray)this, biasCorrected, keepDims, dimension));
    }

    @Override
    public Number stdNumber(boolean biasCorrected) {
        this.validateNumericalArray("stdNumber", false);
        return Nd4j.getExecutioner().exec(new StandardDeviation((INDArray)this, biasCorrected, new int[0])).getDouble(0L);
    }

    @Override
    public INDArray norm2(boolean keepDims, int ... dimension) {
        this.validateNumericalArray("norm2", false);
        return Nd4j.getExecutioner().exec(new Norm2((INDArray)this, keepDims, dimension));
    }

    @Override
    public INDArray norm2(int ... dimension) {
        return this.norm2(false, dimension);
    }

    @Override
    public int columns() {
        if (this.isMatrix()) {
            return (int)this.size(1);
        }
        if (Shape.isColumnVectorShape(this.shape())) {
            return 1;
        }
        if (Shape.isRowVectorShape(this.shape())) {
            return (int)this.length();
        }
        throw new IllegalStateException("Rank is [" + this.rank() + "]; columns() call is not valid");
    }

    @Override
    public int rows() {
        if (this.isMatrix()) {
            return (int)this.size(0);
        }
        if (Shape.isRowVectorShape(this.shape())) {
            return 1;
        }
        if (Shape.isColumnVectorShape(this.shape())) {
            return (int)this.length();
        }
        throw new IllegalStateException("Rank is " + this.rank() + " rows() call is not valid");
    }

    @Override
    public INDArray ravel(char ordering) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (ordering == this.ordering() && Shape.hasDefaultStridesForShape(this)) {
            return this.reshape((long)ordering, this.length());
        }
        return this.dup(ordering).reshape((long)ordering, this.length());
    }

    @Override
    public INDArray ravel() {
        return this.reshape(this.length());
    }

    @Override
    public void sliceVectors(List<INDArray> list) {
        if (this.isVector()) {
            list.add(this);
        } else {
            int i = 0;
            while ((long)i < this.slices()) {
                this.slice(i).sliceVectors(list);
                ++i;
            }
        }
    }

    @Override
    public INDArray reshape(long newRows, long newColumns) {
        return this.reshape(new long[]{newRows, newColumns});
    }

    @Override
    public INDArray getColumn(long c) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isColumnVector() && c == 0L) {
            return this;
        }
        if (this.isColumnVector() && c > 0L) {
            throw new IllegalArgumentException("Illegal index for column");
        }
        Preconditions.checkArgument((this.rank() == 2 ? 1 : 0) != 0, (String)"getColumn() can be called on 2D arrays only");
        return this.tensorAlongDimension(c, 0);
    }

    @Override
    public INDArray getColumn(long c, boolean keepDim) {
        INDArray col = this.getColumn(c);
        if (!keepDim) {
            return col;
        }
        return col.reshape(col.length(), 1L);
    }

    @Override
    public INDArray getRows(int[] rindices) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!this.isMatrix() && !this.isVector()) {
            throw new IllegalArgumentException("Unable to get columns from a non matrix or vector");
        }
        if (this.isVector()) {
            return Nd4j.pullRows((INDArray)this, 1, rindices);
        }
        INDArray ret = Nd4j.createUninitialized(this.dataType(), rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            ret.putRow(i, this.getRow(rindices[i]));
        }
        return ret;
    }

    @Override
    public INDArray get(INDArrayIndex ... indexes) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int numPoint = 0;
        int numInterval = 0;
        int numAll = 0;
        int numNewAxis = 0;
        int numSpecified = 0;
        for (INDArrayIndex i : indexes) {
            if (i instanceof PointIndex) {
                ++numPoint;
                continue;
            }
            if (i instanceof NDArrayIndexAll) {
                ++numAll;
                continue;
            }
            if (i instanceof IntervalIndex) {
                ++numInterval;
                continue;
            }
            if (i instanceof NewAxis) {
                ++numNewAxis;
                continue;
            }
            if (i instanceof SpecifiedIndex) {
                ++numSpecified;
                continue;
            }
            throw new IllegalStateException("Unknown index: " + i);
        }
        if (indexes.length - numNewAxis < this.rank()) {
            int e;
            INDArrayIndex[] newIndexes = new INDArrayIndex[this.rank() + numNewAxis];
            for (e = 0; e < indexes.length; ++e) {
                newIndexes[e] = indexes[e];
            }
            for (e = indexes.length; e < newIndexes.length; ++e) {
                ++numAll;
                newIndexes[e] = NDArrayIndex.all();
            }
            indexes = newIndexes;
        }
        Preconditions.checkState((numPoint + numInterval + numAll + numSpecified == this.rank() ? 1 : 0) != 0, (String)"Illegal set of indices for array: need at least %s point/interval/all/specified indices for rank %s array (%ndShape), got indices %s", (Object)this.rank(), (Object)this.rank(), (Object)this, (Object)indexes);
        int outRank = this.rank() + numNewAxis - numPoint;
        Preconditions.checkState((outRank >= 0 ? 1 : 0) != 0, (String)"Illegal set of indices for array: %ndShape, %s", (Object)this, (Object)indexes);
        long[] outShape = new long[outRank];
        long[] outStrides = new long[outRank];
        long offset = this.offset();
        int outIdx = 0;
        int inIdx = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] instanceof PointIndex) {
                PointIndex pi = (PointIndex)indexes[i];
                offset += pi.offset() * (long)this.stride(inIdx);
                ++inIdx;
                continue;
            }
            if (indexes[i] instanceof NDArrayIndexAll) {
                outShape[outIdx] = this.size(inIdx);
                outStrides[outIdx] = this.stride(inIdx);
                ++inIdx;
                ++outIdx;
                continue;
            }
            if (indexes[i] instanceof IntervalIndex) {
                IntervalIndex ii = (IntervalIndex)indexes[i];
                long start = ii.offset();
                long endInc = ii.end() - (long)(ii.isInclusive() ? 0 : 1);
                if (endInc >= this.size(inIdx)) {
                    throw new IllegalStateException("Indices are out of range: Cannot get interval index " + indexes[i] + " on array with size(" + inIdx + ")=" + this.size(inIdx) + ". Array shape: " + Arrays.toString(this.shape()) + ", indices: " + Arrays.toString(indexes));
                }
                long stride = ii.stride();
                long length = (endInc - start) / stride + 1L;
                offset += ii.offset() * (long)this.stride(inIdx);
                outShape[outIdx] = length;
                outStrides[outIdx] = ii.stride() * (long)this.stride(inIdx);
                ++inIdx;
                ++outIdx;
                continue;
            }
            if (indexes[i] instanceof NewAxis) {
                outShape[outIdx] = 1L;
                outStrides[outIdx] = outIdx > 0 ? outStrides[outIdx - 1] : 1L;
                ++outIdx;
                continue;
            }
            if (indexes[i] instanceof SpecifiedIndex) {
                SpecifiedIndex si = (SpecifiedIndex)indexes[i];
                outShape[outIdx++] = si.length();
                ++inIdx;
                continue;
            }
            throw new IllegalStateException("Unknown index type: " + i);
        }
        if (numSpecified > 0) {
            INDArray out = Nd4j.create(this.dataType(), outShape);
            long[] specifiedSizes = new long[numSpecified];
            SpecifiedIndex[] si = new SpecifiedIndex[numSpecified];
            int j = 0;
            for (int i = 0; i < indexes.length; ++i) {
                if (!(indexes[i] instanceof SpecifiedIndex)) continue;
                specifiedSizes[j] = indexes[i].length();
                si[j] = (SpecifiedIndex)indexes[i];
                ++j;
            }
            NdIndexIterator iter = new NdIndexIterator(specifiedSizes);
            INDArrayIndex[] pointIdxsIn = new INDArrayIndex[indexes.length - numNewAxis];
            int[] specifiedAxisIn = new int[numSpecified];
            int specCount = 0;
            j = 0;
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] instanceof NewAxis) continue;
                if (indexes[i] instanceof SpecifiedIndex) {
                    specifiedAxisIn[specCount++] = j;
                }
                pointIdxsIn[j++] = indexes[i];
            }
            INDArrayIndex[] pointIdxsOut = new INDArrayIndex[indexes.length - numPoint];
            j = 0;
            specCount = 0;
            int[] specifiedAxisOut = new int[numSpecified];
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] instanceof NewAxis) {
                    pointIdxsOut[j++] = NDArrayIndex.point(0L);
                    continue;
                }
                if (indexes[i] instanceof PointIndex) continue;
                if (indexes[i] instanceof SpecifiedIndex) {
                    specifiedAxisOut[specCount++] = j;
                } else if (indexes[i] instanceof IntervalIndex) {
                    pointIdxsOut[j++] = NDArrayIndex.all();
                    continue;
                }
                pointIdxsOut[j++] = indexes[i];
            }
            while (iter.hasNext()) {
                long[] specifiedIdxs = iter.next();
                for (int i = 0; i < specifiedIdxs.length; ++i) {
                    long sourceIdx = si[i].getIndexes()[(int)specifiedIdxs[i]];
                    pointIdxsIn[specifiedAxisIn[i]] = NDArrayIndex.point(sourceIdx);
                    int outI = (int)specifiedIdxs[i];
                    pointIdxsOut[specifiedAxisOut[i]] = NDArrayIndex.point(outI);
                }
                out.get(pointIdxsOut).assign(this.get(pointIdxsIn));
            }
            return out;
        }
        char order = Shape.getOrder(outShape, outStrides, -1L);
        INDArray out = this.create(this.data, outShape, outStrides, offset, order);
        return out;
    }

    @Override
    public INDArray getColumns(int ... cindices) {
        if (!this.isMatrix() && !this.isVector()) {
            throw new IllegalArgumentException("Unable to get columns from a non matrix or vector");
        }
        if (this.isVector()) {
            return Nd4j.pullRows((INDArray)this, 0, cindices, this.ordering());
        }
        INDArray ret = Nd4j.createUninitialized(this.dataType(), this.rows(), cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            ret.putColumn(i, this.getColumn(cindices[i]));
        }
        return ret;
    }

    protected INDArray create(int rows, int length) {
        return this.create(new int[]{rows, length});
    }

    @Override
    public INDArray getRow(long r) {
        if (this.isRowVector() && r == 0L) {
            return this;
        }
        if (this.isRowVector() && r > 0L) {
            throw new IllegalArgumentException("Illegal index for row: requested row " + r + " but this.size(0)=" + this.size(0));
        }
        Preconditions.checkArgument((this.rank() == 2 ? 1 : 0) != 0, (String)"getRow() can be called on 2D arrays only");
        Preconditions.checkArgument((r < (long)this.rows() ? 1 : 0) != 0, (String)"Row index must be smaller than total number of rows");
        return this.tensorAlongDimension(r, 1);
    }

    @Override
    public INDArray getRow(long r, boolean keepDim) {
        INDArray row = this.getRow(r);
        if (!keepDim) {
            return row;
        }
        return row.reshape(1L, row.length());
    }

    @Override
    public boolean equalsWithEps(Object o, double eps) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (o == null) {
            return false;
        }
        if (!(o instanceof INDArray)) {
            return false;
        }
        INDArray n = (INDArray)o;
        Nd4j.getCompressor().autoDecompress(n);
        if (n == this) {
            return true;
        }
        if (n.isSparse()) {
            return n.equals(this);
        }
        if (this.rank() != n.rank()) {
            return false;
        }
        if (this.length() != n.length()) {
            return false;
        }
        if (this.isEmpty() != n.isEmpty()) {
            return false;
        }
        if (this.isEmpty() && n.isEmpty()) {
            return Shape.shapeEquals(this.shape(), n.shape());
        }
        if (this.dataType() != n.dataType()) {
            return false;
        }
        if (this.dataType() == DataType.UTF8 && n.dataType() == DataType.UTF8) {
            for (long e = 0L; e < this.length(); ++e) {
                String str2;
                String str1 = this.getString(e);
                if (str1.equals(str2 = n.getString(e))) continue;
                return false;
            }
            return true;
        }
        if (this.isScalar() && n.isScalar()) {
            if (this.data.dataType() == DataType.FLOAT) {
                double val = this.getDouble(0L);
                double val2 = n.getDouble(0L);
                if (Double.isNaN(val) != Double.isNaN(val2)) {
                    return false;
                }
                return Math.abs(val - val2) < eps;
            }
            double val = this.getDouble(0L);
            double val2 = n.getDouble(0L);
            if (Double.isNaN(val) != Double.isNaN(val2)) {
                return false;
            }
            return Math.abs(val - val2) < eps;
        }
        if (this.isVector() && n.isVector()) {
            EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps, new int[0]);
            Nd4j.getExecutioner().exec(op);
            double diff = op.z().getDouble(0L);
            return diff < 0.5;
        }
        if (!Arrays.equals(this.shape(), n.shape())) {
            return false;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.slices() != n.slices()) {
            return false;
        }
        if (n.ordering() == this.ordering()) {
            EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps, new int[0]);
            Nd4j.getExecutioner().exec(op);
            double diff = op.z().getDouble(0L);
            return diff < 0.5;
        }
        EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps, new int[0]);
        Nd4j.getExecutioner().exec(op);
        double diff = op.z().getDouble(0L);
        return diff < 0.5;
    }

    @Override
    public boolean equalShapes(@NonNull INDArray other) {
        if (other == null) {
            throw new NullPointerException("other is marked @NonNull but is null");
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        if (this.rank() != other.rank()) {
            return false;
        }
        for (int i = 0; i < this.rank(); ++i) {
            if (this.size(i) == other.size(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this.equalsWithEps(o, Nd4j.EPS_THRESHOLD);
    }

    public int hashCode() {
        long longHash = Nd4j.exec(new HashCode(this))[0].getLong(0L);
        return Math.abs(longHash) <= Integer.MAX_VALUE ? (int)longHash : (int)(longHash % Integer.MAX_VALUE);
    }

    @Override
    public DataBuffer shapeInfoDataBuffer() {
        return this.shapeInformation;
    }

    @Override
    public LongBuffer shapeInfo() {
        return this.shapeInformation.asNioLong();
    }

    @Override
    public long[] shape() {
        return this.jvmShapeInfo.shape;
    }

    @Override
    public String shapeInfoToString() {
        return Shape.shapeToString(this);
    }

    @Override
    public long[] stride() {
        return this.jvmShapeInfo.stride;
    }

    @Override
    public long offset() {
        return this.data().offset();
    }

    @Override
    public char ordering() {
        return this.jvmShapeInfo.order;
    }

    @Override
    public long size(int dimension) {
        if (dimension < 0) {
            dimension += this.jvmShapeInfo.rank;
        }
        if (this.isScalar()) {
            if (dimension == 0 || dimension == 1 || dimension < 0) {
                return this.length();
            }
            throw new IllegalArgumentException("Illegal dimension for scalar " + dimension);
        }
        if (dimension >= this.rank()) {
            throw new IllegalArgumentException("Invalid size: cannot get size of dimension " + dimension + " for rank " + this.rank() + " NDArray (array shape: " + Arrays.toString(this.shape()) + ")");
        }
        return this.jvmShapeInfo.shape[dimension];
    }

    @Override
    public int rank() {
        return this.jvmShapeInfo.rank;
    }

    @Override
    public long length() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.jvmShapeInfo.length;
    }

    @Override
    public INDArray broadcast(INDArray result) {
        int i;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long[] shape = result.shape();
        if (Shape.shapeEquals(shape, this.shape())) {
            return this;
        }
        if (this.isScalar()) {
            return Nd4j.createUninitialized(this.dataType(), shape).assign(this.getDouble(0L));
        }
        boolean compatible = true;
        int count = shape.length - 1;
        int thisCount = this.jvmShapeInfo.rank - 1;
        for (int i2 = shape.length - 1; i2 > 0 && count >= 0 && thisCount >= 0; --count, --thisCount, --i2) {
            if (shape[count] == this.shape()[thisCount] || shape[count] == 1L || this.shape()[thisCount] == 1L) continue;
            compatible = false;
            break;
        }
        if (!compatible) {
            throw new IllegalArgumentException("Incompatible broadcast from " + Arrays.toString(this.shape()) + " to " + Arrays.toString(shape));
        }
        long[] retShape = new long[shape.length];
        ArrayList<Integer> broadCastDimensions = new ArrayList<Integer>();
        ArrayList<Integer> nonBroadCastDimensions = new ArrayList<Integer>();
        for (i = 0; i < retShape.length; ++i) {
            if (this.shape().length == 1) {
                if (i == 0) {
                    if (i < this.shape().length) {
                        retShape[i] = Math.max(1L, shape[i]);
                        continue;
                    }
                    retShape[i] = shape[i];
                    continue;
                }
                if (i < this.shape().length) {
                    retShape[i] = Math.max(shape[i], this.size(i));
                    continue;
                }
                retShape[i] = shape[i];
                continue;
            }
            if (i < this.rank() && this.size(i) == 1L) {
                broadCastDimensions.add(i);
            } else {
                nonBroadCastDimensions.add(i);
            }
            retShape[i] = i < this.shape().length ? Math.max(shape[i], this.size(i)) : shape[i];
        }
        if (this.isRowVector()) {
            i = 0;
            while ((long)i < result.slices()) {
                result.putSlice(i, this);
                ++i;
            }
        } else if (this.isColumnVector()) {
            for (i = 0; i < result.columns(); ++i) {
                result.putColumn(i, this);
            }
        } else {
            int[] repeat = new int[shape.length];
            for (int i3 = 0; i3 < shape.length; ++i3) {
                if (i3 < this.rank()) {
                    if (this.size(i3) == 1L) {
                        repeat[i3] = (int)shape[i3];
                        continue;
                    }
                    repeat[i3] = 1;
                    continue;
                }
                repeat[i3] = (int)shape[i3];
            }
            if (this.isView()) {
                Nd4j.getExecutioner().execAndReturn(new Tile(new INDArray[]{this.dup(this.ordering())}, new INDArray[]{result}, repeat));
            } else {
                Nd4j.getExecutioner().execAndReturn(new Tile(new INDArray[]{this}, new INDArray[]{result}, repeat));
            }
        }
        return result;
    }

    @Override
    public INDArray broadcast(long ... shape) {
        return this.broadcast(Nd4j.createUninitialized(this.dataType(), shape, this.ordering()));
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        return this.dimShuffle(rearrange, ArrayUtil.toLongArray((int[])newOrder), broadCastable);
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, long[] newOrder, boolean[] broadCastable) {
        int i;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (broadCastable.length != this.jvmShapeInfo.rank) {
            throw new IllegalArgumentException("The broadcastable dimensions must be the same length as the current shape");
        }
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int dropIdx = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            newShape[count++] = i7 < shuffle.length ? shuffle[i7] : (Integer)drop.get(dropIdx++);
        }
        INDArray ret = newShape.length == this.rank() ? this.permute(newShape) : this.dup();
        ArrayList<Long> newDims = new ArrayList<Long>();
        long[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1L);
        }
        long[] toReshape = ArrayUtil.toArrayLong(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public INDArray permute(int ... rearrange) {
        Preconditions.checkArgument((rearrange.length == this.rank() ? 1 : 0) != 0, (String)"Incorrect number of arguments for permute function: got arguments %s for rank %s array. Number of arguments must equal array rank", (Object)rearrange, (Object)this.rank());
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        boolean alreadyInOrder = true;
        int rank = this.jvmShapeInfo.rank;
        for (int i = 0; i < rank; ++i) {
            if (rearrange[i] == i) continue;
            alreadyInOrder = false;
            break;
        }
        if (alreadyInOrder) {
            return this;
        }
        this.checkArrangeArray(rearrange);
        int[] newShape = this.doPermuteSwap(this.shapeOf(), rearrange);
        int[] newStride = this.doPermuteSwap(this.strideOf(), rearrange);
        char newOrder = Shape.getOrder(newShape, newStride, 1);
        INDArray value = this.create(this.data(), newShape, newStride, this.offset(), newOrder);
        return value;
    }

    @Override
    public INDArray permutei(int ... rearrange) {
        Preconditions.checkArgument((rearrange.length == this.rank() ? 1 : 0) != 0, (String)"Incorrect number of arguments for permute function: got arguments %s for rank %s array. Number of arguments must equal array rank", (Object)rearrange, (Object)this.rank());
        boolean alreadyInOrder = true;
        LongBuffer shapeInfo = this.shapeInfo();
        int rank = this.jvmShapeInfo.rank;
        for (int i = 0; i < rank; ++i) {
            if (rearrange[i] == i) continue;
            alreadyInOrder = false;
            break;
        }
        if (alreadyInOrder) {
            return this;
        }
        this.checkArrangeArray(rearrange);
        long[] newShape = this.doPermuteSwap(Shape.shapeOf(shapeInfo), rearrange);
        long[] newStride = this.doPermuteSwap(Shape.stride(shapeInfo), rearrange);
        char newOrder = Shape.getOrder(newShape, newStride, 1L);
        long ews = shapeInfo.get(2 * rank + 2);
        Pair<DataBuffer, long[]> si = Nd4j.getShapeInfoProvider().createShapeInformation(newShape, newStride, ews, newOrder, this.dataType(), this.isEmpty());
        this.setShapeInformation(si);
        if (shapeInfo.get(2 * rank + 2) > 0L) {
            this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(newShape, newStride, 0L, newOrder, this.dataType(), this.isEmpty()));
        }
        return this;
    }

    protected long[] doPermuteSwap(LongBuffer shape, int[] rearrange) {
        long[] ret = new long[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.get(rearrange[i]);
        }
        return ret;
    }

    protected int[] doPermuteSwap(IntBuffer shape, int[] rearrange) {
        int[] ret = new int[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.get(rearrange[i]);
        }
        return ret;
    }

    protected int[] doPermuteSwap(DataBuffer shape, int[] rearrange) {
        int[] ret = new int[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.getInt((long)rearrange[i]);
        }
        return ret;
    }

    protected void checkArrangeArray(int[] arr) {
        int i;
        Preconditions.checkArgument((arr.length == this.jvmShapeInfo.rank ? 1 : 0) != 0, (String)"Invalid rearrangement: number of arrangement (%s) != rank (%s)", (int)arr.length, (int)this.jvmShapeInfo.rank);
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] >= arr.length) {
                throw new IllegalArgumentException("The specified dimensions can't be swapped. Given element " + i + " was >= number of dimensions");
            }
            if (arr[i] >= 0) continue;
            throw new IllegalArgumentException("Invalid dimension: " + i + " : negative value");
        }
        for (i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (i == j || arr[i] != arr[j]) continue;
                throw new IllegalArgumentException("Permute array must have unique elements");
            }
        }
    }

    protected void autoProcessScalarCall() {
    }

    @Override
    public boolean isVector() {
        if (this.jvmShapeInfo.rank == 1) {
            return true;
        }
        return this.isRowVector() || this.isColumnVector();
    }

    @Override
    public boolean isVectorOrScalar() {
        return this.isVector() || this.isScalar();
    }

    @Override
    public boolean isSquare() {
        return this.isMatrix() && this.rows() == this.columns();
    }

    @Override
    public boolean isRowVector() {
        return this.rank() == 2 && this.rows() == 1 && this.length() > 1L || this.rank() == 1 && this.length() > 1L;
    }

    @Override
    public boolean isColumnVector() {
        return this.rank() == 2 && this.columns() == 1 && this.length() > 1L;
    }

    @Override
    public boolean isColumnVectorOrScalar() {
        return this.isColumnVector() || this.isScalar();
    }

    @Override
    public boolean isRowVectorOrScalar() {
        return this.isRowVector() || this.isScalar();
    }

    public String toString() {
        return this.toString(new NDArrayStrings());
    }

    @Override
    public String toString(@NonNull NDArrayStrings options) {
        if (options == null) {
            throw new NullPointerException("options is marked @NonNull but is null");
        }
        if (!this.isCompressed() && !Nd4j.preventUnpack) {
            return options.format(this);
        }
        if (this.isCompressed() && Nd4j.compressDebug) {
            return "COMPRESSED ARRAY. SYSTEM PROPERTY compressdebug is true. This is to prevent auto decompression from being triggered.";
        }
        if (Nd4j.preventUnpack) {
            return "Array string unpacking is disabled.";
        }
        return options.format(this);
    }

    @Override
    public String toString(long maxElements, boolean forceSummarize, int precision) {
        return this.toString(new NDArrayStrings(maxElements, forceSummarize, precision));
    }

    @Override
    public String toStringFull() {
        return this.toString(Long.MAX_VALUE, false, -1 * this.dataType().precision());
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to retrieve element from non scalar matrix");
        }
        if (this.data.dataType() == DataType.FLOAT) {
            return Float.valueOf(this.data.getFloat(0L));
        }
        return this.data.getDouble(0L);
    }

    @Override
    public INDArray remainder(INDArray denominator) {
        if (Shape.areShapesBroadcastable(this.shape(), denominator.shape())) {
            return this.remainder(denominator, Nd4j.createUninitialized(this.dataType(), Shape.broadcastOutputShape(this.shape(), denominator.shape())));
        }
        return this.remainder(denominator, this.ulike());
    }

    @Override
    public INDArray remainder(INDArray denominator, INDArray result) {
        this.validateNumericalArray("remainder", false);
        Preconditions.checkArgument((boolean)Shape.areShapesBroadcastable(this.shape(), denominator.shape()), (String)"Shapes must be broadcastable");
        RemainderOp op = new RemainderOp(this, denominator, result);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray remainder(Number denominator) {
        return this.remainder(denominator, Nd4j.createUninitialized(this.dataType(), this.shape()));
    }

    @Override
    public INDArray remainder(Number denominator, INDArray result) {
        this.validateNumericalArray("remainder", false);
        ScalarRemainder op = new ScalarRemainder(this, null, result, denominator);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray remainderi(INDArray denominator) {
        this.validateNumericalArray("remainderi", false);
        RemainderOp op = new RemainderOp(this, denominator, this);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray remainderi(Number denominator) {
        this.validateNumericalArray("remainderi", false);
        ScalarRemainder op = new ScalarRemainder(this, null, this, denominator);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray fmod(INDArray denominator) {
        this.validateNumericalArray("fmod", false);
        if (Shape.areShapesBroadcastable(this.shape(), denominator.shape())) {
            return this.fmod(denominator, Nd4j.createUninitialized(Nd4j.defaultFloatingPointType(), Shape.broadcastOutputShape(this.shape(), denominator.shape())));
        }
        return this.fmod(denominator, this.ulike());
    }

    @Override
    public INDArray fmod(INDArray denominator, INDArray result) {
        this.validateNumericalArray("fmod", false);
        if (Shape.areShapesBroadcastable(this.shape(), denominator.shape())) {
            long[] outShape = Shape.broadcastOutputShape(this.shape(), denominator.shape());
            Preconditions.checkArgument((boolean)Shape.shapeEquals(outShape, result.shape()), (String)("Result shape doesn't match expectations: " + Arrays.toString(result.shape())));
            Nd4j.exec(new FloorModOp(new INDArray[]{this, denominator}, new INDArray[]{result}));
            return result;
        }
        FModOp op = new FModOp(this, denominator, result);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray fmod(Number denominator) {
        return this.fmod(denominator, Nd4j.createUninitialized(this.dataType(), this.shape()));
    }

    @Override
    public INDArray fmod(Number denominator, INDArray result) {
        this.validateNumericalArray("fmod", false);
        ScalarFMod op = new ScalarFMod(this, null, result, denominator);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray fmodi(INDArray denominator) {
        this.validateNumericalArray("fmodi", false);
        FModOp op = new FModOp(this, denominator, this);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray fmodi(Number denominator) {
        this.validateNumericalArray("fmodi", false);
        ScalarFMod op = new ScalarFMod(this, null, this, denominator);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    public Iterator<Object> iterator() {
        return new FirstAxisIterator(this);
    }

    @Override
    public long originalOffset() {
        if (this.data().originalOffset() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Original offset of buffer can not be >= Integer.MAX_VALUE");
        }
        return this.data().originalOffset();
    }

    private void readObject(ObjectInputStream s) {
        try {
            s.defaultReadObject();
            this.read(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void write(ObjectOutputStream out) throws IOException {
        if (this.isView()) {
            INDArray copy = this.dup();
            copy.shapeInfoDataBuffer().write((OutputStream)out);
            copy.data().write((OutputStream)out);
        } else {
            this.shapeInformation.write((OutputStream)out);
            this.data().write((OutputStream)out);
        }
    }

    protected void read(ObjectInputStream s) {
        Triple headerShape = BaseDataBuffer.readHeader((InputStream)s);
        this.shapeInformation = Nd4j.createBuffer(new int[Shape.shapeInfoLength(this.rank())]);
        this.shapeInformation.read((InputStream)s, (DataBuffer.AllocationMode)headerShape.getLeft(), ((Long)headerShape.getMiddle()).longValue(), (DataType)headerShape.getRight());
        this.setShapeInformation((Pair<DataBuffer, long[]>)Pair.create((Object)this.shapeInformation, (Object)this.shapeInformation.asLong()));
        Triple headerData = BaseDataBuffer.readHeader((InputStream)s);
        this.data = Nd4j.createBuffer((DataType)headerData.getRight(), (long)((Long)headerData.getMiddle()), false);
        this.data().read((InputStream)s, (DataBuffer.AllocationMode)headerData.getLeft(), ((Long)headerData.getMiddle()).longValue(), (DataType)headerData.getRight());
    }

    @Override
    public INDArray argMax(int ... dimension) {
        return Nd4j.argMax(this, dimension);
    }

    @Override
    public boolean isAttached() {
        if (this.isEmpty()) {
            return false;
        }
        Preconditions.checkArgument((this.data != null || this.isEmpty() ? 1 : 0) != 0, (String)"Array has no buffer!");
        return this.data.isAttached() || this.data.underlyingDataBuffer() != null && this.data.underlyingDataBuffer().isAttached() || this.data.originalDataBuffer() != null && this.data.originalDataBuffer().isAttached();
    }

    @Override
    public boolean isInScope() {
        if (!this.isAttached()) {
            return true;
        }
        return this.data.isInScope();
    }

    @Override
    public INDArray detach() {
        if (!this.isAttached()) {
            return this;
        }
        WorkspaceUtils.assertValidArray(this, "Cannot detach INDArray");
        Nd4j.getExecutioner().commit();
        if (Nd4j.getMemoryManager().getCurrentWorkspace() == null) {
            if (!this.isView()) {
                Nd4j.getExecutioner().commit();
                DataBuffer buffer = Nd4j.createBuffer(this.dataType(), this.length(), false);
                Nd4j.getMemoryManager().memcpy(buffer, this.data());
                return Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
            }
            INDArray copy = Nd4j.createUninitialized(this.dataType(), this.shape(), this.ordering());
            copy.assign(this);
            Nd4j.getExecutioner().commit();
            return copy;
        }
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        Nd4j.getMemoryManager().setCurrentWorkspace(null);
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.dataType(), this.length(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = Nd4j.createUninitialized(this.dataType(), this.shape(), this.ordering());
            copy.assign(this);
            Nd4j.getExecutioner().commit();
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return copy;
    }

    @Override
    public INDArray leverage() {
        WorkspaceUtils.assertValidArray(this, "Cannot leverage INDArray to new workspace");
        if (!this.isAttached()) {
            return this;
        }
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (workspace == null) {
            return this.detach();
        }
        MemoryWorkspace parentWorkspace = workspace.getParentWorkspace();
        if (this.data.getParentWorkspace() == parentWorkspace) {
            return this;
        }
        if (parentWorkspace == null) {
            return this.detach();
        }
        Nd4j.getExecutioner().commit();
        Nd4j.getMemoryManager().setCurrentWorkspace(parentWorkspace);
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.length(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
            Nd4j.getExecutioner().commit();
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return copy;
    }

    @Override
    public INDArray leverageTo(String id) {
        return this.leverageTo(id, false);
    }

    @Override
    public INDArray leverageTo(String id, boolean enforceExistence) throws Nd4jNoSuchWorkspaceException {
        WorkspaceUtils.assertValidArray(this, "Cannot leverage INDArray to new workspace");
        if (!this.isAttached()) {
            return this;
        }
        if (!Nd4j.getWorkspaceManager().checkIfWorkspaceExists(id)) {
            if (enforceExistence) {
                throw new Nd4jNoSuchWorkspaceException(id);
            }
            return this;
        }
        MemoryWorkspace current = Nd4j.getMemoryManager().getCurrentWorkspace();
        MemoryWorkspace target = Nd4j.getWorkspaceManager().getWorkspaceForCurrentThread(id);
        if (this.data.getParentWorkspace() == target) {
            return this;
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(target);
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.dataType(), this.length(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
            Nd4j.getExecutioner().commit();
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(current);
        return copy;
    }

    @Override
    public INDArray leverageOrDetach(String id) {
        if (!this.isAttached()) {
            return this;
        }
        if (!Nd4j.getWorkspaceManager().checkIfWorkspaceExistsAndActive(id)) {
            return this.detach();
        }
        return this.leverageTo(id);
    }

    @Override
    public INDArray migrate() {
        return this.migrate(false);
    }

    @Override
    public INDArray migrate(boolean detachOnNoWs) {
        WorkspaceUtils.assertValidArray(this, "Cannot leverage INDArray to new workspace");
        MemoryWorkspace current = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (current == null) {
            if (detachOnNoWs) {
                return this.detach();
            }
            return this;
        }
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.length(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
            Nd4j.getExecutioner().commit();
        }
        return copy;
    }

    @Override
    public Number percentileNumber(Number quantile) {
        this.validateNumericalArray("percentileNumber", false);
        if (quantile.intValue() < 0 || quantile.intValue() > 100) {
            throw new ND4JIllegalStateException("Percentile value should be in 0...100 range");
        }
        if (this.isScalar()) {
            return this.getDouble(0L);
        }
        INDArray sorted = Nd4j.sort(this.dup(this.ordering()), true);
        return this.getPercentile(quantile, sorted);
    }

    @Override
    public Number medianNumber() {
        this.validateNumericalArray("medianNumber", false);
        if (this.isScalar()) {
            return this.getNumber(0L);
        }
        return this.percentileNumber(50);
    }

    @Override
    public INDArray median(int ... dimension) {
        this.validateNumericalArray("median", false);
        if (dimension.length == 0) {
            return Nd4j.scalar(this.dataType(), this.medianNumber().doubleValue());
        }
        long shapeProd = 1L;
        for (int d : dimension) {
            shapeProd *= this.size(d);
        }
        if (shapeProd == 1L) {
            long[] newShape = ArrayUtil.removeIndex((long[])this.shape(), (int[])dimension);
            return this.dup('c').reshape('c', newShape);
        }
        return this.percentile(50, dimension);
    }

    protected double getPercentile(Number quantile, INDArray sorted) {
        this.validateNumericalArray("getPercentile", false);
        if (quantile.intValue() == 0) {
            return sorted.getDouble(0L);
        }
        if (quantile.intValue() == 100) {
            return sorted.getDouble(sorted.length() - 1L);
        }
        double pos = quantile.doubleValue() / 100.0 * (double)(sorted.length() + 1L);
        double fposition = FastMath.floor((double)pos);
        int position = (int)fposition;
        double diff = pos - fposition;
        double lower = sorted.getDouble((long)(position - 1));
        double upper = sorted.getDouble((long)position);
        return lower + diff * (upper - lower);
    }

    @Override
    public INDArray percentile(Number quantile, int ... dimension) {
        this.validateNumericalArray("percentile", false);
        if (quantile.doubleValue() < 0.0 || quantile.doubleValue() > 100.0) {
            throw new ND4JIllegalStateException("Percentile value should be in 0...100 range");
        }
        if (this.isScalar()) {
            return Nd4j.scalar(this.getDouble(0L));
        }
        INDArray sorted = Nd4j.getNDArrayFactory().sort(this.dup(this.ordering()), false, dimension);
        INDArray ret = Nd4j.createUninitialized(Nd4j.defaultFloatingPointType(), sorted.tensorsAlongDimension(dimension));
        int i = 0;
        while ((long)i < ret.length()) {
            ret.putScalar((long)i, this.getPercentile(quantile, sorted.tensorAlongDimension(i, dimension)));
            ++i;
        }
        return ret;
    }

    protected int stringBuffer(FlatBufferBuilder builder, DataBuffer buffer) {
        Preconditions.checkArgument((buffer.dataType() == DataType.UTF8 ? 1 : 0) != 0, (String)"This method can be called on UTF8 buffers only");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            long numWords = this.length();
            Utf8Buffer ub = (Utf8Buffer)buffer;
            long t = this.length();
            BytePointer ptr = (BytePointer)ub.pointer();
            int i = 0;
            while ((long)i < ub.length()) {
                dos.writeByte(ptr.get((long)i));
                ++i;
            }
            byte[] bytes = bos.toByteArray();
            return FlatArray.createBufferVector(builder, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int toFlatArray(FlatBufferBuilder builder) {
        if (this.isView()) {
            return this.dup(this.ordering()).toFlatArray(builder);
        }
        int shape = FlatArray.createShapeVector(builder, this.shapeInfoDataBuffer().asLong());
        int buffer = this.isEmpty() ? 0 : (this.dataType() == DataType.UTF8 ? this.stringBuffer(builder, this.data()) : FlatArray.createBufferVector(builder, this.data().asBytes()));
        byte type = this.isEmpty() ? FlatBuffersMapper.getDataTypeAsByte(this.dataType()) : FlatBuffersMapper.getDataTypeAsByte(this.data().dataType());
        int array = FlatArray.createFlatArray(builder, shape, buffer, type, (byte)1);
        return array;
    }

    @Override
    public DataBuffer getVectorCoordinates() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public INDArray toDense() {
        return this;
    }

    @Override
    public int nnz() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public SparseFormat getFormat() {
        return SparseFormat.NONE;
    }

    @Override
    public DataBuffer sparseInfoDataBuffer() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int[] flags() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int[] hiddenDimensions() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int[] sparseOffsets() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int underlyingRank() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    protected static DataTypeEx convertType(DataType type) {
        if (type == DataType.HALF) {
            return DataTypeEx.FLOAT16;
        }
        if (type == DataType.FLOAT) {
            return DataTypeEx.FLOAT;
        }
        if (type == DataType.DOUBLE) {
            return DataTypeEx.DOUBLE;
        }
        if (type == DataType.INT) {
            return DataTypeEx.INT8;
        }
        if (type == DataType.LONG) {
            return DataTypeEx.INT16;
        }
        throw new IllegalStateException("Unknown dataType: [" + type + "]");
    }

    @Override
    public boolean isEmpty() {
        return Shape.isEmpty(this.jvmShapeInfo.javaShapeInformation);
    }

    @Override
    public long[] shapeInfoJava() {
        return this.jvmShapeInfo.javaShapeInformation;
    }

    @Override
    public DataType dataType() {
        DataType t;
        if (this.data != null) {
            return this.data.dataType();
        }
        long e = Shape.extras(this.jvmShapeInfo.javaShapeInformation);
        if (e != 0L && (t = ArrayOptionsHelper.dataType(this.jvmShapeInfo.javaShapeInformation)) != DataType.UNKNOWN) {
            return t;
        }
        return DataType.UNKNOWN;
    }

    @Override
    public boolean isR() {
        DataType dtype = this.dataType();
        return dtype == DataType.FLOAT || dtype == DataType.DOUBLE || dtype == DataType.HALF || dtype == DataType.BFLOAT16;
    }

    @Override
    public boolean isZ() {
        return !this.isR() && !this.isB() && !this.isS();
    }

    @Override
    public boolean isB() {
        return this.dataType() == DataType.BOOL;
    }

    @Override
    public boolean isS() {
        return this.dataType() == DataType.UTF8;
    }

    @Override
    public INDArray castTo(DataType dataType) {
        if (dataType == this.dataType()) {
            return this;
        }
        if (this.isEmpty()) {
            return Nd4j.empty(dataType);
        }
        INDArray result = Nd4j.createUninitialized(dataType, this.shape(), this.ordering());
        result.assign(this);
        return result;
    }

    @Override
    public boolean all() {
        INDArray r = Nd4j.getExecutioner().exec(new All(this));
        return r.getDouble(0L) != 0.0;
    }

    @Override
    public boolean any() {
        INDArray r = Nd4j.getExecutioner().exec(new Any(this));
        return r.getDouble(0L) != 0.0;
    }

    @Override
    public boolean none() {
        return !this.any();
    }

    @Override
    public String getString(long index) {
        if (!this.isS()) {
            throw new UnsupportedOperationException("This method is usable only on String dataType, but got [" + this.dataType() + "]");
        }
        return ((Utf8Buffer)this.data).getString(index);
    }

    protected void validateNumericalArray(String opName, boolean allowEmpty) {
        if (this.dataType() == DataType.BOOL || this.dataType() == DataType.UTF8) {
            throw new IllegalStateException("Cannot apply operation " + opName + " to array with " + this.dataType() + " datatype. Array shape: " + Arrays.toString(this.shape()));
        }
        if (!allowEmpty && this.isEmpty()) {
            throw new IllegalStateException("Cannot perform operation " + opName + " on empty array with datatype " + this.dataType());
        }
    }

    @Override
    public boolean closeable() {
        if (this.released || this.isAttached()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (this.isView()) {
            return false;
        }
        return this.data.closeable();
    }

    @Override
    public void close() {
        if (this.released || this.isEmpty()) {
            return;
        }
        Nd4j.getExecutioner().commit();
        if (!this.closeable()) {
            throw new ND4JIllegalStateException("Can't release this INDArray");
        }
        this.data.close();
        this.released = true;
    }

    @Override
    public INDArray like() {
        return Nd4j.create(this.dataType(), this.shape(), Nd4j.getStrides(this.shape(), this.ordering()), this.ordering());
    }

    @Override
    public INDArray ulike() {
        return Nd4j.createUninitialized(this.dataType(), this.shape(), this.ordering());
    }

    @Override
    public boolean wasClosed() {
        return this.released || this.data() != null && this.data().wasClosed();
    }

    static {
        BaseNDArray.tadFinalPermuteDimensions[1] = new int[]{1, 0};
        for (int i = 2; i < 32; ++i) {
            BaseNDArray.tadFinalPermuteDimensions[i] = new int[i];
            int k = i - 1;
            int j = 0;
            while (k >= 0) {
                BaseNDArray.tadFinalPermuteDimensions[i][j] = k--;
                ++j;
            }
        }
        boolean bl = true;
    }
}

