/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.evaluation.curves;

import java.io.IOException;
import org.nd4j.evaluation.BaseEvaluation;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public abstract class BaseCurve {
    public static final int DEFAULT_FORMAT_PREC = 4;

    public abstract int numPoints();

    public abstract double[] getX();

    public abstract double[] getY();

    public abstract String getTitle();

    protected double calculateArea() {
        return this.calculateArea(this.getX(), this.getY());
    }

    protected double calculateArea(double[] x, double[] y) {
        int nPoints = x.length;
        double area = 0.0;
        for (int i = 0; i < nPoints - 1; ++i) {
            double xLeft = x[i];
            double yLeft = y[i];
            double xRight = x[i + 1];
            double yRight = y[i + 1];
            double deltaX = Math.abs(xRight - xLeft);
            double avg = (yRight + yLeft) / 2.0;
            area += deltaX * avg;
        }
        return area;
    }

    protected String format(double d, int precision) {
        return String.format("%." + precision + "f", d);
    }

    public String toJson() {
        try {
            return BaseEvaluation.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return BaseEvaluation.getYamlMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends BaseCurve> T fromJson(String json, Class<T> curveClass) {
        try {
            return (T)((BaseCurve)BaseEvaluation.getObjectMapper().readValue(json, curveClass));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends BaseCurve> T fromYaml(String yaml, Class<T> curveClass) {
        try {
            return (T)((BaseCurve)BaseEvaluation.getYamlMapper().readValue(yaml, curveClass));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

