/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;

public class SDBitwise
extends SDOps {
    public SDBitwise(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable leftShift(@NonNull SDVariable x, @NonNull SDVariable y) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked @NonNull but is null");
        }
        return this.leftShift(null, x, y);
    }

    public SDVariable leftShift(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise left shift", x);
        SDValidation.validateInteger("bitwise left shift", y);
        SDVariable ret = this.f().shift(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable rightShift(SDVariable x, SDVariable y) {
        return this.rightShift(null, x, y);
    }

    public SDVariable rightShift(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise right shift", x);
        SDValidation.validateInteger("bitwise right shift", y);
        SDVariable ret = this.f().rshift(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable leftShiftCyclic(SDVariable x, SDVariable y) {
        return this.leftShiftCyclic(null, x, y);
    }

    public SDVariable leftShiftCyclic(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise left shift (cyclic)", x);
        SDValidation.validateInteger("bitwise left shift (cyclic)", y);
        SDVariable ret = this.f().rotl(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable rightShiftCyclic(SDVariable x, SDVariable y) {
        return this.rightShiftCyclic(null, x, y);
    }

    public SDVariable rightShiftCyclic(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise right shift (cyclic)", x);
        SDValidation.validateInteger("bitwise right shift (cyclic)", y);
        SDVariable ret = this.f().rotr(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable bitsHammingDistance(SDVariable x, SDVariable y) {
        return this.bitsHammingDistance(null, x, y);
    }

    public SDVariable bitsHammingDistance(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise hamming distance", x);
        SDValidation.validateInteger("bitwise hamming distance", y);
        SDVariable ret = this.f().bitwiseHammingDist(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable and(SDVariable x, SDVariable y) {
        return this.and(null, x, y);
    }

    public SDVariable and(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise AND", x);
        SDValidation.validateInteger("bitwise AND", y);
        SDVariable ret = this.f().bitwiseAnd(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable or(SDVariable x, SDVariable y) {
        return this.or(null, x, y);
    }

    public SDVariable or(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise OR", x);
        SDValidation.validateInteger("bitwise OR", y);
        SDVariable ret = this.f().bitwiseOr(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable xor(SDVariable x, SDVariable y) {
        return this.xor(null, x, y);
    }

    public SDVariable xor(String name, SDVariable x, SDVariable y) {
        SDValidation.validateInteger("bitwise XOR", x);
        SDValidation.validateInteger("bitwise XOR", y);
        SDVariable ret = this.f().bitwiseXor(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }
}

