/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners.impl;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.autodiff.listeners.At;
import org.nd4j.autodiff.listeners.BaseEvaluationListener;
import org.nd4j.autodiff.listeners.ListenerEvaluations;
import org.nd4j.autodiff.listeners.ListenerResponse;
import org.nd4j.autodiff.listeners.Operation;
import org.nd4j.autodiff.listeners.records.EvaluationRecord;
import org.nd4j.autodiff.listeners.records.History;
import org.nd4j.autodiff.listeners.records.LossCurve;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.TrainingConfig;

public class HistoryListener
extends BaseEvaluationListener {
    private ListenerEvaluations evaluations;
    private List<EvaluationRecord> trainingHistory = new ArrayList<EvaluationRecord>();
    private List<EvaluationRecord> validationHistory = new ArrayList<EvaluationRecord>();
    private LossCurve loss = null;
    private long startTime;
    private long endTime;
    private List<Long> validationTimes = new ArrayList<Long>();
    private long validationStartTime;

    public HistoryListener(TrainingConfig tc) {
        this.evaluations = new ListenerEvaluations(tc.getTrainEvaluations(), tc.getTrainEvaluationLabels(), tc.getValidationEvaluations(), tc.getValidationEvaluationLabels());
    }

    public HistoryListener(ListenerEvaluations evaluations) {
        this.evaluations = evaluations;
    }

    public HistoryListener newInstance() {
        return new HistoryListener(this.evaluations);
    }

    @Override
    public ListenerEvaluations evaluations() {
        return this.evaluations;
    }

    @Override
    public boolean isActive(Operation operation) {
        return operation.isTrainingPhase();
    }

    @Override
    public ListenerResponse epochEndEvaluations(SameDiff sd, At at, LossCurve lossCurve, long epochTimeMillis, EvaluationRecord evaluations) {
        this.trainingHistory.add(evaluations);
        this.loss = lossCurve;
        return ListenerResponse.CONTINUE;
    }

    @Override
    public ListenerResponse validationDoneEvaluations(SameDiff sd, At at, long validationTimeMillis, EvaluationRecord evaluations) {
        this.validationHistory.add(evaluations);
        return ListenerResponse.CONTINUE;
    }

    @Override
    public void operationStart(SameDiff sd, Operation op) {
        if (op == Operation.TRAINING) {
            this.startTime = System.currentTimeMillis();
        } else if (op == Operation.TRAINING_VALIDATION) {
            this.validationStartTime = System.currentTimeMillis();
        }
    }

    @Override
    public void operationEnd(SameDiff sd, Operation op) {
        if (op == Operation.TRAINING) {
            this.endTime = System.currentTimeMillis();
        } else if (op == Operation.TRAINING_VALIDATION) {
            this.validationTimes.add(System.currentTimeMillis() - this.validationStartTime);
        }
    }

    public History getReport() {
        return new History(this.trainingHistory, this.validationHistory, this.loss, this.endTime - this.startTime, this.validationTimes);
    }

    public ListenerEvaluations getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluations(ListenerEvaluations evaluations) {
        this.evaluations = evaluations;
    }
}

