/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.list;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.conditions.EqualsCondition;

public abstract class BaseNDArrayList<X extends Number>
extends AbstractList<X> {
    protected INDArray container;
    protected int size;

    public BaseNDArrayList() {
        this.container = Nd4j.create(10);
    }

    public BaseNDArrayList(INDArray container) {
        this.container = container;
    }

    public void allocateWithSize(int size) {
        this.container = Nd4j.create(1, size);
        this.size = size;
    }

    public INDArray array() {
        return this.container.get(NDArrayIndex.interval(0, this.size)).reshape(1L, (long)this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<X> iterator() {
        return new NDArrayListIterator();
    }

    @Override
    public Object[] toArray() {
        Object number = this.get(0);
        if (number instanceof Integer) {
            Object[] ret = new Integer[this.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)this.get(i);
            }
            return ret;
        }
        if (number instanceof Double) {
            Object[] ret = new Double[this.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Double)this.get(i);
            }
            return ret;
        }
        if (number instanceof Float) {
            Object[] ret = new Float[this.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Float)this.get(i);
            }
            return ret;
        }
        throw new UnsupportedOperationException("Unable to convert to array");
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        Object number = this.get(0);
        if (number instanceof Integer) {
            Integer[] ret = (Integer[])ts;
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)this.get(i);
            }
            return ret;
        }
        if (number instanceof Double) {
            Double[] ret = new Double[this.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Double)this.get(i);
            }
            return ret;
        }
        if (number instanceof Float) {
            Float[] ret = new Float[this.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Float)this.get(i);
            }
            return ret;
        }
        throw new UnsupportedOperationException("Unable to convert to array");
    }

    @Override
    public boolean add(X aX) {
        if (this.container == null) {
            this.container = Nd4j.create(10);
        } else if ((long)this.size == this.container.length()) {
            this.growCapacity(this.size * 2);
        }
        if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.DOUBLE) {
            this.container.putScalar((long)this.size, ((Number)aX).doubleValue());
        } else {
            this.container.putScalar((long)this.size, ((Number)aX).floatValue());
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int idx = BooleanIndexing.firstIndex(this.container, new EqualsCondition((double)((Double)o))).getInt(0);
        if (idx < 0) {
            return false;
        }
        this.container.put(new INDArrayIndex[]{NDArrayIndex.interval((long)idx, this.container.length())}, this.container.get(NDArrayIndex.interval((long)(idx + 1), this.container.length())));
        this.container = this.container.reshape(1L, (long)this.size);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object d : collection) {
            if (this.contains(d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends X> collection) {
        if (collection instanceof BaseNDArrayList) {
            BaseNDArrayList ndArrayList = (BaseNDArrayList)collection;
            ndArrayList.growCapacity(this.size() + collection.size());
        } else {
            for (Number d : collection) {
                this.add((X)d);
            }
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection<? extends X> collection) {
        for (Number d : collection) {
            this.add(i, (X)d);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        for (Object d : collection) {
            this.remove(d);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.container = null;
    }

    @Override
    public X get(int i) {
        Double ret = this.container.getDouble((long)i);
        return (X)ret;
    }

    @Override
    public X set(int i, X aX) {
        if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.DOUBLE) {
            this.container.putScalar((long)i, ((Number)aX).doubleValue());
        } else {
            this.container.putScalar((long)i, ((Number)aX).floatValue());
        }
        return aX;
    }

    @Override
    public void add(int i, X aX) {
        this.rangeCheck(i);
        this.growCapacity(i);
        this.moveForward(i);
        if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.DOUBLE) {
            this.container.putScalar((long)i, ((Number)aX).doubleValue());
        } else {
            this.container.putScalar((long)i, ((Number)aX).floatValue());
        }
        ++this.size;
    }

    @Override
    public X remove(int i) {
        this.rangeCheck(i);
        int numMoved = this.size - i - 1;
        if (numMoved > 0) {
            Double move = this.container.getDouble((long)i);
            this.moveBackward(i);
            --this.size;
            return (X)move;
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        return BooleanIndexing.firstIndex(this.container, new EqualsCondition((double)((Double)o))).getInt(0);
    }

    @Override
    public int lastIndexOf(Object o) {
        return BooleanIndexing.lastIndex(this.container, new EqualsCondition((double)((Double)o))).getInt(0);
    }

    @Override
    public ListIterator<X> listIterator() {
        return new NDArrayListIterator();
    }

    @Override
    public ListIterator<X> listIterator(int i) {
        return new NDArrayListIterator(i);
    }

    @Override
    public String toString() {
        return this.container.get(NDArrayIndex.interval(0, this.size)).toString();
    }

    private void growCapacity(int idx) {
        if (this.container == null) {
            this.container = Nd4j.create(10);
        } else if ((long)idx >= this.container.length()) {
            long max = Math.max(this.container.length() * 2L, (long)idx);
            INDArray newContainer = Nd4j.create(max);
            newContainer.put(new INDArrayIndex[]{NDArrayIndex.interval(0L, this.container.length())}, this.container);
            this.container = newContainer;
        }
    }

    private void rangeCheck(int idx) {
        if (idx < 0 || idx > this.size) {
            throw new IllegalArgumentException("Illegal index " + idx);
        }
    }

    private void moveBackward(int index) {
        int numMoved = this.size - index - 1;
        INDArrayIndex[] first = new INDArrayIndex[]{NDArrayIndex.point(0L), NDArrayIndex.interval(index, index + numMoved)};
        INDArrayIndex[] getRange = new INDArrayIndex[]{NDArrayIndex.point(0L), NDArrayIndex.interval(index + 1, index + 1 + numMoved)};
        INDArray get = this.container.get(getRange);
        this.container.put(first, get);
    }

    private void moveForward(int index) {
        int numMoved = this.size - index - 1;
        INDArrayIndex[] getRange = new INDArrayIndex[]{NDArrayIndex.point(0L), NDArrayIndex.interval(index, index + numMoved)};
        INDArray get = this.container.get(getRange);
        INDArrayIndex[] first = new INDArrayIndex[]{NDArrayIndex.point(0L), NDArrayIndex.interval((long)(index + 1), (long)(index + 1) + get.length())};
        this.container.put(first, get);
    }

    private class NDArrayListIterator
    implements ListIterator<X> {
        private int curr = 0;

        public NDArrayListIterator(int curr) {
            this.curr = curr;
        }

        public NDArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.curr < BaseNDArrayList.this.size;
        }

        @Override
        public X next() {
            Object ret = BaseNDArrayList.this.get(this.curr);
            ++this.curr;
            return ret;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public X previous() {
            Object ret = BaseNDArrayList.this.get(this.curr - 1);
            --this.curr;
            return ret;
        }

        @Override
        public int nextIndex() {
            return this.curr + 1;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(X aX) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(X aX) {
            throw new UnsupportedOperationException();
        }
    }
}

