/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.primitives.Longs;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;

public class IntervalIndex
implements INDArrayIndex {
    protected long begin;
    protected long end;
    protected boolean inclusive;
    protected long stride = 1L;
    protected long index = 0L;
    protected long length = 0L;

    public IntervalIndex(boolean inclusive, long stride) {
        this.inclusive = inclusive;
        this.stride = stride;
        this.length = (long)((int)Math.abs(this.end - this.begin)) / stride;
    }

    @Override
    public long end() {
        return this.end;
    }

    @Override
    public long offset() {
        return this.begin;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long stride() {
        return this.stride;
    }

    @Override
    public long current() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.end();
    }

    @Override
    public long next() {
        long ret = this.index;
        this.index += this.stride;
        return ret;
    }

    @Override
    public void reverse() {
        long oldBegin;
        long oldEnd = this.end;
        this.end = oldBegin = this.begin;
        this.begin = oldEnd;
    }

    @Override
    public boolean isInterval() {
        return true;
    }

    @Override
    public void setInterval(boolean isInterval) {
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
        if (begin < 0L) {
            begin += arr.size(dimension);
        }
        this.begin = begin;
        this.index = begin;
        this.end = this.inclusive ? arr.size(dimension) + 1L : arr.size(dimension);
        for (long i = begin; i < this.end; i += this.stride) {
            ++this.length;
        }
    }

    @Override
    public void init(INDArray arr, int dimension) {
        this.init(arr, 0L, dimension);
    }

    @Override
    public void init(long begin, long end, long max) {
        if (begin < 0L) {
            begin += max;
        }
        if (end < 0L) {
            end += max;
        }
        this.begin = begin;
        this.index = begin;
        this.end = this.inclusive ? end + 1L : end;
        for (long i = begin; i < this.end; i += this.stride) {
            ++this.length;
        }
    }

    @Override
    public void init(long begin, long end) {
        if (begin < 0L || end < 0L) {
            throw new IllegalArgumentException("Please pass in an array for negative indices. Unable to determine size for dimension otherwise");
        }
        this.begin = begin;
        this.index = begin;
        this.end = this.inclusive ? end + 1L : end;
        for (long i = begin; i < this.end; i += this.stride) {
            ++this.length;
        }
    }

    @Override
    public void reset() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntervalIndex)) {
            return false;
        }
        IntervalIndex that = (IntervalIndex)o;
        if (this.begin != that.begin) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (this.inclusive != that.inclusive) {
            return false;
        }
        if (this.stride != that.stride) {
            return false;
        }
        return this.index == that.index;
    }

    public int hashCode() {
        int result = Longs.hashCode((long)this.begin);
        result = 31 * result + Longs.hashCode((long)this.end);
        result = 31 * result + (this.inclusive ? 1 : 0);
        result = 31 * result + Longs.hashCode((long)this.stride);
        result = 31 * result + Longs.hashCode((long)this.index);
        return result;
    }
}

