/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.factory.Nd4j;

public class Linspace
extends BaseRandomOp {
    private double from;
    private double to;
    private long length;

    public Linspace() {
    }

    public Linspace(double from, double to, int length) {
        this(Nd4j.createUninitialized(new int[]{1, length}, Nd4j.order().charValue()), from, to);
    }

    public Linspace(@NonNull INDArray z, double from, double to) {
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        this.from = from;
        this.to = to;
        this.length = z.length();
        this.init(null, null, z, z.lengthLong());
        this.extraArgs = new Object[]{from, to};
    }

    public Linspace(SameDiff sd, double from, double to, long length) {
        super(sd, new long[]{length});
        this.sameDiff = sd;
        this.from = from;
        this.to = to;
        this.length = length;
        this.extraArgs = new Object[]{from, to};
    }

    @Override
    public int opNum() {
        return 4;
    }

    @Override
    public String opName() {
        return "linspace";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<long[]> calculateOutputShape() {
        return Collections.singletonList(new long[]{this.length});
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }
}

