/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class SequenceMask
extends DynamicCustomOp {
    private int maxLen;
    private boolean is_static_maxlen = false;

    public SequenceMask(SameDiff sameDiff, SDVariable input, SDVariable maxLen) {
        super(null, sameDiff, new SDVariable[]{input, maxLen}, false);
    }

    public SequenceMask(SameDiff sameDiff, SDVariable input, int maxLen) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        this.maxLen = maxLen;
        this.is_static_maxlen = true;
        this.addIArgument(maxLen);
    }

    public SequenceMask(SameDiff sameDiff, SDVariable input) {
        super(null, sameDiff, new SDVariable[]{input}, false);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        NodeDef targetNode = TFGraphMapper.getInstance().getNodeWithNameFromGraph(graph, nodeDef.getInput(1));
        INDArray maxlen = TFGraphMapper.getInstance().getNDArrayFromTensor("value", targetNode, graph);
        if (maxlen == null) {
            this.is_static_maxlen = true;
        }
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        if (this.is_static_maxlen) {
            this.addIArgument(this.maxLen);
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> attrs = new LinkedHashMap<String, PropertyMapping>();
        if (this.is_static_maxlen) {
            PropertyMapping maxLen = PropertyMapping.builder().propertyNames(new String[]{"maxLen"}).tfAttrName("maxlen").build();
            attrs.put("maxLen", maxLen);
        }
        ret.put(this.tensorflowName(), attrs);
        return ret;
    }

    @Override
    public String opName() {
        return "sequence_mask";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "SequenceMask";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return Collections.singletonList(this.f().zerosLike(this.arg()));
    }

    public SequenceMask() {
    }
}

