/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Pooling3D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Pooling3D.class);
    protected Pooling3DConfig config;

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    public Pooling3D() {
    }

    public Pooling3D(SameDiff sameDiff, SDVariable[] inputs, INDArray[] inputArrays, INDArray[] outputs, boolean inPlace, Pooling3DConfig pooling3DConfig, Pooling3DType type) {
        super(null, sameDiff, inputs, inPlace);
        Preconditions.checkState((pooling3DConfig.getDD() > 0L && pooling3DConfig.getDH() > 0L && pooling3DConfig.getDW() > 0L ? 1 : 0) != 0, (String)"Dilation values must all be > 0: got dD/H/W = %s/%s/%s", (long)pooling3DConfig.getDD(), (long)pooling3DConfig.getDH(), (long)pooling3DConfig.getDW());
        if (type != null) {
            pooling3DConfig.setType(type);
        }
        this.config = pooling3DConfig;
        this.sameDiff = sameDiff;
        if (inputArrays != null) {
            this.addInputArgument(inputArrays);
        }
        if (outputs != null) {
            this.addOutputArgument(outputs);
        }
        this.addArgs();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    protected void addArgs() {
        if (this.iArguments == null) {
            this.iArguments = new ArrayList();
        }
        this.addIArgument(this.config.getKD());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getSD());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getPD());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getDD());
        this.addIArgument(this.config.getDW());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.isSameMode() ? 1 : 0);
        this.addIArgument(0);
        this.addIArgument(this.config.isNCDHW() ? 0 : 1);
    }

    @Override
    public String opName() {
        return this.getPoolingPrefix() + "pool3dnew";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Pooling3DDerivative pooling3DDerivative = Pooling3DDerivative.derivativeBuilder().inPlace(this.inPlace).sameDiff(this.sameDiff).inputs(inputs.toArray(new SDVariable[inputs.size()])).pooling3DConfig(this.config).build();
        ret.addAll(Arrays.asList(pooling3DDerivative.outputVariables()));
        return ret;
    }

    public String getPoolingPrefix() {
        if (this.config == null) {
            return "pooling3d";
        }
        switch (this.config.getType()) {
            case AVG: {
                return "avg";
            }
            case MAX: {
                return "max";
            }
        }
        throw new IllegalStateException("No pooling type found.");
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        Pooling3DConfig conf;
        Pooling3DType type;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        AttrValue aKernels = nodeDef.getAttrOrThrow("ksize");
        List<Long> tfKernels = aKernels.getList().getIList();
        AttrValue aPadding = nodeDef.getAttrOrThrow("padding");
        List<Long> tfPadding = aPadding.getList().getIList();
        String paddingMode = aPadding.getS().toStringUtf8().replaceAll("\"", "");
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        String data_format = "ndhwc";
        if (nodeDef.containsAttr("data_format")) {
            AttrValue attr = nodeDef.getAttrOrThrow("data_format");
            data_format = attr.getS().toStringUtf8().toLowerCase();
        }
        int[] strides = new int[3];
        int[] padding = new int[3];
        int[] kernel = new int[3];
        for (int i = 0; i < 3; ++i) {
            strides[i] = tfStrides.get(i + 1).intValue();
            if (tfPadding != null && tfPadding.size() > 0) {
                padding[i] = tfPadding.get(i + 1).intValue();
            }
            kernel[i] = tfKernels.get(i + 1).intValue();
        }
        String name = nodeDef.getOp().toLowerCase();
        if (name.startsWith("max")) {
            type = Pooling3DType.MAX;
        } else if (name.startsWith("av")) {
            type = Pooling3DType.AVG;
        } else {
            throw new IllegalStateException("Unknown or not supported pooling type: " + name);
        }
        this.config = conf = Pooling3DConfig.builder().sD(strides[0]).sH(strides[1]).sW(strides[2]).pD(padding[0]).pH(padding[1]).pW(padding[2]).kD(kernel[0]).kH(kernel[1]).kW(kernel[2]).type(type).isSameMode(isSameMode).isNCDHW(data_format.equalsIgnoreCase("ncdhw")).build();
        this.addArgs();
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for op " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No op opName found for op " + this.opName());
    }

    public static Pooling3DBuilder builder() {
        return new Pooling3DBuilder();
    }

    public static class Pooling3DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private boolean inPlace;
        private Pooling3DConfig pooling3DConfig;
        private Pooling3DType type;

        Pooling3DBuilder() {
        }

        public Pooling3DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Pooling3DBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Pooling3DBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Pooling3DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Pooling3DBuilder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        public Pooling3DBuilder pooling3DConfig(Pooling3DConfig pooling3DConfig) {
            this.pooling3DConfig = pooling3DConfig;
            return this;
        }

        public Pooling3DBuilder type(Pooling3DType type) {
            this.type = type;
            return this;
        }

        public Pooling3D build() {
            return new Pooling3D(this.sameDiff, this.inputs, this.inputArrays, this.outputs, this.inPlace, this.pooling3DConfig, this.type);
        }

        public String toString() {
            return "Pooling3D.Pooling3DBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", inPlace=" + this.inPlace + ", pooling3DConfig=" + this.pooling3DConfig + ", type=" + (Object)((Object)this.type) + ")";
        }
    }

    public static enum Pooling3DType {
        MAX,
        AVG,
        PNORM;

    }
}

