/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.factory.Nd4j;

public class JaccardDistance
extends BaseAccumulation {
    public JaccardDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int ... dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public JaccardDistance() {
        this.passThrough = false;
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public JaccardDistance(INDArray x, INDArray y, long n) {
        super(x, y, n);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public JaccardDistance(INDArray x) {
        super(x);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public JaccardDistance(INDArray x, INDArray y) {
        super(x, y);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, boolean allDistances) {
        this(x, y, z, x.lengthLong());
        this.isComplex = allDistances;
    }

    public JaccardDistance(INDArray x, INDArray y, boolean allDistances) {
        this(x, y);
        this.isComplex = allDistances;
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, boolean newFormat, boolean keepDims, int ... dimensions) {
        super(x, y, z, newFormat, keepDims, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE3;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public String opName() {
        return "jaccarddistance";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable bcGradOut;
        SDVariable min = this.f().min(this.larg(), this.rarg());
        SDVariable max = this.f().max(this.larg(), this.rarg());
        SDVariable sumMax = max.sum(true, this.dimensions);
        SDVariable sumMin = min.sum(true, this.dimensions);
        SDVariable xIsMin = this.f().eq(min, this.larg());
        SDVariable xIsMax = this.f().eq(max, this.larg());
        SDVariable yIsMin = this.f().eq(min, this.rarg());
        SDVariable yIsMax = this.f().eq(max, this.rarg());
        SDVariable sqSumMax = this.f().square(sumMax);
        SDVariable dldx = xIsMax.mul(sumMin).sub(xIsMin.mul(sumMax)).div(sqSumMax);
        SDVariable dldy = yIsMax.mul(sumMin).sub(yIsMin.mul(sumMax)).div(sqSumMax);
        if (this.dimensions == null) {
            bcGradOut = f1.get(0);
        } else {
            int inRank = this.arg().getArr().rank();
            bcGradOut = this.f().reductionBroadcastableWithOrigShape(inRank, this.dimensions, f1.get(0));
        }
        return Arrays.asList(dldx.mul(bcGradOut), dldy.mul(bcGradOut));
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }
}

