/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScalarOp
extends BaseOp
implements ScalarOp {
    private static final Logger log = LoggerFactory.getLogger(BaseScalarOp.class);

    public BaseScalarOp() {
    }

    public BaseScalarOp(INDArray x, INDArray y, INDArray z, long n, Number num) {
        super(x, y, z, n);
        this.scalarValue = num;
        this.init(x, y, z, n);
    }

    public BaseScalarOp(INDArray x, Number num) {
        super(x);
        this.scalarValue = num;
        this.init(x, this.y, this.z, this.n);
    }

    public BaseScalarOp(SameDiff sameDiff, SDVariable i_v, Number scalar) {
        this(sameDiff, i_v, scalar, false, null);
    }

    public BaseScalarOp(SameDiff sameDiff, SDVariable i_v, Number scalar, boolean inPlace) {
        this(sameDiff, i_v, scalar, inPlace, null);
    }

    public BaseScalarOp(SameDiff sameDiff, SDVariable i_v, Number scalar, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        this.scalarValue = scalar;
        if (i_v != null) {
            this.xVertexId = i_v.getVarName();
            sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v);
    }

    public BaseScalarOp(SameDiff sameDiff, SDVariable i_v, Number scalar, Object[] extraArgs) {
        this(sameDiff, i_v, scalar, false, extraArgs);
    }

    @Override
    public INDArray z() {
        if (this.z == null && this.sameDiff != null) {
            this.z = this.outputVariables()[0].getArr();
            if (this.z == null) {
                SDVariable var = this.outputVariables()[0];
                if (var.getShape() != null) {
                    this.z = var.storeAndAllocateNewArray();
                } else {
                    long[] argsShape = this.args()[0].getShape();
                    if (argsShape != null) {
                        this.sameDiff.putShapeForVarName(var.getVarName(), argsShape);
                        this.z = var.storeAndAllocateNewArray();
                    }
                }
            }
        }
        return this.z;
    }

    @Override
    public List<long[]> calculateOutputShape() {
        ArrayList<long[]> ret = new ArrayList<long[]>(1);
        ret.add(this.arg().getShape());
        return ret;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.SCALAR;
    }

    @Override
    public void setScalar(Number scalar) {
        this.scalarValue = scalar;
    }

    @Override
    public Number scalar() {
        if (this.scalarValue == null && this.y() != null && this.y().isScalar()) {
            return this.y().getDouble(0L);
        }
        return this.scalarValue;
    }

    @Override
    public int[] getDimension() {
        return this.dimensions;
    }

    @Override
    public void setDimension(int ... dimension) {
        this.dimensions = dimension;
    }
}

