/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.blas.Level2;
import org.nd4j.linalg.api.blas.impl.SparseBaseLevel;
import org.nd4j.linalg.api.blas.params.SparseCOOGemvParameters;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;

public abstract class SparseBaseLevel2
extends SparseBaseLevel
implements Level2 {
    @Override
    public void gemv(char order, char transA, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        Preconditions.checkArgument((boolean)A.isMatrix(), (String)"A must be a matrix");
        Preconditions.checkArgument((boolean)X.isVector(), (String)"X must be a vector");
        Preconditions.checkArgument((boolean)Y.isVector(), (String)"Y must be a vector");
        SparseCOOGemvParameters parameters = new SparseCOOGemvParameters(A, X, Y);
        switch (A.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, parameters.getA(), parameters.getX(), parameters.getY());
                this.dcoomv(parameters.getAOrdering(), parameters.getM(), parameters.getVal(), parameters.getRowInd(), parameters.getColInd(), parameters.getNnz(), parameters.getX(), parameters.getY());
                break;
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, parameters.getA(), parameters.getX(), parameters.getY());
                this.scoomv(parameters.getAOrdering(), parameters.getM(), parameters.getVal(), parameters.getRowInd(), parameters.getColInd(), parameters.getNnz(), parameters.getX(), parameters.getY());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void gbmv(char order, char TransA, int KL, int KU, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
    }

    @Override
    public void ger(char order, double alpha, INDArray X, INDArray Y, INDArray A) {
    }

    @Override
    public void sbmv(char order, char Uplo, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
    }

    @Override
    public void spmv(char order, char Uplo, double alpha, INDArray Ap, INDArray X, double beta, INDArray Y) {
    }

    @Override
    public void spr(char order, char Uplo, double alpha, INDArray X, INDArray Ap) {
    }

    @Override
    public void spr2(char order, char Uplo, double alpha, INDArray X, INDArray Y, INDArray A) {
    }

    @Override
    public void symv(char order, char Uplo, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
    }

    @Override
    public void syr(char order, char Uplo, int N, double alpha, INDArray X, INDArray A) {
    }

    @Override
    public void syr2(char order, char Uplo, double alpha, INDArray X, INDArray Y, INDArray A) {
    }

    @Override
    public void tbmv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
    }

    @Override
    public void tbsv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
    }

    @Override
    public void tpmv(char order, char Uplo, char TransA, char Diag2, INDArray Ap, INDArray X) {
    }

    @Override
    public void tpsv(char order, char Uplo, char TransA, char Diag2, INDArray Ap, INDArray X) {
    }

    @Override
    public void trmv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
    }

    @Override
    public void trsv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
    }

    protected abstract void scoomv(char var1, int var2, DataBuffer var3, DataBuffer var4, DataBuffer var5, int var6, INDArray var7, INDArray var8);

    protected abstract void dcoomv(char var1, int var2, DataBuffer var3, DataBuffer var4, DataBuffer var5, int var6, INDArray var7, INDArray var8);
}

