/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor.classimbalance;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.preprocessor.classimbalance.BaseUnderSamplingPreProcessor;

public class UnderSamplingByMaskingMultiDataSetPreProcessor
extends BaseUnderSamplingPreProcessor
implements MultiDataSetPreProcessor {
    private Map<Integer, Double> targetMinorityDistMap;
    private Map<Integer, Integer> minorityLabelMap = new HashMap<Integer, Integer>();

    public UnderSamplingByMaskingMultiDataSetPreProcessor(Map<Integer, Double> targetDist, int windowSize) {
        for (Integer index : targetDist.keySet()) {
            if (targetDist.get(index) > 0.5 || targetDist.get(index) <= 0.0) {
                throw new IllegalArgumentException("Target distribution for the minority label class has to be greater than 0 and no greater than 0.5. Target distribution of " + targetDist.get(index) + "given for label at index " + index);
            }
            this.minorityLabelMap.put(index, 1);
        }
        this.targetMinorityDistMap = targetDist;
        this.tbpttWindowSize = windowSize;
    }

    public void overrideMinorityDefault(int index) {
        if (!this.targetMinorityDistMap.containsKey(index)) {
            throw new IllegalArgumentException("Index specified is not contained in the target minority distribution map specified with the preprocessor. Map contains " + ArrayUtils.toString((Object)this.targetMinorityDistMap.keySet().toArray()));
        }
        this.minorityLabelMap.put(index, 0);
    }

    @Override
    public void preProcess(MultiDataSet multiDataSet) {
        for (Integer index : this.targetMinorityDistMap.keySet()) {
            INDArray label = multiDataSet.getLabels(index);
            INDArray labelMask = multiDataSet.getLabelsMaskArray(index);
            double targetMinorityDist = this.targetMinorityDistMap.get(index);
            int minorityLabel = this.minorityLabelMap.get(index);
            multiDataSet.setLabelsMaskArray(index, this.adjustMasks(label, labelMask, minorityLabel, targetMinorityDist));
        }
    }
}

