/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.checkutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;

public class NDArrayCreationUtil {
    private NDArrayCreationUtil() {
    }

    public static List<Pair<INDArray, String>> getAllTestMatricesWithShape(char ordering, int rows, int cols, int seed) {
        ArrayList<Pair<INDArray, String>> all = new ArrayList<Pair<INDArray, String>>();
        Nd4j.getRandom().setSeed(seed);
        all.add(new Pair((Object)Nd4j.linspace(1, rows * cols, rows * cols).reshape(ordering, rows, cols), (Object)"Nd4j..linspace(1,rows * cols,rows * cols).reshape(rows,cols)"));
        all.add(NDArrayCreationUtil.getTransposedMatrixWithShape(ordering, rows, cols, seed));
        all.addAll(NDArrayCreationUtil.getSubMatricesWithShape(ordering, rows, cols, seed));
        all.addAll(NDArrayCreationUtil.getTensorAlongDimensionMatricesWithShape(ordering, rows, cols, seed));
        all.add(NDArrayCreationUtil.getPermutedWithShape(ordering, rows, cols, seed));
        all.add(NDArrayCreationUtil.getReshapedWithShape(ordering, rows, cols, seed));
        return all;
    }

    public static List<Pair<INDArray, String>> getAllTestMatricesWithShape(int rows, int cols, int seed) {
        ArrayList<Pair<INDArray, String>> all = new ArrayList<Pair<INDArray, String>>();
        Nd4j.getRandom().setSeed(seed);
        all.add(new Pair((Object)Nd4j.linspace(1, rows * cols, rows * cols).reshape(rows, cols), (Object)"Nd4j..linspace(1,rows * cols,rows * cols).reshape(rows,cols)"));
        all.add(NDArrayCreationUtil.getTransposedMatrixWithShape(rows, cols, seed));
        all.addAll(NDArrayCreationUtil.getSubMatricesWithShape(rows, cols, seed));
        all.addAll(NDArrayCreationUtil.getTensorAlongDimensionMatricesWithShape(rows, cols, seed));
        all.add(NDArrayCreationUtil.getPermutedWithShape(rows, cols, seed));
        all.add(NDArrayCreationUtil.getReshapedWithShape(rows, cols, seed));
        return all;
    }

    public static List<Pair<INDArray, String>> getTestMatricesWithVaryingShapes(int rank, char order) {
        ArrayList<Pair<INDArray, String>> all = new ArrayList<Pair<INDArray, String>>();
        if (rank == 0) {
            all.add(new Pair((Object)Nd4j.trueScalar(Nd4j.rand(1, 1).getDouble(0)), (Object)"{}"));
            return all;
        }
        int maxCount = (int)Math.pow(2.0, rank);
        int[] defaultOnes = new int[rank];
        Arrays.fill(defaultOnes, 1);
        for (int i = 0; i < maxCount; ++i) {
            int[] iShape = ArrayUtils.clone((int[])defaultOnes);
            int b = 0;
            for (int num = i; num > 0; num /= 2) {
                iShape[b] = num % 2 + 1;
                ++b;
            }
            all.add((Pair<INDArray, String>)new Pair((Object)Nd4j.rand(order, iShape), (Object)ArrayUtils.toString((Object)iShape)));
        }
        int[] aRandomShape = new int[rank];
        Random ran = new Random();
        for (int i = 0; i < rank; ++i) {
            aRandomShape[i] = 2 + ran.nextInt(6);
        }
        all.add((Pair<INDArray, String>)new Pair((Object)Nd4j.rand(order, aRandomShape), (Object)ArrayUtils.toString((Object)aRandomShape)));
        return all;
    }

    public static Pair<INDArray, String> getTransposedMatrixWithShape(char ordering, int rows, int cols, int seed) {
        Nd4j.getRandom().setSeed(seed);
        INDArray out = Nd4j.linspace(1, rows * cols, rows * cols).reshape(ordering, cols, rows);
        return new Pair((Object)out.transpose(), (Object)("getTransposedMatrixWithShape(" + rows + "," + cols + "," + seed + ")"));
    }

    public static Pair<INDArray, String> getTransposedMatrixWithShape(int rows, int cols, int seed) {
        Nd4j.getRandom().setSeed(seed);
        INDArray out = Nd4j.linspace(1, rows * cols, rows * cols).reshape(cols, rows);
        return new Pair((Object)out.transpose(), (Object)("getTransposedMatrixWithShape(" + rows + "," + cols + "," + seed + ")"));
    }

    public static List<Pair<INDArray, String>> getSubMatricesWithShape(int rows, int cols, int seed) {
        return NDArrayCreationUtil.getSubMatricesWithShape(Nd4j.order().charValue(), rows, cols, seed);
    }

    public static List<Pair<INDArray, String>> getSubMatricesWithShape(char ordering, int rows, int cols, int seed) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape = new int[]{2 * rows + 4, 2 * cols + 4};
        int len = ArrayUtil.prod((int[])shape);
        INDArray orig = Nd4j.linspace(1, len, len).reshape(ordering, shape);
        INDArray first = orig.get(NDArrayIndex.interval(0, rows), NDArrayIndex.interval(0, cols));
        Nd4j.getRandom().setSeed(seed);
        orig = Nd4j.linspace(1, len, len).reshape(shape);
        INDArray second = orig.get(NDArrayIndex.interval(3, rows + 3), NDArrayIndex.interval(3, cols + 3));
        Nd4j.getRandom().setSeed(seed);
        orig = Nd4j.linspace(1, len, len).reshape(ordering, shape);
        INDArray third = orig.get(NDArrayIndex.interval(rows, 2 * rows), NDArrayIndex.interval(cols, 2 * cols));
        String baseMsg = "getSubMatricesWithShape(" + rows + "," + cols + "," + seed + ")";
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>(3);
        list.add(new Pair((Object)first, (Object)(baseMsg + ".get(0)")));
        list.add(new Pair((Object)second, (Object)(baseMsg + ".get(1)")));
        list.add(new Pair((Object)third, (Object)(baseMsg + ".get(2)")));
        return list;
    }

    public static List<Pair<INDArray, String>> getTensorAlongDimensionMatricesWithShape(char ordering, int rows, int cols, int seed) {
        Nd4j.getRandom().setSeed(seed);
        INDArray[] out = new INDArray[12];
        INDArray temp01 = Nd4j.linspace(1, cols * rows * 4, cols * rows * 4).reshape(cols, rows, 4);
        out[0] = temp01.javaTensorAlongDimension(0, 0, 1).reshape(rows, cols);
        int[] temp01Shape = new int[]{cols, rows, 4};
        int len = ArrayUtil.prod((int[])temp01Shape);
        temp01 = Nd4j.linspace(1, len, len).reshape(temp01Shape);
        out[1] = temp01.javaTensorAlongDimension(2, 0, 1).reshape(rows, cols);
        Nd4j.getRandom().setSeed(seed);
        INDArray temp02 = Nd4j.linspace(1, len, len).reshape(cols, 4, rows);
        out[2] = temp02.javaTensorAlongDimension(0, 0, 2).reshape(rows, cols);
        temp02 = Nd4j.linspace(1, len, len).reshape(cols, 4, rows);
        out[3] = temp02.javaTensorAlongDimension(2, 0, 2).reshape(rows, cols);
        INDArray temp10 = Nd4j.linspace(1, len, len).reshape(rows, cols, 4);
        out[4] = temp10.javaTensorAlongDimension(0, 1, 0).reshape(rows, cols);
        temp10 = Nd4j.linspace(1, len, len).reshape(rows, cols, 4);
        out[5] = temp10.javaTensorAlongDimension(2, 1, 0).reshape(rows, cols);
        INDArray temp12 = Nd4j.linspace(1, len, len).reshape(4, cols, rows);
        out[6] = temp12.javaTensorAlongDimension(0, 1, 2).reshape(rows, cols);
        temp12 = Nd4j.linspace(1, len, len).reshape(4, cols, rows);
        out[7] = temp12.javaTensorAlongDimension(2, 1, 2).reshape(rows, cols);
        INDArray temp20 = Nd4j.linspace(1, len, len).reshape(rows, 4, cols);
        out[8] = temp20.javaTensorAlongDimension(0, 2, 0).reshape(rows, cols);
        temp20 = Nd4j.linspace(1, len, len).reshape(rows, 4, cols);
        out[9] = temp20.javaTensorAlongDimension(2, 2, 0).reshape(rows, cols);
        INDArray temp21 = Nd4j.linspace(1, len, len).reshape(4, rows, cols);
        out[10] = temp21.javaTensorAlongDimension(0, 2, 1).reshape(rows, cols);
        temp21 = Nd4j.linspace(1, len, len).reshape(4, rows, cols);
        out[11] = temp21.javaTensorAlongDimension(2, 2, 1).reshape(rows, cols);
        String baseMsg = "getTensorAlongDimensionMatricesWithShape(" + rows + "," + cols + "," + seed + ")";
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>(12);
        for (int i = 0; i < out.length; ++i) {
            list.add((Pair<INDArray, String>)new Pair((Object)out[i], (Object)(baseMsg + ".get(" + i + ")")));
        }
        return list;
    }

    public static List<Pair<INDArray, String>> getTensorAlongDimensionMatricesWithShape(int rows, int cols, int seed) {
        return NDArrayCreationUtil.getTensorAlongDimensionMatricesWithShape(Nd4j.order().charValue(), rows, cols, seed);
    }

    public static Pair<INDArray, String> getPermutedWithShape(char ordering, int rows, int cols, int seed) {
        Nd4j.getRandom().setSeed(seed);
        int len = rows * cols;
        INDArray arr = Nd4j.linspace(1, len, len).reshape(cols, rows);
        return new Pair((Object)arr.permute(1, 0), (Object)("getPermutedWithShape(" + rows + "," + cols + "," + seed + ")"));
    }

    public static Pair<INDArray, String> getPermutedWithShape(int rows, int cols, int seed) {
        return NDArrayCreationUtil.getPermutedWithShape(Nd4j.order().charValue(), rows, cols, seed);
    }

    public static Pair<INDArray, String> getReshapedWithShape(char ordering, int rows, int cols, int seed) {
        Nd4j.getRandom().setSeed(seed);
        int[] origShape = new int[3];
        if (rows % 2 == 0) {
            origShape[0] = rows / 2;
            origShape[1] = cols;
            origShape[2] = 2;
        } else if (cols % 2 == 0) {
            origShape[0] = rows;
            origShape[1] = cols / 2;
            origShape[2] = 2;
        } else {
            origShape[0] = 1;
            origShape[1] = rows;
            origShape[2] = cols;
        }
        int len = ArrayUtil.prod((int[])origShape);
        INDArray orig = Nd4j.linspace(1, len, len).reshape(ordering, origShape);
        return new Pair((Object)orig.reshape(ordering, rows, cols), (Object)("getReshapedWithShape(" + rows + "," + cols + "," + seed + ")"));
    }

    public static Pair<INDArray, String> getReshapedWithShape(int rows, int cols, int seed) {
        return NDArrayCreationUtil.getReshapedWithShape(Nd4j.order().charValue(), rows, cols, seed);
    }

    public static List<Pair<INDArray, String>> getAll3dTestArraysWithShape(int seed, int ... shape) {
        if (shape.length != 3) {
            throw new IllegalArgumentException("Shape is not length 3");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll3dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        int len = ArrayUtil.prod((int[])shape);
        Nd4j.getRandom().setSeed(seed);
        INDArray stdC = Nd4j.linspace(1, len, len).reshape('c', shape);
        INDArray stdF = Nd4j.linspace(1, len, len).reshape('f', shape);
        list.add(new Pair((Object)stdC, (Object)(baseMsg + "0)/Nd4j.linspace(1,len,len)(" + Arrays.toString(shape) + ",'c')")));
        list.add(new Pair((Object)stdF, (Object)(baseMsg + "1)/Nd4j.linspace(1,len,len(" + Arrays.toString(shape) + ",'f')")));
        list.addAll(NDArrayCreationUtil.get3dSubArraysWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get3dTensorAlongDimensionWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get3dPermutedWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get3dReshapedWithShape(seed, shape));
        return list;
    }

    public static List<Pair<INDArray, String>> get3dSubArraysWithShape(int seed, int ... shape) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get3dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5;
        int len = ArrayUtil.prod((int[])newShape1);
        INDArray temp1 = Nd4j.linspace(1, len, len).reshape(newShape1);
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2, shape[0] + 2), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset1, (Object)(baseMsg + ".get(0)")));
        int[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5;
        int len2 = ArrayUtil.prod((int[])newShape2);
        INDArray temp2 = Nd4j.linspace(1, len2, len2).reshape(newShape2);
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.all());
        list.add(new Pair((Object)subset2, (Object)(baseMsg + ".get(1)")));
        int[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5;
        int len3 = ArrayUtil.prod((int[])newShape3);
        INDArray temp3 = Nd4j.linspace(1, len3, len3).reshape(newShape3);
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4, shape[2] + 4));
        list.add(new Pair((Object)subset3, (Object)(baseMsg + ".get(2)")));
        int[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[0] = newShape4[0] + 5;
        newShape4[1] = newShape4[1] + 5;
        newShape4[2] = newShape4[2] + 5;
        int len4 = ArrayUtil.prod((int[])newShape4);
        INDArray temp4 = Nd4j.linspace(1, len4, len4).reshape(newShape4);
        INDArray subset4 = temp4.get(NDArrayIndex.interval(4, shape[0] + 4), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.interval(2, shape[2] + 2));
        list.add(new Pair((Object)subset4, (Object)(baseMsg + ".get(3)")));
        return list;
    }

    public static List<Pair<INDArray, String>> get3dTensorAlongDimensionWithShape(int seed, int ... shape) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get3dTensorAlongDimensionWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] shape4d1 = new int[]{shape[0], shape[1], shape[2], 3};
        int lenshape4d1 = ArrayUtil.prod((int[])shape4d1);
        INDArray orig1a = Nd4j.linspace(1, lenshape4d1, lenshape4d1).reshape(shape4d1);
        INDArray tad1a = orig1a.javaTensorAlongDimension(0, 0, 1, 2);
        INDArray orig1b = Nd4j.linspace(1, lenshape4d1, lenshape4d1).reshape(shape4d1);
        INDArray tad1b = orig1b.javaTensorAlongDimension(1, 0, 1, 2);
        list.add(new Pair((Object)tad1a, (Object)(baseMsg + ".get(0)")));
        list.add(new Pair((Object)tad1b, (Object)(baseMsg + ".get(1)")));
        int[] shape4d2 = new int[]{3, shape[0], shape[1], shape[2]};
        int lenshape4d2 = ArrayUtil.prod((int[])shape4d2);
        INDArray orig2 = Nd4j.linspace(1, lenshape4d2, lenshape4d2).reshape(shape4d2);
        INDArray tad2 = orig2.javaTensorAlongDimension(1, 1, 2, 3);
        list.add(new Pair((Object)tad2, (Object)(baseMsg + ".get(2)")));
        int[] shape4d3 = new int[]{shape[0], shape[1], 3, shape[2]};
        int lenshape4d3 = ArrayUtil.prod((int[])shape4d3);
        INDArray orig3 = Nd4j.linspace(1, lenshape4d3, lenshape4d3).reshape(shape4d3);
        INDArray tad3 = orig3.javaTensorAlongDimension(1, 1, 3, 0);
        list.add(new Pair((Object)tad3, (Object)(baseMsg + ".get(3)")));
        int[] shape4d4 = new int[]{shape[0], 3, shape[1], shape[2]};
        int lenshape4d4 = ArrayUtil.prod((int[])shape4d4);
        INDArray orig4 = Nd4j.linspace(1, lenshape4d4, lenshape4d4).reshape(shape4d4);
        INDArray tad4 = orig4.javaTensorAlongDimension(1, 2, 0, 3);
        list.add(new Pair((Object)tad4, (Object)(baseMsg + ".get(4)")));
        return list;
    }

    public static List<Pair<INDArray, String>> get3dPermutedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] createdShape = new int[]{shape[1], shape[2], shape[0]};
        int lencreatedShape = ArrayUtil.prod((int[])createdShape);
        INDArray arr = Nd4j.linspace(1, lencreatedShape, lencreatedShape).reshape(createdShape);
        INDArray permuted = arr.permute(2, 0, 1);
        return Collections.singletonList(new Pair((Object)permuted, (Object)("get3dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static List<Pair<INDArray, String>> get3dReshapedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape2d = new int[]{shape[0] * shape[2], shape[1]};
        int lenshape2d = ArrayUtil.prod((int[])shape2d);
        INDArray array2d = Nd4j.linspace(1, lenshape2d, lenshape2d).reshape(shape2d);
        INDArray array3d = array2d.reshape(shape);
        return Collections.singletonList(new Pair((Object)array3d, (Object)("get3dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static List<Pair<INDArray, String>> getAll4dTestArraysWithShape(int seed, int ... shape) {
        if (shape.length != 4) {
            throw new IllegalArgumentException("Shape is not length 4");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll4dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        Nd4j.getRandom().setSeed(seed);
        int len = ArrayUtil.prod((int[])shape);
        INDArray stdC = Nd4j.linspace(1, len, len).reshape('c', shape);
        INDArray stdF = Nd4j.linspace(1, len, len).reshape('f', shape);
        list.add(new Pair((Object)stdC, (Object)(baseMsg + "0)/Nd4j.rand(" + Arrays.toString(shape) + ",'c')")));
        list.add(new Pair((Object)stdF, (Object)(baseMsg + "1)/Nd4j.rand(" + Arrays.toString(shape) + ",'f')")));
        list.addAll(NDArrayCreationUtil.get4dSubArraysWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get4dTensorAlongDimensionWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get4dPermutedWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get4dReshapedWithShape(seed, shape));
        return list;
    }

    public static List<Pair<INDArray, String>> get4dSubArraysWithShape(int seed, int ... shape) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get4dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5;
        int len = ArrayUtil.prod((int[])newShape1);
        INDArray temp1 = Nd4j.linspace(1, len, len).reshape(newShape1);
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2, shape[0] + 2), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset1, (Object)(baseMsg + ".get(0)")));
        int[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5;
        int len2 = ArrayUtil.prod((int[])newShape2);
        INDArray temp2 = Nd4j.linspace(1, len2, len2).reshape(newShape2);
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset2, (Object)(baseMsg + ".get(1)")));
        int[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5;
        int len3 = ArrayUtil.prod((int[])newShape3);
        INDArray temp3 = Nd4j.linspace(1, len3, len3).reshape(newShape3);
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4, shape[2] + 4), NDArrayIndex.all());
        list.add(new Pair((Object)subset3, (Object)(baseMsg + ".get(2)")));
        int[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[3] = newShape4[3] + 5;
        int len4 = ArrayUtil.prod((int[])newShape4);
        INDArray temp4 = Nd4j.linspace(1, len4, len4).reshape(newShape4);
        INDArray subset4 = temp4.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[3] + 3));
        list.add(new Pair((Object)subset4, (Object)(baseMsg + ".get(3)")));
        int[] newShape5 = Arrays.copyOf(shape, shape.length);
        newShape5[0] = newShape5[0] + 5;
        newShape5[1] = newShape5[1] + 5;
        newShape5[2] = newShape5[2] + 5;
        newShape5[3] = newShape5[3] + 5;
        int len5 = ArrayUtil.prod((int[])newShape5);
        INDArray temp5 = Nd4j.linspace(1, len5, len5).reshape(newShape5);
        INDArray subset5 = temp5.get(NDArrayIndex.interval(4, shape[0] + 4), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.interval(2, shape[2] + 2), NDArrayIndex.interval(1, shape[3] + 1));
        list.add(new Pair((Object)subset5, (Object)(baseMsg + ".get(4)")));
        return list;
    }

    public static List<Pair<INDArray, String>> get4dTensorAlongDimensionWithShape(int seed, int ... shape) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get4dTensorAlongDimensionWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] shape4d1 = new int[]{3, shape[0], shape[1], shape[2], shape[3]};
        int len = ArrayUtil.prod((int[])shape4d1);
        INDArray orig1a = Nd4j.linspace(1, len, len).reshape(shape4d1);
        INDArray tad1a = orig1a.javaTensorAlongDimension(0, 1, 2, 3, 4);
        INDArray orig1b = Nd4j.linspace(1, len, len).reshape(shape4d1);
        INDArray tad1b = orig1b.javaTensorAlongDimension(2, 1, 2, 3, 4);
        list.add(new Pair((Object)tad1a, (Object)(baseMsg + ".get(0)")));
        list.add(new Pair((Object)tad1b, (Object)(baseMsg + ".get(1)")));
        int[] shape4d2 = new int[]{3, shape[0], shape[1], shape[2], shape[3]};
        int len2 = ArrayUtil.prod((int[])shape4d2);
        INDArray orig2 = Nd4j.linspace(1, len2, len2).reshape(shape4d2);
        INDArray tad2 = orig2.javaTensorAlongDimension(1, 3, 4, 2, 1);
        list.add(new Pair((Object)tad2, (Object)(baseMsg + ".get(2)")));
        int[] shape4d3 = new int[]{shape[0], shape[1], 3, shape[2], shape[3]};
        int len3 = ArrayUtil.prod((int[])shape4d3);
        INDArray orig3 = Nd4j.linspace(1, len3, len3).reshape(shape4d3);
        INDArray tad3 = orig3.javaTensorAlongDimension(1, 4, 1, 3, 0);
        list.add(new Pair((Object)tad3, (Object)(baseMsg + ".get(3)")));
        int[] shape4d4 = new int[]{shape[0], shape[1], shape[2], shape[3], 3};
        int len4 = ArrayUtil.prod((int[])shape4d4);
        INDArray orig4 = Nd4j.linspace(1, len4, len4).reshape(shape4d4);
        INDArray tad4 = orig4.javaTensorAlongDimension(1, 2, 0, 3, 1);
        list.add(new Pair((Object)tad4, (Object)(baseMsg + ".get(4)")));
        return list;
    }

    public static List<Pair<INDArray, String>> get4dPermutedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] createdShape = new int[]{shape[1], shape[3], shape[2], shape[0]};
        INDArray arr = Nd4j.rand(createdShape);
        INDArray permuted = arr.permute(3, 0, 2, 1);
        return Collections.singletonList(new Pair((Object)permuted, (Object)("get4dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static List<Pair<INDArray, String>> get4dReshapedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape2d = new int[]{shape[0] * shape[2], shape[1] * shape[3]};
        INDArray array2d = Nd4j.rand(shape2d);
        INDArray array3d = array2d.reshape(shape);
        return Collections.singletonList(new Pair((Object)array3d, (Object)("get4dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static List<Pair<INDArray, String>> getAll5dTestArraysWithShape(int seed, int ... shape) {
        if (shape.length != 5) {
            throw new IllegalArgumentException("Shape is not length 5");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll5dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        Nd4j.getRandom().setSeed(seed);
        INDArray stdC = Nd4j.rand(shape, 99L);
        INDArray stdF = Nd4j.rand(shape, 102L);
        list.add(new Pair((Object)stdC, (Object)(baseMsg + "0)/Nd4j.rand(" + Arrays.toString(shape) + ",'c')")));
        list.add(new Pair((Object)stdF, (Object)(baseMsg + "1)/Nd4j.rand(" + Arrays.toString(shape) + ",'f')")));
        list.addAll(NDArrayCreationUtil.get5dSubArraysWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get5dTensorAlongDimensionWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get5dPermutedWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get5dReshapedWithShape(seed, shape));
        return list;
    }

    public static List<Pair<INDArray, String>> get5dSubArraysWithShape(int seed, int ... shape) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get5dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5;
        INDArray temp1 = Nd4j.rand(newShape1);
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2, shape[0] + 2), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset1, (Object)(baseMsg + ".get(0)")));
        int[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5;
        INDArray temp2 = Nd4j.rand(newShape2);
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset2, (Object)(baseMsg + ".get(1)")));
        int[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5;
        INDArray temp3 = Nd4j.rand(newShape3);
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4, shape[2] + 4), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset3, (Object)(baseMsg + ".get(2)")));
        int[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[3] = newShape4[3] + 5;
        INDArray temp4 = Nd4j.rand(newShape4);
        INDArray subset4 = temp4.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[3] + 3), NDArrayIndex.all());
        list.add(new Pair((Object)subset4, (Object)(baseMsg + ".get(3)")));
        int[] newShape5 = Arrays.copyOf(shape, shape.length);
        newShape5[4] = newShape5[4] + 5;
        INDArray temp5 = Nd4j.rand(newShape5);
        INDArray subset5 = temp5.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[4] + 3));
        list.add(new Pair((Object)subset5, (Object)(baseMsg + ".get(4)")));
        int[] newShape6 = Arrays.copyOf(shape, shape.length);
        newShape6[0] = newShape6[0] + 5;
        newShape6[1] = newShape6[1] + 5;
        newShape6[2] = newShape6[2] + 5;
        newShape6[3] = newShape6[3] + 5;
        newShape6[4] = newShape6[4] + 5;
        INDArray temp6 = Nd4j.rand(newShape6);
        INDArray subset6 = temp6.get(NDArrayIndex.interval(4, shape[0] + 4), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.interval(2, shape[2] + 2), NDArrayIndex.interval(1, shape[3] + 1), NDArrayIndex.interval(2, shape[4] + 2));
        list.add(new Pair((Object)subset6, (Object)(baseMsg + ".get(5)")));
        return list;
    }

    public static List<Pair<INDArray, String>> get5dTensorAlongDimensionWithShape(int seed, int ... shape) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get5dTensorAlongDimensionWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] shape4d1 = new int[]{3, shape[0], shape[1], shape[2], shape[3], shape[4]};
        INDArray orig1a = Nd4j.rand(shape4d1);
        INDArray tad1a = orig1a.javaTensorAlongDimension(0, 1, 2, 3, 4, 5);
        INDArray orig1b = Nd4j.rand(shape4d1);
        INDArray tad1b = orig1b.javaTensorAlongDimension(2, 1, 2, 3, 4, 5);
        list.add(new Pair((Object)tad1a, (Object)(baseMsg + ".get(0)")));
        list.add(new Pair((Object)tad1b, (Object)(baseMsg + ".get(1)")));
        int[] shape4d2 = new int[]{3, shape[0], shape[1], shape[2], shape[3], shape[4]};
        INDArray orig2 = Nd4j.rand(shape4d2);
        INDArray tad2 = orig2.javaTensorAlongDimension(1, 3, 5, 4, 2, 1);
        list.add(new Pair((Object)tad2, (Object)(baseMsg + ".get(2)")));
        int[] shape4d3 = new int[]{shape[0], shape[1], shape[2], shape[3], shape[4], 2};
        INDArray orig3 = Nd4j.rand(shape4d3);
        INDArray tad3 = orig3.javaTensorAlongDimension(1, 4, 1, 3, 2, 0);
        list.add(new Pair((Object)tad3, (Object)(baseMsg + ".get(3)")));
        int[] shape4d4 = new int[]{shape[0], shape[1], shape[2], shape[3], 3, shape[4]};
        INDArray orig4 = Nd4j.rand(shape4d4);
        INDArray tad4 = orig4.javaTensorAlongDimension(1, 5, 2, 0, 3, 1);
        list.add(new Pair((Object)tad4, (Object)(baseMsg + ".get(4)")));
        return list;
    }

    public static List<Pair<INDArray, String>> get5dPermutedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] createdShape = new int[]{shape[1], shape[4], shape[3], shape[2], shape[0]};
        INDArray arr = Nd4j.rand(createdShape);
        INDArray permuted = arr.permute(4, 0, 3, 2, 1);
        return Collections.singletonList(new Pair((Object)permuted, (Object)("get5dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static List<Pair<INDArray, String>> get5dReshapedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape2d = new int[]{shape[0] * shape[2], shape[4], shape[1] * shape[3]};
        INDArray array3d = Nd4j.rand(shape2d);
        INDArray array5d = array3d.reshape(shape);
        return Collections.singletonList(new Pair((Object)array5d, (Object)("get5dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static List<Pair<INDArray, String>> getAll6dTestArraysWithShape(int seed, int ... shape) {
        if (shape.length != 6) {
            throw new IllegalArgumentException("Shape is not length 6");
        }
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "getAll6dTestArraysWithShape(" + seed + "," + Arrays.toString(shape) + ").get(";
        Nd4j.getRandom().setSeed(seed);
        INDArray stdC = Nd4j.rand(shape, 99L);
        INDArray stdF = Nd4j.rand(shape, 102L);
        list.add(new Pair((Object)stdC, (Object)(baseMsg + "0)/Nd4j.rand(" + Arrays.toString(shape) + ",'c')")));
        list.add(new Pair((Object)stdF, (Object)(baseMsg + "1)/Nd4j.rand(" + Arrays.toString(shape) + ",'f')")));
        list.addAll(NDArrayCreationUtil.get6dSubArraysWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get6dPermutedWithShape(seed, shape));
        list.addAll(NDArrayCreationUtil.get6dReshapedWithShape(seed, shape));
        return list;
    }

    public static List<Pair<INDArray, String>> get6dSubArraysWithShape(int seed, int ... shape) {
        ArrayList<Pair<INDArray, String>> list = new ArrayList<Pair<INDArray, String>>();
        String baseMsg = "get6dSubArraysWithShape(" + seed + "," + Arrays.toString(shape) + ")";
        Nd4j.getRandom().setSeed(seed);
        int[] newShape1 = Arrays.copyOf(shape, shape.length);
        newShape1[0] = newShape1[0] + 5;
        INDArray temp1 = Nd4j.rand(newShape1);
        INDArray subset1 = temp1.get(NDArrayIndex.interval(2, shape[0] + 2), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset1, (Object)(baseMsg + ".get(0)")));
        int[] newShape2 = Arrays.copyOf(shape, shape.length);
        newShape2[1] = newShape2[1] + 5;
        INDArray temp2 = Nd4j.rand(newShape2);
        INDArray subset2 = temp2.get(NDArrayIndex.all(), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset2, (Object)(baseMsg + ".get(1)")));
        int[] newShape3 = Arrays.copyOf(shape, shape.length);
        newShape3[2] = newShape3[2] + 5;
        INDArray temp3 = Nd4j.rand(newShape3);
        INDArray subset3 = temp3.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(4, shape[2] + 4), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset3, (Object)(baseMsg + ".get(2)")));
        int[] newShape4 = Arrays.copyOf(shape, shape.length);
        newShape4[3] = newShape4[3] + 5;
        INDArray temp4 = Nd4j.rand(newShape4);
        INDArray subset4 = temp4.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[3] + 3), NDArrayIndex.all(), NDArrayIndex.all());
        list.add(new Pair((Object)subset4, (Object)(baseMsg + ".get(3)")));
        int[] newShape5 = Arrays.copyOf(shape, shape.length);
        newShape5[4] = newShape5[4] + 5;
        INDArray temp5 = Nd4j.rand(newShape5);
        INDArray subset5 = temp5.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(3, shape[4] + 3), NDArrayIndex.all());
        list.add(new Pair((Object)subset5, (Object)(baseMsg + ".get(4)")));
        int[] newShape6 = Arrays.copyOf(shape, shape.length);
        newShape6[5] = newShape6[5] + 5;
        INDArray temp6 = Nd4j.rand(newShape6);
        INDArray subset6 = temp6.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(1, shape[5] + 1));
        list.add(new Pair((Object)subset6, (Object)(baseMsg + ".get(5)")));
        int[] newShape7 = Arrays.copyOf(shape, shape.length);
        newShape7[0] = newShape7[0] + 5;
        newShape7[1] = newShape7[1] + 5;
        newShape7[2] = newShape7[2] + 5;
        newShape7[3] = newShape7[3] + 5;
        newShape7[4] = newShape7[4] + 5;
        newShape7[5] = newShape7[5] + 5;
        INDArray temp7 = Nd4j.rand(newShape7);
        INDArray subset7 = temp7.get(NDArrayIndex.interval(4, shape[0] + 4), NDArrayIndex.interval(3, shape[1] + 3), NDArrayIndex.interval(2, shape[2] + 2), NDArrayIndex.interval(1, shape[3] + 1), NDArrayIndex.interval(2, shape[4] + 2), NDArrayIndex.interval(3, shape[5] + 3));
        list.add(new Pair((Object)subset7, (Object)(baseMsg + ".get(6)")));
        return list;
    }

    public static List<Pair<INDArray, String>> get6dPermutedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] createdShape = new int[]{shape[1], shape[4], shape[5], shape[3], shape[2], shape[0]};
        INDArray arr = Nd4j.rand(createdShape);
        INDArray permuted = arr.permute(5, 0, 4, 3, 1, 2);
        return Collections.singletonList(new Pair((Object)permuted, (Object)("get6dPermutedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static List<Pair<INDArray, String>> get6dReshapedWithShape(int seed, int ... shape) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape3d = new int[]{shape[0] * shape[2], shape[4] * shape[5], shape[1] * shape[3]};
        INDArray array3d = Nd4j.rand(shape3d);
        INDArray array6d = array3d.reshape(shape);
        return Collections.singletonList(new Pair((Object)array6d, (Object)("get6dReshapedWithShape(" + seed + "," + Arrays.toString(shape) + ").get(0)")));
    }

    public static int[][] getRandomBroadCastShape(long seed, int rank, int numShapes) {
        Nd4j.getRandom().setSeed(seed);
        INDArray coinFlip = Nd4j.getDistributions().createBinomial(1, 0.5).sample(new int[]{numShapes, rank});
        int[][] ret = new int[coinFlip.rows()][coinFlip.columns()];
        for (int i = 0; i < coinFlip.rows(); ++i) {
            for (int j = 0; j < coinFlip.columns(); ++j) {
                int set = coinFlip.getInt(i, j);
                ret[i][j] = set > 0 ? set : Nd4j.getRandom().nextInt(9) + 1;
            }
        }
        return ret;
    }

    public static int[] broadcastToShape(int[] inputShapeWithOnes, long seed) {
        Nd4j.getRandom().setSeed(seed);
        int[] shape = new int[inputShapeWithOnes.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = inputShapeWithOnes[i] == 1 ? Nd4j.getRandom().nextInt(9) + 1 : inputShapeWithOnes[i];
        }
        return shape;
    }
}

