/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Unstack
extends DynamicCustomOp {
    private int axis;

    public Unstack() {
    }

    public Unstack(SameDiff sameDiff, SDVariable value, int axis) {
        super(null, sameDiff, new SDVariable[]{value}, false);
        this.axis = axis;
        this.addArgs();
    }

    public void addArgs() {
        this.addIArgument(this.axis);
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Unstack", "Unpack"};
    }

    @Override
    public String tensorflowName() {
        return "Unstack";
    }

    @Override
    public String opName() {
        return "unstack";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        int axis;
        AttrValue attrAxis = nodeDef.getAttrOrThrow("axis");
        this.axis = axis = (int)attrAxis.getI();
        this.addArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("axis", this.axis);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping axisMapping = PropertyMapping.builder().onnxAttrName("axis").tfInputPosition(-1).propertyNames(new String[]{"axis"}).build();
        map.put("axis", axisMapping);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        throw new UnsupportedOperationException("No analog found for onnx for " + this.opName());
    }

    @Override
    public List<int[]> calculateOutputShape() {
        int i;
        ArrayList<int[]> ret = new ArrayList<int[]>();
        int[] inputShape = this.arg().getShape();
        int[] outputShape = new int[inputShape.length - 1];
        for (i = 0; i < this.axis; ++i) {
            outputShape[i] = inputShape[i];
        }
        for (i = this.axis + 1; i < inputShape.length; ++i) {
            outputShape[i - 1] = inputShape[i];
        }
        for (i = 0; i < inputShape[this.axis]; ++i) {
            ret.add(outputShape);
        }
        return ret;
    }
}

