/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.params;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class MMulTranspose
implements Serializable {
    private boolean transposeA = false;
    private boolean transposeB = false;
    private boolean transposeResult = false;
    private INDArray a;
    private INDArray b;
    private static MMulTranspose allFalse = MMulTranspose.builder().build();

    public static MMulTranspose allFalse() {
        return allFalse;
    }

    public MMulTranspose(boolean transposeA, boolean transposeB, boolean transposeResult, INDArray a, INDArray b) {
        this.transposeA = transposeA;
        this.transposeB = transposeB;
        this.transposeResult = transposeResult;
        if (transposeResult) {
            this.transposeA = !transposeA;
            this.transposeB = !transposeB;
            this.a = b;
            this.b = a;
        }
        this.transposeA = transposeA;
        this.transposeB = transposeB;
        this.a = this.transposeA && a != null ? a.transpose() : a;
        this.b = this.transposeB && b != null ? b.transpose() : b;
    }

    public static MMulTransposeBuilder builder() {
        return new MMulTransposeBuilder();
    }

    public boolean isTransposeA() {
        return this.transposeA;
    }

    public boolean isTransposeB() {
        return this.transposeB;
    }

    public boolean isTransposeResult() {
        return this.transposeResult;
    }

    public INDArray getA() {
        return this.a;
    }

    public INDArray getB() {
        return this.b;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MMulTranspose)) {
            return false;
        }
        MMulTranspose other = (MMulTranspose)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTransposeA() != other.isTransposeA()) {
            return false;
        }
        if (this.isTransposeB() != other.isTransposeB()) {
            return false;
        }
        if (this.isTransposeResult() != other.isTransposeResult()) {
            return false;
        }
        INDArray this$a = this.getA();
        INDArray other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        INDArray this$b = this.getB();
        INDArray other$b = other.getB();
        return !(this$b == null ? other$b != null : !this$b.equals(other$b));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MMulTranspose;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransposeA() ? 79 : 97);
        result = result * 59 + (this.isTransposeB() ? 79 : 97);
        result = result * 59 + (this.isTransposeResult() ? 79 : 97);
        INDArray $a = this.getA();
        result = result * 59 + ($a == null ? 43 : $a.hashCode());
        INDArray $b = this.getB();
        result = result * 59 + ($b == null ? 43 : $b.hashCode());
        return result;
    }

    public static class MMulTransposeBuilder {
        private boolean transposeA;
        private boolean transposeB;
        private boolean transposeResult;
        private INDArray a;
        private INDArray b;

        MMulTransposeBuilder() {
        }

        public MMulTransposeBuilder transposeA(boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public MMulTransposeBuilder transposeB(boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public MMulTransposeBuilder transposeResult(boolean transposeResult) {
            this.transposeResult = transposeResult;
            return this;
        }

        public MMulTransposeBuilder a(INDArray a) {
            this.a = a;
            return this;
        }

        public MMulTransposeBuilder b(INDArray b) {
            this.b = b;
            return this;
        }

        public MMulTranspose build() {
            return new MMulTranspose(this.transposeA, this.transposeB, this.transposeResult, this.a, this.b);
        }

        public String toString() {
            return "MMulTranspose.MMulTransposeBuilder(transposeA=" + this.transposeA + ", transposeB=" + this.transposeB + ", transposeResult=" + this.transposeResult + ", a=" + this.a + ", b=" + this.b + ")";
        }
    }
}

