/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.imports.converters;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.onnx.OnnxDescriptorParser;
import org.nd4j.imports.descriptors.onnx.OpDescriptor;
import org.nd4j.imports.descriptors.tensorflow.TensorflowDescriptorParser;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DepthwiseConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.FullConv3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.LocalResponseNormalization;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3D;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.OpDef;

public class DifferentialFunctionClassHolder {
    private static final Logger log = LoggerFactory.getLogger(DifferentialFunctionClassHolder.class);
    private Map<String, DifferentialFunction> nodeConverters = new HashMap<String, DifferentialFunction>();
    private static DifferentialFunctionClassHolder INSTANCE = new DifferentialFunctionClassHolder();
    private Map<String, DifferentialFunction> tensorFlowNames = new HashMap<String, DifferentialFunction>();
    private Map<String, DifferentialFunction> onnxNames = new HashMap<String, DifferentialFunction>();
    private List<String> missingOps = new ArrayList<String>();
    private Map<String, OpDescriptor> onnxOpDescriptors;
    private Map<String, OpDef> tensorflowOpDescriptors;
    private Map<String, Map<String, Field>> fieldsForFunction;
    private Set<String> fieldNamesOpsIgnore;
    private Set<String> classesWithConfig = new LinkedHashSet<String>(){
        {
            this.add(AvgPooling2D.class.getName());
            this.add(Conv2D.class.getName());
            this.add(Conv3D.class.getName());
            this.add(FullConv3D.class.getName());
            this.add(LocalResponseNormalization.class.getName());
            this.add(MaxPooling2D.class.getName());
            this.add(Pooling2D.class.getName());
            this.add(Pooling3D.class.getName());
            this.add(DepthwiseConv2D.class.getName());
        }
    };

    public Map<String, Field> getFieldsForFunction(DifferentialFunction function) {
        return this.fieldsForFunction.get(function.opName());
    }

    public OpDef getOpDefByTensorflowName(String name) {
        if (!this.tensorflowOpDescriptors.containsKey(name)) {
            throw new ND4JIllegalStateException("No op found with name " + name);
        }
        return this.tensorflowOpDescriptors.get(name);
    }

    public OpDescriptor getOpDescriptorForOnnx(String name) {
        if (!this.onnxOpDescriptors.containsKey(name)) {
            throw new ND4JIllegalStateException("No op found with name " + name);
        }
        return this.onnxOpDescriptors.get(name);
    }

    public DifferentialFunction getOpWithTensorflowName(String tensorflowName) {
        return this.tensorFlowNames.get(tensorflowName);
    }

    public DifferentialFunction getOpWithOnnxName(String onnxName) {
        return this.onnxNames.get(onnxName);
    }

    private DifferentialFunctionClassHolder() {
        ImmutableSet info;
        this.fieldNamesOpsIgnore = new LinkedHashSet<String>(){
            {
                this.add("extraArgs");
                this.add("arrayInitialized");
                this.add("log");
                this.add("inputArguments");
                this.add("outputArguments");
                this.add("outputShapes");
                this.add("outputVariables");
                this.add("tArguments");
                this.add("iArguments");
                this.add("hash");
                this.add("opName");
                this.add("sameDiff");
                this.add("ownName");
            }
        };
        try {
            info = ClassPath.from((ClassLoader)DifferentialFunctionClassHolder.class.getClassLoader()).getTopLevelClassesRecursive("org.nd4j.linalg.api.ops");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.fieldsForFunction = new LinkedHashMap<String, Map<String, Field>>();
        boolean count = false;
        for (ClassPath.ClassInfo c : info) {
            Class<?> clazz;
            try {
                clazz = Class.forName(c.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface() || !DifferentialFunction.class.isAssignableFrom(clazz)) continue;
            try {
                DifferentialFunction node = (DifferentialFunction)clazz.newInstance();
                String name = node.opName();
                if (name == null) continue;
                if (name.endsWith("_bp")) {
                    // empty if block
                }
                if (this.nodeConverters.containsKey(name)) {
                    throw new ND4JIllegalStateException("OpName duplicate found: " + name);
                }
                this.nodeConverters.put(name, node);
                try {
                    for (String s : node.tensorflowNames()) {
                        this.tensorFlowNames.put(s, node);
                    }
                }
                catch (NoOpNameFoundException e) {
                    log.trace("Skipping op " + name + " for tensorflow.");
                }
                try {
                    this.onnxNames.put(node.onnxName(), node);
                }
                catch (NoOpNameFoundException e) {
                    log.trace("Skipping op " + name + " for onnx.");
                }
                LinkedHashMap<String, Field> fieldNames = new LinkedHashMap<String, Field>();
                Class<?> current = node.getClass();
                ArrayList<Field> fields = new ArrayList<Field>();
                while (current.getSuperclass() != null) {
                    if (this.classesWithConfig.contains(current.getName())) {
                        String fieldName = "config";
                        Field configField = current.getDeclaredField("config");
                        if (configField == null) continue;
                        Class<?> configFieldClass = configField.getType();
                        for (Field field : configFieldClass.getDeclaredFields()) {
                            if (this.fieldNamesOpsIgnore.contains(field.getName())) continue;
                            fields.add(field);
                            field.setAccessible(true);
                            fieldNames.put(field.getName(), field);
                        }
                    } else {
                        for (Field field : current.getDeclaredFields()) {
                            if (this.fieldNamesOpsIgnore.contains(field.getName())) continue;
                            fields.add(field);
                            field.setAccessible(true);
                            fieldNames.put(field.getName(), field);
                        }
                    }
                    current = current.getSuperclass();
                }
                this.fieldsForFunction.put(node.opName(), fieldNames);
            }
            catch (NoOpNameFoundException e) {
                log.trace("Skipping function  " + clazz);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.tensorflowOpDescriptors = TensorflowDescriptorParser.opDescs();
            this.onnxOpDescriptors = OnnxDescriptorParser.onnxOpDescriptors();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, CustomOpDescriptor> map = new HashMap<String, CustomOpDescriptor>(Nd4j.getExecutioner().getCustomOperations());
        Set<String> set = map.keySet();
        set.removeAll(this.nodeConverters.keySet());
        this.missingOps.addAll(set);
        Collections.sort(this.missingOps);
        log.warn("Missing " + set.size() + " ops!");
    }

    public Set<String> missingOnnxOps() {
        HashSet<String> copy = new HashSet<String>(this.onnxOpDescriptors.keySet());
        copy.removeAll(this.onnxNames.keySet());
        return copy;
    }

    public Set<String> missingTensorflowOps() {
        HashSet<String> copy = new HashSet<String>(this.tensorflowOpDescriptors.keySet());
        copy.removeAll(this.tensorFlowNames.keySet());
        return copy;
    }

    public List<String> missingOps() {
        return this.missingOps;
    }

    public boolean hasName(String name) {
        return this.nodeConverters.containsKey(name);
    }

    public Set<String> opNames() {
        return this.nodeConverters.keySet();
    }

    public DifferentialFunction getInstance(String name) {
        return this.nodeConverters.get(name);
    }

    public static DifferentialFunctionClassHolder getInstance() {
        return INSTANCE;
    }
}

