/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.functions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.ops.impl.accum.CountNonZero;
import org.nd4j.linalg.api.ops.impl.accum.CountZero;
import org.nd4j.linalg.api.ops.impl.accum.CumProd;
import org.nd4j.linalg.api.ops.impl.accum.CumSum;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.api.ops.impl.accum.Mmul;
import org.nd4j.linalg.api.ops.impl.accum.Moments;
import org.nd4j.linalg.api.ops.impl.accum.Norm1;
import org.nd4j.linalg.api.ops.impl.accum.Norm2;
import org.nd4j.linalg.api.ops.impl.accum.NormMax;
import org.nd4j.linalg.api.ops.impl.accum.NormalizeMoments;
import org.nd4j.linalg.api.ops.impl.accum.Prod;
import org.nd4j.linalg.api.ops.impl.accum.SigmoidCrossEntropyLoss;
import org.nd4j.linalg.api.ops.impl.accum.SoftmaxCrossEntropyLoss;
import org.nd4j.linalg.api.ops.impl.accum.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.api.ops.impl.accum.TensorMmul;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.ops.impl.accum.WeightedCrossEntropyLoss;
import org.nd4j.linalg.api.ops.impl.accum.ZeroFraction;
import org.nd4j.linalg.api.ops.impl.accum.distances.CosineDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.CosineSimilarity;
import org.nd4j.linalg.api.ops.impl.accum.distances.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.HammingDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.JaccardDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.ManhattanDistance;
import org.nd4j.linalg.api.ops.impl.broadcast.BiasAdd;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMin;
import org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNorm;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv1D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DepthToSpace;
import org.nd4j.linalg.api.ops.impl.layers.convolution.LocalResponseNormalization;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SpaceToDepth;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterAdd;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterDiv;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterMul;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterSub;
import org.nd4j.linalg.api.ops.impl.shape.Broadcast;
import org.nd4j.linalg.api.ops.impl.shape.Concat;
import org.nd4j.linalg.api.ops.impl.shape.ConfusionMatrix;
import org.nd4j.linalg.api.ops.impl.shape.Cross;
import org.nd4j.linalg.api.ops.impl.shape.Diag;
import org.nd4j.linalg.api.ops.impl.shape.DiagPart;
import org.nd4j.linalg.api.ops.impl.shape.ExpandDims;
import org.nd4j.linalg.api.ops.impl.shape.Gather;
import org.nd4j.linalg.api.ops.impl.shape.GatherNd;
import org.nd4j.linalg.api.ops.impl.shape.OneHot;
import org.nd4j.linalg.api.ops.impl.shape.OnesLike;
import org.nd4j.linalg.api.ops.impl.shape.ParallelStack;
import org.nd4j.linalg.api.ops.impl.shape.Permute;
import org.nd4j.linalg.api.ops.impl.shape.Repeat;
import org.nd4j.linalg.api.ops.impl.shape.Reshape;
import org.nd4j.linalg.api.ops.impl.shape.RollAxis;
import org.nd4j.linalg.api.ops.impl.shape.SequenceMask;
import org.nd4j.linalg.api.ops.impl.shape.Slice;
import org.nd4j.linalg.api.ops.impl.shape.Squeeze;
import org.nd4j.linalg.api.ops.impl.shape.Stack;
import org.nd4j.linalg.api.ops.impl.shape.StridedSlice;
import org.nd4j.linalg.api.ops.impl.shape.Tile;
import org.nd4j.linalg.api.ops.impl.shape.Transpose;
import org.nd4j.linalg.api.ops.impl.shape.Unstack;
import org.nd4j.linalg.api.ops.impl.shape.ZerosLike;
import org.nd4j.linalg.api.ops.impl.transforms.ACos;
import org.nd4j.linalg.api.ops.impl.transforms.ACosh;
import org.nd4j.linalg.api.ops.impl.transforms.ASin;
import org.nd4j.linalg.api.ops.impl.transforms.ASinh;
import org.nd4j.linalg.api.ops.impl.transforms.ATan;
import org.nd4j.linalg.api.ops.impl.transforms.ATan2;
import org.nd4j.linalg.api.ops.impl.transforms.ATanh;
import org.nd4j.linalg.api.ops.impl.transforms.Abs;
import org.nd4j.linalg.api.ops.impl.transforms.And;
import org.nd4j.linalg.api.ops.impl.transforms.Assign;
import org.nd4j.linalg.api.ops.impl.transforms.BatchToSpace;
import org.nd4j.linalg.api.ops.impl.transforms.Ceil;
import org.nd4j.linalg.api.ops.impl.transforms.Constant;
import org.nd4j.linalg.api.ops.impl.transforms.Cos;
import org.nd4j.linalg.api.ops.impl.transforms.Cosh;
import org.nd4j.linalg.api.ops.impl.transforms.Cube;
import org.nd4j.linalg.api.ops.impl.transforms.Dilation2D;
import org.nd4j.linalg.api.ops.impl.transforms.DynamicPartition;
import org.nd4j.linalg.api.ops.impl.transforms.DynamicStitch;
import org.nd4j.linalg.api.ops.impl.transforms.ELU;
import org.nd4j.linalg.api.ops.impl.transforms.Erf;
import org.nd4j.linalg.api.ops.impl.transforms.Erfc;
import org.nd4j.linalg.api.ops.impl.transforms.Exp;
import org.nd4j.linalg.api.ops.impl.transforms.Expm1;
import org.nd4j.linalg.api.ops.impl.transforms.Fill;
import org.nd4j.linalg.api.ops.impl.transforms.Floor;
import org.nd4j.linalg.api.ops.impl.transforms.HardTanh;
import org.nd4j.linalg.api.ops.impl.transforms.InvertPermutation;
import org.nd4j.linalg.api.ops.impl.transforms.IsFinite;
import org.nd4j.linalg.api.ops.impl.transforms.IsInf;
import org.nd4j.linalg.api.ops.impl.transforms.IsNaN;
import org.nd4j.linalg.api.ops.impl.transforms.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.transforms.Log;
import org.nd4j.linalg.api.ops.impl.transforms.Log1p;
import org.nd4j.linalg.api.ops.impl.transforms.LogSigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.LogSigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.LogSoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.Or;
import org.nd4j.linalg.api.ops.impl.transforms.Pow;
import org.nd4j.linalg.api.ops.impl.transforms.PowDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.RSqrt;
import org.nd4j.linalg.api.ops.impl.transforms.Reciprocal;
import org.nd4j.linalg.api.ops.impl.transforms.RectifedLinear;
import org.nd4j.linalg.api.ops.impl.transforms.Relu6;
import org.nd4j.linalg.api.ops.impl.transforms.ReluLayer;
import org.nd4j.linalg.api.ops.impl.transforms.Reverse;
import org.nd4j.linalg.api.ops.impl.transforms.ReverseSequence;
import org.nd4j.linalg.api.ops.impl.transforms.Round;
import org.nd4j.linalg.api.ops.impl.transforms.SELU;
import org.nd4j.linalg.api.ops.impl.transforms.Sigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.Sign;
import org.nd4j.linalg.api.ops.impl.transforms.Sin;
import org.nd4j.linalg.api.ops.impl.transforms.Sinh;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMaxDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.SoftPlus;
import org.nd4j.linalg.api.ops.impl.transforms.SoftSign;
import org.nd4j.linalg.api.ops.impl.transforms.SpaceToBatch;
import org.nd4j.linalg.api.ops.impl.transforms.Sqrt;
import org.nd4j.linalg.api.ops.impl.transforms.Swish;
import org.nd4j.linalg.api.ops.impl.transforms.SwishDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.Tan;
import org.nd4j.linalg.api.ops.impl.transforms.Tanh;
import org.nd4j.linalg.api.ops.impl.transforms.Xor;
import org.nd4j.linalg.api.ops.impl.transforms.XwPlusB;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.DivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.FModOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.FloorDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.MergeAddOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.MulOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RSubOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.SquaredDifferenceOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.SubOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.TruncateDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.AddBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.DivBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.FloorDivBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.FloorModBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.MulBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.RDivBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.RSubBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.bp.SubBpOp;
import org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByNorm;
import org.nd4j.linalg.api.ops.impl.transforms.clip.ClipByValue;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.EqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.GreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.GreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.IsNonDecreasing;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.IsNumericTensor;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.IsStrictlyIncreasing;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.LessThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.LessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Max;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Min;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.NotEqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.CubeDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.ELUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.GradientBackwardsMarker;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.HardTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LeakyReLUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LogSoftMaxDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SELUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftSignDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.TanhDerivative;
import org.nd4j.linalg.api.ops.random.impl.DropOut;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.util.ArrayUtil;

public class DifferentialFunctionFactory {
    protected SameDiff sameDiff;
    private static Map<String, Method> methodNames;

    public DifferentialFunctionFactory(SameDiff sameDiff) {
        if (sameDiff != null) {
            this.sameDiff = sameDiff;
            if (methodNames == null) {
                Method[] methods;
                methodNames = new HashMap<String, Method>();
                for (Method method : methods = this.getClass().getDeclaredMethods()) {
                    methodNames.put(method.getName().toLowerCase(), method);
                }
            }
        } else {
            throw new IllegalArgumentException("Input not null value.");
        }
    }

    public SameDiff sameDiff() {
        return this.sameDiff;
    }

    public SDVariable invoke(String name, Object[] args) {
        try {
            return (SDVariable)methodNames.get(name).invoke((Object)this, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Constant val(SDVariable iX) {
        return new Constant(this.sameDiff(), iX, iX.getShape());
    }

    public SDVariable var(String iName, SDVariable iX) {
        return SDVariable.builder().shape(iX.getShape()).varName(iName).sameDiff(this.sameDiff()).build();
    }

    public SDVariable zero(int[] shape) {
        return this.sameDiff.zero("one-" + UUID.randomUUID().toString(), shape);
    }

    public SDVariable zerosLike(SDVariable input) {
        return this.zerosLike(null, input);
    }

    public SDVariable zerosLike(String name, SDVariable input) {
        this.validateDifferentialFunctionsameDiff(input);
        return new ZerosLike(name, this.sameDiff(), input).outputVariables()[0];
    }

    public SDVariable one(int[] shape) {
        return this.sameDiff.one("one-" + UUID.randomUUID().toString(), shape);
    }

    public SDVariable onesLike(String name, SDVariable input) {
        this.validateDifferentialFunctionsameDiff(input);
        return new OnesLike(name, this.sameDiff(), input).outputVariables()[0];
    }

    public SDVariable localResponseNormalization(SDVariable inputs, LocalResponseNormalizationConfig lrnConfig) {
        LocalResponseNormalization lrn = LocalResponseNormalization.builder().inputFunctions(new SDVariable[]{inputs}).sameDiff(this.sameDiff()).config(lrnConfig).build();
        return lrn.outputVariables()[0];
    }

    public SDVariable conv1d(SDVariable[] inputs, Conv1DConfig conv1DConfig) {
        Conv1D conv1D = Conv1D.builder().inputFunctions(inputs).sameDiff(this.sameDiff()).config(conv1DConfig).build();
        return conv1D.outputVariables()[0];
    }

    public SDVariable conv2d(SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        Conv2D conv2D = Conv2D.builder().inputFunctions(inputs).sameDiff(this.sameDiff()).config(conv2DConfig).build();
        return conv2D.outputVariables()[0];
    }

    public SDVariable avgPooling2d(SDVariable[] inputs, Pooling2DConfig pooling2DConfig) {
        AvgPooling2D avgPooling2D = AvgPooling2D.builder().inputs(inputs).sameDiff(this.sameDiff()).config(pooling2DConfig).build();
        return avgPooling2D.outputVariables()[0];
    }

    public SDVariable maxPooling2d(SDVariable[] inputs, Pooling2DConfig pooling2DConfig) {
        MaxPooling2D maxPooling2D = MaxPooling2D.builder().inputs(inputs).sameDiff(this.sameDiff()).config(pooling2DConfig).build();
        return maxPooling2D.outputVariables()[0];
    }

    public SDVariable avgPooling3d(SDVariable[] inputs, Pooling3DConfig pooling3DConfig) {
        Pooling3D maxPooling3D = Pooling3D.builder().inputs(inputs).sameDiff(this.sameDiff()).pooling3DConfig(pooling3DConfig).type(Pooling3D.Pooling3DType.AVG).build();
        return maxPooling3D.outputVariables()[0];
    }

    public SDVariable maxPooling3d(SDVariable[] inputs, Pooling3DConfig pooling3DConfig) {
        Pooling3D maxPooling3D = Pooling3D.builder().inputs(inputs).sameDiff(this.sameDiff()).pooling3DConfig(pooling3DConfig).type(Pooling3D.Pooling3DType.MAX).build();
        return maxPooling3D.outputVariables()[0];
    }

    public SDVariable sconv2d(SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        SConv2D sconv2D = SConv2D.sBuilder().inputFunctions(inputs).sameDiff(this.sameDiff()).conv2DConfig(conv2DConfig).build();
        return sconv2D.outputVariables()[0];
    }

    public SDVariable depthWiseConv2d(SDVariable[] inputs, Conv2DConfig depthConv2DConfig) {
        SConv2D depthWiseConv2D = SConv2D.sBuilder().inputFunctions(inputs).sameDiff(this.sameDiff()).conv2DConfig(depthConv2DConfig).build();
        return depthWiseConv2D.outputVariables()[0];
    }

    public SDVariable deconv2d(SDVariable[] inputs, DeConv2DConfig deconv2DConfig) {
        DeConv2D deconv2D = DeConv2D.builder().inputs(inputs).sameDiff(this.sameDiff()).config(deconv2DConfig).build();
        return deconv2D.outputVariables()[0];
    }

    public SDVariable conv3d(SDVariable[] inputs, Conv3DConfig conv3DConfig) {
        Conv3D conv3D = Conv3D.builder().inputFunctions(inputs).conv3DConfig(conv3DConfig).sameDiff(this.sameDiff()).build();
        SDVariable[] outputVars = conv3D.outputVariables();
        return outputVars[0];
    }

    public SDVariable batchNorm(SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, boolean applyGamma, boolean applyBeta, double epsilon) {
        BatchNorm batchNorm = BatchNorm.builder().inputFunctions(new SDVariable[]{input, mean, variance, gamma, beta}).applyGamma(applyGamma).applyBeta(applyBeta).epsilon(epsilon).sameDiff(this.sameDiff()).build();
        SDVariable[] outputVars = batchNorm.outputVariables();
        return outputVars[0];
    }

    public SDVariable[] moments(SDVariable input, int ... axes) {
        return new Moments(this.sameDiff(), input, axes).outputVariables();
    }

    public SDVariable[] normalizeMoments(SDVariable counts, SDVariable means, SDVariable variances, double shift) {
        return new NormalizeMoments(this.sameDiff(), counts, means, variances, shift).outputVariables();
    }

    public SDVariable tile(SDVariable iX, int[] repeat) {
        if (repeat == null) {
            throw new ND4JIllegalStateException("Repeat must not be null!");
        }
        return new Tile(this.sameDiff(), iX, repeat).outputVariables()[0];
    }

    public SDVariable dropout(SDVariable input, double p) {
        return new DropOut(this.sameDiff(), input, p).outputVariables()[0];
    }

    public SDVariable sum(SDVariable i_x, int ... dimensions) {
        return new Sum(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable prod(SDVariable i_x, int ... dimensions) {
        return new Prod(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable mean(SDVariable i_x, int ... dimensions) {
        return new Mean(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable std(SDVariable i_x, boolean biasCorrected, int ... dimensions) {
        return new StandardDeviation(this.sameDiff(), i_x, dimensions, biasCorrected).outputVariables()[0];
    }

    public SDVariable variance(SDVariable i_x, boolean biasCorrected, int ... dimensions) {
        return new Variance(this.sameDiff(), i_x, dimensions, biasCorrected).outputVariables()[0];
    }

    public SDVariable countNonZero(SDVariable input) {
        return new CountNonZero(this.sameDiff(), input).outputVariables()[0];
    }

    public SDVariable countZero(SDVariable input) {
        return new CountZero(this.sameDiff(), input).outputVariables()[0];
    }

    public SDVariable zeroFraction(SDVariable input) {
        return new ZeroFraction(this.sameDiff(), input).outputVariables()[0];
    }

    public SDVariable max(SDVariable i_x, int ... dimensions) {
        return new org.nd4j.linalg.api.ops.impl.accum.Max(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable max(SDVariable first, SDVariable second) {
        return new Max(this.sameDiff(), first, second).outputVariables()[0];
    }

    public SDVariable min(SDVariable i_x, int ... dimensions) {
        return new org.nd4j.linalg.api.ops.impl.accum.Min(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable min(SDVariable first, SDVariable second) {
        return new Min(this.sameDiff(), first, second).outputVariables()[0];
    }

    public SDVariable argmax(SDVariable in, int ... dimensions) {
        return new IMax(this.sameDiff(), in, dimensions).outputVariables()[0];
    }

    public SDVariable argmin(SDVariable in, int ... dimensions) {
        return new IMin(this.sameDiff(), in, dimensions).outputVariables()[0];
    }

    public SDVariable cumsum(SDVariable in, boolean exclusive, boolean reverse, int ... dimensions) {
        return new CumSum(this.sameDiff(), in, exclusive, reverse, dimensions).outputVariables()[0];
    }

    public SDVariable cumprod(SDVariable in, boolean exclusive, boolean reverse, int ... dimensions) {
        return new CumProd(this.sameDiff(), in, exclusive, reverse, dimensions).outputVariables()[0];
    }

    public SDVariable biasAdd(SDVariable input, SDVariable bias) {
        return new BiasAdd(this.sameDiff(), input, bias).outputVariables()[0];
    }

    public SDVariable norm1(SDVariable i_x, int ... dimensions) {
        return new Norm1(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable norm2(SDVariable i_x, int ... dimensions) {
        return new Norm2(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable normmax(SDVariable i_x, int ... dimensions) {
        return new NormMax(this.sameDiff(), i_x, dimensions).outputVariables()[0];
    }

    public SDVariable reductionBroadcastableWithOrigShape(int origRank, int[] reduceDims, SDVariable toExpand) {
        if (Shape.isWholeArray(origRank, reduceDims)) {
            return toExpand;
        }
        if (origRank == 2 && reduceDims.length == 1) {
            return toExpand;
        }
        for (int d : reduceDims) {
            toExpand = this.sameDiff().expandDims(toExpand, d);
        }
        return toExpand;
    }

    public SDVariable gradientBackwardsMarker(SDVariable iX) {
        return new GradientBackwardsMarker(this.sameDiff(), iX, this.sameDiff.scalar(iX.getVarName() + "-pairgrad", 1.0)).outputVariables()[0];
    }

    public SDVariable abs(SDVariable iX) {
        return new Abs(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable neg(SDVariable iX) {
        return new Negative(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable cos(SDVariable iX) {
        return new Cos(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable sin(SDVariable iX) {
        return new Sin(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable tan(SDVariable iX) {
        return new Tan(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable permute(SDVariable iX, int ... dimensions) {
        return new Permute(this.sameDiff(), iX, dimensions).outputVariables()[0];
    }

    public SDVariable invertPermutation(SDVariable input, boolean inPlace) {
        return new InvertPermutation(this.sameDiff(), input, inPlace).outputVariables()[0];
    }

    public SDVariable transpose(SDVariable iX) {
        return new Transpose(this.sameDiff(), iX).outputVariables()[0];
    }

    public SDVariable acos(SDVariable iX) {
        return new ACos(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable asin(SDVariable iX) {
        return new ASin(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable atan(SDVariable iX) {
        return new ATan(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable atan2(SDVariable y, SDVariable x) {
        return new ATan2(this.sameDiff(), y, x).outputVariables()[0];
    }

    public SDVariable cosh(SDVariable iX) {
        return new Cosh(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable sinh(SDVariable iX) {
        return new Sinh(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable tanh(SDVariable iX) {
        return new Tanh(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable tanhDerivative(SDVariable iX, SDVariable wrt) {
        return new TanhDerivative(this.sameDiff(), iX, wrt).outputVariables()[0];
    }

    public SDVariable acosh(SDVariable iX) {
        return new ACosh(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable asinh(SDVariable iX) {
        return new ASinh(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable atanh(SDVariable iX) {
        return new ATanh(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable exp(SDVariable iX) {
        return new Exp(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable expm1(SDVariable iX) {
        return new Expm1(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable rsqrt(SDVariable iX) {
        return new RSqrt(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable log(SDVariable iX) {
        return new Log(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable log1p(SDVariable iX) {
        return new Log1p(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable isFinite(SDVariable ix) {
        return new IsFinite(this.sameDiff(), ix, null).outputVariables()[0];
    }

    public SDVariable isInfinite(SDVariable ix) {
        return new IsInf(this.sameDiff(), ix, null).outputVariables()[0];
    }

    public SDVariable isNaN(SDVariable ix) {
        return new IsNaN(this.sameDiff(), ix, null).outputVariables()[0];
    }

    public SDVariable round(SDVariable ix) {
        return new Round(this.sameDiff(), ix, null).outputVariables()[0];
    }

    public SDVariable or(SDVariable iX, SDVariable i_y) {
        return new Or(this.sameDiff(), iX, i_y).outputVariables()[0];
    }

    public SDVariable and(SDVariable ix, SDVariable iy) {
        return new And(this.sameDiff(), ix, iy).outputVariables()[0];
    }

    public SDVariable xor(SDVariable ix, SDVariable iy) {
        return new Xor(this.sameDiff(), ix, iy).outputVariables()[0];
    }

    public SDVariable eq(SDVariable iX, SDVariable i_y) {
        return new EqualTo(this.sameDiff(), new SDVariable[]{iX, i_y}, false).outputVariables()[0];
    }

    public SDVariable neq(SDVariable iX, double i_y) {
        return new ScalarNotEquals(this.sameDiff(), iX, i_y).outputVariables()[0];
    }

    public SDVariable neqi(SDVariable iX, double i_y) {
        return new ScalarNotEquals(this.sameDiff(), iX, (Number)i_y, true).outputVariables()[0];
    }

    public SDVariable neqi(SDVariable iX, SDVariable i_y) {
        return new NotEqualTo(this.sameDiff(), new SDVariable[]{iX, i_y}, true).outputVariables()[0];
    }

    public SDVariable neq(SDVariable iX, SDVariable i_y) {
        return new NotEqualTo(this.sameDiff(), new SDVariable[]{iX, i_y}, false).outputVariables()[0];
    }

    public SDVariable pow(SDVariable iX, double i_y) {
        return new Pow(this.sameDiff(), iX, false, i_y).outputVariables()[0];
    }

    public SDVariable sqrt(SDVariable iX) {
        return new Sqrt(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable square(SDVariable iX) {
        return new Pow(this.sameDiff(), iX, false, 2.0).outputVariables()[0];
    }

    public SDVariable cube(SDVariable iX) {
        return new Cube(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable cubeDerivative(SDVariable iX) {
        return new CubeDerivative(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable floor(SDVariable iX) {
        return new Floor(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable floorDiv(SDVariable x, SDVariable y) {
        return new FloorDivOp(this.sameDiff(), x, y).outputVariables()[0];
    }

    public List<SDVariable> floorDivBp(SDVariable x, SDVariable y, SDVariable grad) {
        return Arrays.asList(new FloorDivBpOp(this.sameDiff(), x, y, grad).outputVariables());
    }

    public SDVariable floorMod(SDVariable x, SDVariable y) {
        return new FModOp(this.sameDiff(), x, y).outputVariables()[0];
    }

    public List<SDVariable> floorModBp(SDVariable x, SDVariable y, SDVariable grad) {
        return Arrays.asList(new FloorModBpOp(this.sameDiff(), x, y, grad).outputVariables());
    }

    public SDVariable ceil(SDVariable x) {
        return new Ceil(this.sameDiff(), x).outputVariables()[0];
    }

    public SDVariable clipByValue(SDVariable x, double clipValueMin, double clipValueMax) {
        return new ClipByValue(this.sameDiff(), x, clipValueMin, clipValueMax).outputVariables()[0];
    }

    public SDVariable clipByNorm(SDVariable x, double clipValue) {
        return new ClipByNorm(this.sameDiff(), x, clipValue, new int[0]).outputVariables()[0];
    }

    public SDVariable relu(SDVariable iX, double cutoff) {
        return new RectifedLinear(this.sameDiff(), iX, false, cutoff).outputVariables()[0];
    }

    public SDVariable relu6(SDVariable iX, double cutoff) {
        return new Relu6(this.sameDiff(), iX, false, cutoff).outputVariables()[0];
    }

    public SDVariable softmax(SDVariable iX) {
        return new SoftMax(this.sameDiff(), new SDVariable[]{iX}).outputVariables()[0];
    }

    public SDVariable hardTanh(SDVariable iX) {
        return new HardTanh(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable hardTanhDerivative(SDVariable iX) {
        return new HardTanhDerivative(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable sigmoid(SDVariable iX) {
        return new Sigmoid(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable sigmoidDerivative(SDVariable iX, SDVariable wrt) {
        return new SigmoidDerivative(this.sameDiff(), iX, wrt).outputVariables()[0];
    }

    public SDVariable logSigmoid(SDVariable iX) {
        return new LogSigmoid(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable logSigmoidDerivative(SDVariable iX, SDVariable wrt) {
        return new LogSigmoidDerivative(this.sameDiff(), iX, wrt).outputVariables()[0];
    }

    public SDVariable powDerivative(SDVariable iX, double pow) {
        return new PowDerivative(this.sameDiff(), iX, false, pow).outputVariables()[0];
    }

    public SDVariable swish(SDVariable iX) {
        return new Swish(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable swishDerivative(SDVariable iX) {
        return new SwishDerivative(this.sameDiff(), iX, false).outputVariables()[0];
    }

    public SDVariable sign(SDVariable iX) {
        return new Sign(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable expandDims(SDVariable iX, int axis) {
        return new ExpandDims(this.sameDiff(), new SDVariable[]{iX}, axis).outputVariables()[0];
    }

    public SDVariable squeeze(SDVariable iX, int ... axis) {
        return new Squeeze(this.sameDiff(), iX, axis).outputVariables()[0];
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred) {
        return new ConfusionMatrix(this.sameDiff(), labels, pred).outputVariables()[0];
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses) {
        return new ConfusionMatrix(this.sameDiff(), labels, pred, numClasses).outputVariables()[0];
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, SDVariable weights) {
        return new ConfusionMatrix(this.sameDiff(), labels, pred, weights).outputVariables()[0];
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses, SDVariable weights) {
        return new ConfusionMatrix(this.sameDiff(), labels, pred, numClasses, weights).outputVariables()[0];
    }

    public SDVariable broadcast(SDVariable iX, int ... shape) {
        return new Broadcast(this.sameDiff(), iX, shape).outputVariables()[0];
    }

    public SDVariable onehot(SDVariable indices, int depth, int axis, double on, double off) {
        return new OneHot(this.sameDiff(), indices, depth, axis, on, off).outputVariables()[0];
    }

    public SDVariable onehot(SDVariable indices, int depth) {
        return new OneHot(this.sameDiff(), indices, depth).outputVariables()[0];
    }

    public SDVariable reciprocal(SDVariable a) {
        return new Reciprocal(this.sameDiff(), a, new Object[0]).outputVariables()[0];
    }

    public SDVariable repeat(SDVariable iX, int axis) {
        return new Repeat(this.sameDiff(), new SDVariable[]{iX}, axis).outputVariables()[0];
    }

    public SDVariable stack(SDVariable[] values, int axis) {
        return new Stack(this.sameDiff(), values, axis).outputVariables()[0];
    }

    public SDVariable parallel_stack(SDVariable[] values) {
        return new ParallelStack(this.sameDiff(), values).outputVariables()[0];
    }

    public SDVariable[] unstack(SDVariable value, int axis) {
        return new Unstack(this.sameDiff(), value, axis).outputVariables();
    }

    public SDVariable assign(SDVariable x, SDVariable y) {
        return new Assign(this.sameDiff(), x, y).outputVariables()[0];
    }

    public SDVariable softsign(SDVariable iX) {
        return new SoftSign(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable softsignDerivative(SDVariable iX) {
        return new SoftSignDerivative(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable softplus(SDVariable iX) {
        return new SoftPlus(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable elu(SDVariable iX) {
        return new ELU(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable eluDerivative(SDVariable iX) {
        return new ELUDerivative(this.sameDiff(), iX, null).outputVariables()[0];
    }

    public SDVariable leakyRelu(SDVariable iX, double cutoff) {
        return new LeakyReLU(this.sameDiff(), iX, false, cutoff).outputVariables()[0];
    }

    public SDVariable leakyReluDerivative(SDVariable iX, double cutoff) {
        return new LeakyReLUDerivative(this.sameDiff(), iX, false, cutoff).outputVariables()[0];
    }

    public SDVariable reshape(SDVariable iX, int[] shape) {
        return new Reshape(this.sameDiff(), iX, shape).outputVariables()[0];
    }

    public SDVariable reverse(SDVariable x, int ... dimensions) {
        return new Reverse(this.sameDiff(), x, dimensions).outputVariables()[0];
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths, int seq_dim, int batch_dim) {
        return new ReverseSequence(this.sameDiff(), x, seq_lengths, seq_dim, batch_dim).outputVariables()[0];
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths) {
        return new ReverseSequence(this.sameDiff(), x, seq_lengths).outputVariables()[0];
    }

    public SDVariable sequenceMask(SDVariable lengths, SDVariable maxLen) {
        return new SequenceMask(this.sameDiff(), lengths, maxLen).outputVariables()[0];
    }

    public SDVariable sequenceMask(SDVariable lengths, int maxLen) {
        return new SequenceMask(this.sameDiff(), lengths, maxLen).outputVariables()[0];
    }

    public SDVariable sequenceMask(SDVariable lengths) {
        return new SequenceMask(this.sameDiff(), lengths).outputVariables()[0];
    }

    public SDVariable rollAxis(SDVariable iX, int axis) {
        return new RollAxis(this.sameDiff(), iX, axis).outputVariables()[0];
    }

    public SDVariable concat(int dimension, SDVariable ... inputs) {
        return new Concat(this.sameDiff(), dimension, inputs).outputVariables()[0];
    }

    public SDVariable fill(SDVariable shape, double value) {
        return new Fill(this.sameDiff(), shape, value).outputVariables()[0];
    }

    public SDVariable cosineSimilarity(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return new CosineSimilarity(this.sameDiff(), iX, i_y, dimensions).outputVariables()[0];
    }

    public SDVariable cosineDistance(SDVariable ix, SDVariable iy, int ... dimensions) {
        return new CosineDistance(this.sameDiff(), ix, iy, dimensions).outputVariables()[0];
    }

    public SDVariable euclideanDistance(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return new EuclideanDistance(this.sameDiff(), iX, i_y, dimensions).outputVariables()[0];
    }

    public SDVariable manhattanDistance(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return new ManhattanDistance(this.sameDiff(), iX, i_y, dimensions).outputVariables()[0];
    }

    public SDVariable hammingDistance(SDVariable ix, SDVariable iy, int ... dimensions) {
        return new HammingDistance(this.sameDiff(), ix, iy, dimensions).outputVariables()[0];
    }

    public SDVariable jaccardDistance(SDVariable ix, SDVariable iy, int ... dimensions) {
        return new JaccardDistance(this.sameDiff(), ix, iy, dimensions).outputVariables()[0];
    }

    public SDVariable weightedCrossEntropyWithLogits(SDVariable targets, SDVariable inputs, SDVariable weights) {
        return new WeightedCrossEntropyLoss(this.sameDiff(), targets, inputs, weights).outputVariables()[0];
    }

    public SDVariable sigmoidCrossEntropyWithLogits(SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        return new SigmoidCrossEntropyLoss(this.sameDiff(), logits, weights, labels, reductionMode, labelSmoothing).outputVariables()[0];
    }

    public SDVariable softmaxCrossEntropyWithLogits(SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        return new SoftmaxCrossEntropyLoss(this.sameDiff(), logits, weights, labels, reductionMode, labelSmoothing).outputVariables()[0];
    }

    public SDVariable lossBinaryXENT(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossCosineSimilarity(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossHinge(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossKLD(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossL1(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossL2(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossMAE(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossMAPE(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossMSE(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossMCXENT(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossMSLE(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossNegativeLogLikelihood(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossPoisson(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable lossSquaredHinge(SDVariable iX, SDVariable i_y, int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    public SDVariable xwPlusB(SDVariable input, SDVariable weights, SDVariable bias) {
        return new XwPlusB(this.sameDiff(), input, weights, bias).outputVariables()[0];
    }

    public SDVariable reluLayer(SDVariable input, SDVariable weights, SDVariable bias) {
        return new ReluLayer(this.sameDiff(), input, weights, bias).outputVariables()[0];
    }

    public SDVariable mmul(SDVariable x, SDVariable y, MMulTranspose mMulTranspose) {
        this.validateDifferentialFunctionsameDiff(x);
        this.validateDifferentialFunctionsameDiff(y);
        return new Mmul(this.sameDiff(), x, y, mMulTranspose).outputVariables()[0];
    }

    public SDVariable mmul(SDVariable x, SDVariable y) {
        return this.mmul(x, y, MMulTranspose.allFalse());
    }

    public SDVariable tensorMmul(SDVariable x, SDVariable y, int[][] dimensions) {
        this.validateDifferentialFunctionsameDiff(x);
        this.validateDifferentialFunctionsameDiff(y);
        return new TensorMmul(this.sameDiff(), x, y, dimensions).outputVariables()[0];
    }

    public SDVariable softmaxDerivative(SDVariable functionInput, SDVariable wrt) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new SoftMaxDerivative(this.sameDiff(), functionInput, wrt).outputVariables()[0];
    }

    public SDVariable logSoftmax(SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(i_v);
        return new LogSoftMax(this.sameDiff(), i_v, null).outputVariables()[0];
    }

    public SDVariable logSoftmaxDerivative(SDVariable arg, SDVariable wrt) {
        this.validateDifferentialFunctionsameDiff(arg);
        return new LogSoftMaxDerivative(this.sameDiff(), arg, wrt).outputVariables()[0];
    }

    public SDVariable selu(SDVariable arg) {
        this.validateDifferentialFunctionsameDiff(arg);
        return new SELU(this.sameDiff(), arg, null).outputVariables()[0];
    }

    public SDVariable seluDerivative(SDVariable arg) {
        this.validateDifferentialFunctionsameDiff(arg);
        return new SELUDerivative(this.sameDiff(), arg, null).outputVariables()[0];
    }

    public SDVariable rsub(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new RSubOp(this.sameDiff(), differentialFunction, i_v).outputVariables()[0];
    }

    public List<SDVariable> rsubBp(SDVariable x, SDVariable y, SDVariable grad) {
        return Arrays.asList(new RSubBpOp(this.sameDiff(), x, y, grad).outputVariables());
    }

    public SDVariable rdiv(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new RDivOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, false).outputVariables()[0];
    }

    public List<SDVariable> rdivBp(SDVariable x, SDVariable y, SDVariable grad) {
        return Arrays.asList(new RDivBpOp(this.sameDiff(), x, y, grad).outputVariables());
    }

    public SDVariable rdivi(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new RDivOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, true).outputVariables()[0];
    }

    public SDVariable rsubi(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new RSubOp(this.sameDiff(), differentialFunction, i_v).outputVariables()[0];
    }

    public SDVariable add(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new AddOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, false).outputVariables()[0];
    }

    public SDVariable mergeadd(SDVariable[] differentialFunctions) {
        for (SDVariable df : differentialFunctions) {
            this.validateDifferentialFunctionsameDiff(df);
        }
        return new MergeAddOp(this.sameDiff(), differentialFunctions, false).outputVariables()[0];
    }

    public SDVariable diag(SDVariable sdVariable) {
        this.validateDifferentialFunctionsameDiff(sdVariable);
        return new Diag(this.sameDiff(), new SDVariable[]{sdVariable}, false).outputVariables()[0];
    }

    public SDVariable diagPart(SDVariable sdVariable) {
        this.validateDifferentialFunctionsameDiff(sdVariable);
        return new DiagPart(this.sameDiff(), new SDVariable[]{sdVariable}, false).outputVariables()[0];
    }

    public SDVariable batchToSpace(SDVariable differentialFunction, int[] blocks, int[][] crops) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new BatchToSpace(this.sameDiff(), new SDVariable[]{differentialFunction}, blocks, crops, false).outputVariables()[0];
    }

    public SDVariable spaceToBatch(SDVariable differentialFunction, int[] blocks, int[][] padding) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new SpaceToBatch(this.sameDiff(), new SDVariable[]{differentialFunction}, blocks, padding, false).outputVariables()[0];
    }

    public SDVariable depthToSpace(SDVariable differentialFunction, int blocksSize, String dataFormat) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new DepthToSpace(this.sameDiff(), new SDVariable[]{differentialFunction}, blocksSize, dataFormat).outputVariables()[0];
    }

    public SDVariable spaceToDepth(SDVariable differentialFunction, int blocksSize, String dataFormat) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new SpaceToDepth(this.sameDiff(), new SDVariable[]{differentialFunction}, blocksSize, dataFormat).outputVariables()[0];
    }

    public SDVariable[] dynamicPartition(SDVariable differentialFunction, SDVariable partitions, int numPartitions) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new DynamicPartition(this.sameDiff(), differentialFunction, partitions, numPartitions).outputVariables();
    }

    public SDVariable dynamicStitch(SDVariable[] indices, SDVariable[] differentialFunctions) {
        for (SDVariable df : differentialFunctions) {
            this.validateDifferentialFunctionsameDiff(df);
        }
        return new DynamicStitch(this.sameDiff(), indices, differentialFunctions).outputVariables()[0];
    }

    public SDVariable dilation2D(SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        this.validateDifferentialFunctionsameDiff(df);
        return new Dilation2D(this.sameDiff(), new SDVariable[]{df, weights}, strides, rates, isSameMode, false).outputVariables()[0];
    }

    public SDVariable shape(SDVariable df) {
        this.validateDifferentialFunctionsameDiff(df);
        return new org.nd4j.linalg.api.ops.impl.shape.Shape(this.sameDiff(), df, false).outputVariables()[0];
    }

    public SDVariable gather(SDVariable df, int axis, int[] broadcast) {
        this.validateDifferentialFunctionsameDiff(df);
        return new Gather(this.sameDiff(), df, axis, broadcast, false).outputVariables()[0];
    }

    public SDVariable gatherNd(SDVariable df, SDVariable indices) {
        this.validateDifferentialFunctionsameDiff(df);
        return new GatherNd(this.sameDiff(), df, indices, false).outputVariables()[0];
    }

    public SDVariable cross(SDVariable a, SDVariable b) {
        this.validateDifferentialFunctionsameDiff(a);
        return new Cross(this.sameDiff(), new SDVariable[]{a, b}).outputVariables()[0];
    }

    public SDVariable erf(SDVariable differentialFunction) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new Erf(this.sameDiff(), differentialFunction, false).outputVariables()[0];
    }

    public SDVariable erfc(SDVariable differentialFunction) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new Erfc(this.sameDiff(), differentialFunction, false).outputVariables()[0];
    }

    public SDVariable addi(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new AddOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, true).outputVariables()[0];
    }

    public List<SDVariable> addBp(SDVariable x, SDVariable y, SDVariable grad) {
        SDVariable[] ret = new AddBpOp(this.sameDiff(), x, y, grad).outputVariables();
        return Arrays.asList(ret);
    }

    public SDVariable sub(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new SubOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, false).outputVariables()[0];
    }

    public SDVariable squaredDifference(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new SquaredDifferenceOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, false).outputVariables()[0];
    }

    public List<SDVariable> subBp(SDVariable x, SDVariable y, SDVariable grad) {
        return Arrays.asList(new SubBpOp(this.sameDiff(), x, y, grad).outputVariables());
    }

    public SDVariable subi(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new SubOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, true).outputVariables()[0];
    }

    public SDVariable mul(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new MulOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, false).outputVariables()[0];
    }

    public List<SDVariable> mulBp(SDVariable x, SDVariable y, SDVariable grad) {
        return Arrays.asList(new MulBpOp(this.sameDiff(), x, y, grad).outputVariables());
    }

    public SDVariable muli(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new MulOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, true).outputVariables()[0];
    }

    public SDVariable div(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new DivOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, false).outputVariables()[0];
    }

    public SDVariable truncatedDiv(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new TruncateDivOp(this.sameDiff(), differentialFunction, i_v, false).outputVariables()[0];
    }

    public List<SDVariable> divBp(SDVariable x, SDVariable y, SDVariable grad) {
        return Arrays.asList(new DivBpOp(this.sameDiff(), x, y, grad).outputVariables());
    }

    public SDVariable divi(SDVariable differentialFunction, SDVariable i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new DivOp(this.sameDiff(), new SDVariable[]{differentialFunction, i_v}, true).outputVariables()[0];
    }

    public SDVariable rsub(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarReverseSubtraction(this.sameDiff(), differentialFunction, i_v).outputVariables()[0];
    }

    public SDVariable rdiv(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarReverseDivision(this.sameDiff(), differentialFunction, i_v).outputVariables()[0];
    }

    public SDVariable rdivi(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarReverseDivision(this.sameDiff(), differentialFunction, (Number)i_v, true).outputVariables()[0];
    }

    public SDVariable rsubi(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarReverseSubtraction(this.sameDiff(), differentialFunction, (Number)i_v, true).outputVariables()[0];
    }

    public SDVariable add(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarAdd(this.sameDiff(), differentialFunction, (Number)i_v, false).outputVariables()[0];
    }

    public SDVariable addi(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarAdd(this.sameDiff(), differentialFunction, (Number)i_v, true).outputVariables()[0];
    }

    public SDVariable sub(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarSubtraction(this.sameDiff(), differentialFunction, i_v).outputVariables()[0];
    }

    public SDVariable subi(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarSubtraction(this.sameDiff(), differentialFunction, (Number)i_v, true).outputVariables()[0];
    }

    public SDVariable mul(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarMultiplication(this.sameDiff(), differentialFunction, i_v).outputVariables()[0];
    }

    public SDVariable muli(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarMultiplication(this.sameDiff(), differentialFunction, (Number)i_v, true).outputVariables()[0];
    }

    public SDVariable div(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarDivision(this.sameDiff(), differentialFunction, i_v).outputVariables()[0];
    }

    public SDVariable divi(SDVariable differentialFunction, double i_v) {
        this.validateDifferentialFunctionsameDiff(differentialFunction);
        return new ScalarDivision(this.sameDiff(), differentialFunction, (Number)i_v, true).outputVariables()[0];
    }

    public SDVariable gt(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new GreaterThan(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, false).outputVariables()[0];
    }

    public SDVariable lt(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new LessThan(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, false).outputVariables()[0];
    }

    public SDVariable gti(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new GreaterThan(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, true).outputVariables()[0];
    }

    public SDVariable lti(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new LessThan(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, true).outputVariables()[0];
    }

    public SDVariable gte(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new GreaterThanOrEqual(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, false).outputVariables()[0];
    }

    public SDVariable lte(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new LessThanOrEqual(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, false).outputVariables()[0];
    }

    public SDVariable gtei(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new GreaterThanOrEqual(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, true).outputVariables()[0];
    }

    public SDVariable ltOrEqi(SDVariable functionInput, SDVariable functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        this.validateDifferentialFunctionsameDiff(functionInput1);
        return new LessThanOrEqual(this.sameDiff(), new SDVariable[]{functionInput, functionInput1}, true).outputVariables()[0];
    }

    public SDVariable gt(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarGreaterThan(this.sameDiff(), functionInput, (Number)functionInput1, false).outputVariables()[0];
    }

    public SDVariable lt(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarLessThan(this.sameDiff(), functionInput, (Number)functionInput1, false).outputVariables()[0];
    }

    public SDVariable gti(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarGreaterThan(this.sameDiff(), functionInput, (Number)functionInput1, true).outputVariables()[0];
    }

    public SDVariable lti(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarLessThan(this.sameDiff(), functionInput, (Number)functionInput1, true).outputVariables()[0];
    }

    public SDVariable gte(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarGreaterThanOrEqual(this.sameDiff(), functionInput, (Number)functionInput1, false).outputVariables()[0];
    }

    public SDVariable lte(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarLessThanOrEqual(this.sameDiff(), functionInput, (Number)functionInput1, false).outputVariables()[0];
    }

    public SDVariable gtei(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarGreaterThanOrEqual(this.sameDiff(), functionInput, (Number)functionInput1, true).outputVariables()[0];
    }

    public SDVariable ltei(SDVariable functionInput, double functionInput1) {
        this.validateDifferentialFunctionsameDiff(functionInput);
        return new ScalarLessThanOrEqual(this.sameDiff(), functionInput, (Number)functionInput1, true).outputVariables()[0];
    }

    public SDVariable eq(SDVariable iX, double i_y) {
        return new ScalarEquals(this.sameDiff(), iX, i_y).outputVariables()[0];
    }

    public SDVariable eqi(SDVariable iX, double i_y) {
        return new ScalarEquals(this.sameDiff(), iX, (Number)i_y, true).outputVariables()[0];
    }

    public SDVariable isNonDecreasing(SDVariable iX) {
        this.validateDifferentialFunctionsameDiff(iX);
        return new IsNonDecreasing(this.sameDiff(), new SDVariable[]{iX}, false).outputVariables()[0];
    }

    public SDVariable isStrictlyIncreasing(SDVariable iX) {
        this.validateDifferentialFunctionsameDiff(iX);
        return new IsStrictlyIncreasing(this.sameDiff(), new SDVariable[]{iX}, false).outputVariables()[0];
    }

    public SDVariable isNumericTensor(SDVariable iX) {
        this.validateDifferentialFunctionsameDiff(iX);
        return new IsNumericTensor(this.sameDiff(), new SDVariable[]{iX}, false).outputVariables()[0];
    }

    public SDVariable slice(SDVariable input, int[] begin, int[] size) {
        return new Slice(this.sameDiff(), input, begin, size).outputVariables()[0];
    }

    public SDVariable stridedSlice(SDVariable input, int[] begin, int[] end, int[] strides) {
        return new StridedSlice(this.sameDiff(), input, begin, end, strides).outputVariables()[0];
    }

    public SDVariable stridedSlice(SDVariable in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        return new StridedSlice(this.sameDiff(), in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask).outputVariables()[0];
    }

    public SDVariable scatterAdd(SDVariable ref, SDVariable indices, SDVariable updates) {
        return new ScatterAdd(this.sameDiff(), ref, indices, updates).outputVariables()[0];
    }

    public SDVariable scatterSub(SDVariable ref, SDVariable indices, SDVariable updates) {
        return new ScatterSub(this.sameDiff(), ref, indices, updates).outputVariables()[0];
    }

    public SDVariable scatterMul(SDVariable ref, SDVariable indices, SDVariable updates) {
        return new ScatterMul(this.sameDiff(), ref, indices, updates).outputVariables()[0];
    }

    public SDVariable scatterDiv(SDVariable ref, SDVariable indices, SDVariable updates) {
        return new ScatterDiv(this.sameDiff(), ref, indices, updates).outputVariables()[0];
    }

    public int getInputLength(SDVariable func) {
        this.validateDifferentialFunctionsameDiff(func);
        int[] inputShape = func.arg().getShape();
        return ArrayUtil.prod((int[])inputShape);
    }

    public int getReductionLength(DifferentialFunction func) {
        int[] inputShape = func.arg().getShape();
        if (Shape.isWholeArray(inputShape, func.getDimensions())) {
            return ArrayUtil.prod((int[])inputShape);
        }
        int prod = 1;
        for (int i : func.getDimensions()) {
            prod *= inputShape[i];
        }
        return prod;
    }

    public void validateDifferentialFunctionsameDiff(SDVariable function) {
        Preconditions.checkState((function != null ? 1 : 0) != 0, (String)"Passed in function was null.");
        Preconditions.checkState((function.getSameDiff() == this.sameDiff ? 1 : 0) != 0);
        Preconditions.checkState((function.getSameDiff() == this.getSameDiff() ? 1 : 0) != 0, (String)"Function applications must be contained in same sameDiff. The left %s must match this function %s", (Object)function, (Object)this);
        Preconditions.checkState((this.sameDiff == this.getSameDiff() ? 1 : 0) != 0, (String)"Function applications must be contained in same sameDiff. The left %s must match this function ", (Object)function, (Object)this);
    }

    public void validateDifferentialFunctionGraph(SDVariable function) {
        Preconditions.checkState((function.getSameDiff() == this.getSameDiff() ? 1 : 0) != 0, (String)"Function applications must be contained in same graph. The left %s must match this function %s", (Object)function, (Object)this);
    }

    public SDVariable doGradChoose(SDVariable func, SDVariable input) {
        this.validateDifferentialFunctionsameDiff(func);
        this.validateDifferentialFunctionsameDiff(input);
        SDVariable repeatedGrad = this.doRepeat(func, input);
        SDVariable resultRepeated = this.doRepeat(func.args()[0], input);
        SDVariable argMaxLocations = this.eq(input, resultRepeated);
        return this.div(this.mul(argMaxLocations, repeatedGrad), this.sum(argMaxLocations, new int[0]).outputVariables()[0]);
    }

    public SDVariable doRepeat(SDVariable func, SDVariable input) {
        this.validateDifferentialFunctionsameDiff(func);
        this.validateDifferentialFunctionsameDiff(input);
        return this.tile(func, input.getShape());
    }

    public String toString() {
        return "DifferentialFunctionFactory{methodNames=" + methodNames + '}';
    }

    public SameDiff getSameDiff() {
        return this.sameDiff;
    }

    public void setSameDiff(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DifferentialFunctionFactory)) {
            return false;
        }
        DifferentialFunctionFactory other = (DifferentialFunctionFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SameDiff this$sameDiff = this.getSameDiff();
        SameDiff other$sameDiff = other.getSameDiff();
        return !(this$sameDiff == null ? other$sameDiff != null : !((Object)this$sameDiff).equals(other$sameDiff));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DifferentialFunctionFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SameDiff $sameDiff = this.getSameDiff();
        result = result * 59 + ($sameDiff == null ? 43 : ((Object)$sameDiff).hashCode());
        return result;
    }
}

