/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class ConstantInitScheme
extends BaseWeightInitScheme {
    private double constant;

    public ConstantInitScheme(char order, double constant) {
        super(order);
        this.constant = constant;
    }

    @Override
    public INDArray doCreate(int[] shape, INDArray paramsView) {
        return Nd4j.valueArrayOf(shape, this.constant);
    }

    @Override
    public WeightInit type() {
        return WeightInit.ZERO;
    }

    public static ConstantInitSchemeBuilder builder() {
        return new ConstantInitSchemeBuilder();
    }

    public static class ConstantInitSchemeBuilder {
        private char order;
        private double constant;

        ConstantInitSchemeBuilder() {
        }

        public ConstantInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public ConstantInitSchemeBuilder constant(double constant) {
            this.constant = constant;
            return this;
        }

        public ConstantInitScheme build() {
            return new ConstantInitScheme(this.order, this.constant);
        }

        public String toString() {
            return "ConstantInitScheme.ConstantInitSchemeBuilder(order=" + this.order + ", constant=" + this.constant + ")";
        }
    }
}

