/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.string;

import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class NDArrayStrings {
    private String colSep = ",";
    private String newLineSep = ",";
    private int padding = 7;
    private int precision = 4;
    private double minToPrintWithoutSwitching;
    private double maxToPrintWithoutSwitching;
    private String scientificFormat = "";
    private DecimalFormat decimalFormat = new DecimalFormat("##0.####");
    private boolean dontOverrideFormat = false;

    public NDArrayStrings() {
        this(",", 4);
    }

    public NDArrayStrings(String colSep) {
        this(colSep, 4);
    }

    public NDArrayStrings(int precision) {
        this(",", precision);
    }

    public NDArrayStrings(String colSep, int precision) {
        this.colSep = colSep;
        if (!colSep.replaceAll("\\s", "").equals(",")) {
            this.newLineSep = "";
        }
        this.precision = precision;
        String decFormatNum = "0.";
        while (precision > 0) {
            decFormatNum = decFormatNum + "0";
            --precision;
        }
        this.decimalFormat = new DecimalFormat(decFormatNum);
    }

    public NDArrayStrings(String colSep, String decFormat) {
        this.colSep = colSep;
        this.decimalFormat = new DecimalFormat(decFormat);
        this.padding = decFormat.toUpperCase().contains("E") ? decFormat.length() + 3 : decFormat.length() + 1;
        this.dontOverrideFormat = true;
    }

    public String format(INDArray arr) {
        return this.format(arr, true);
    }

    public String format(INDArray arr, boolean summarize) {
        this.scientificFormat = "0.";
        for (int addPrecision = this.precision; addPrecision > 0; --addPrecision) {
            this.scientificFormat = this.scientificFormat + "#";
        }
        this.scientificFormat = this.scientificFormat + "E0";
        if (this.scientificFormat.length() + 2 > this.padding) {
            this.padding = this.scientificFormat.length() + 2;
        }
        this.maxToPrintWithoutSwitching = Math.pow(10.0, this.precision);
        this.minToPrintWithoutSwitching = 1.0 / this.maxToPrintWithoutSwitching;
        if (summarize && arr.length() > 1000) {
            return this.format(arr, 0, true);
        }
        return this.format(arr, 0, false);
    }

    private String format(INDArray arr, int offset, boolean summarize) {
        int rank = arr.rank();
        if (arr.isScalar() && rank == 0) {
            if (arr instanceof IComplexNDArray) {
                return ((IComplexNDArray)arr).getComplex(0).toString();
            }
            double arrElement = arr.getDouble(0);
            if (!this.dontOverrideFormat && (Math.abs(arrElement) < this.minToPrintWithoutSwitching && arrElement != 0.0 || Math.abs(arrElement) >= this.maxToPrintWithoutSwitching)) {
                String asString = new DecimalFormat(this.scientificFormat).format(arrElement);
                asString = asString.replace('E', 'e');
                return asString;
            }
            if (arr.getDouble(0) == 0.0) {
                return "0";
            }
            return this.decimalFormat.format(arr.getDouble(0));
        }
        if (rank == 1) {
            return this.vectorToString(arr, summarize);
        }
        if (arr.isRowVector()) {
            if (offset == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(this.vectorToString(arr, summarize));
                sb.append("]");
                return sb.toString();
            }
            return this.vectorToString(arr, summarize);
        }
        ++offset;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < arr.slices(); ++i) {
            if (summarize && i > 2 && i < arr.slices() - 3) {
                if (i != 3) continue;
                sb.append(" ...");
                sb.append(this.newLineSep + " \n");
                sb.append(StringUtils.repeat((String)"\n", (int)(rank - 2)));
                sb.append(StringUtils.repeat((String)" ", (int)offset));
                continue;
            }
            if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                sb.append("[");
            }
            if (arr.ordering() == 'f' && arr.rank() > 2 && arr.size(arr.rank() - 1) == 1) {
                sb.append(this.format(arr.dup('c').slice(i), offset, summarize));
            } else if (arr.rank() <= 1) {
                sb.append(this.format(Nd4j.scalar(arr.getDouble(0)), offset, summarize));
            } else {
                sb.append(this.format(arr.slice(i), offset, summarize));
            }
            if (i != arr.slices() - 1) {
                if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                    sb.append("]");
                }
                sb.append(this.newLineSep + " \n");
                sb.append(StringUtils.repeat((String)"\n", (int)(rank - 2)));
                sb.append(StringUtils.repeat((String)" ", (int)offset));
                continue;
            }
            if (arr.rank() != 3 || !arr.slice(i).isRowVector()) continue;
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    private String vectorToString(INDArray arr, boolean summarize) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < arr.length(); ++i) {
            if (arr instanceof IComplexNDArray) {
                sb.append(((IComplexNDArray)arr).getComplex(i).toString());
            } else if (summarize && i > 2 && i < arr.length() - 3) {
                if (i == 3) {
                    sb.append("  ...");
                }
            } else {
                double arrElement = arr.getDouble(i);
                if (!this.dontOverrideFormat && (Math.abs(arrElement) < this.minToPrintWithoutSwitching && arrElement != 0.0 || Math.abs(arrElement) >= this.maxToPrintWithoutSwitching)) {
                    String asString = new DecimalFormat(this.scientificFormat).format(arrElement);
                    asString = asString.replace('E', 'e');
                    sb.append(String.format("%1$" + this.padding + "s", asString));
                } else if (arrElement == 0.0) {
                    sb.append(String.format("%1$" + this.padding + "s", 0));
                } else {
                    sb.append(String.format("%1$" + this.padding + "s", this.decimalFormat.format(arrElement)));
                }
            }
            if (i >= arr.length() - 1 || summarize && i >= 2 && i <= arr.length() - 3 && (!summarize || arr.length() != 6)) continue;
            sb.append(this.colSep);
        }
        sb.append("]");
        return sb.toString();
    }
}

