/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class StepSchedule
implements ISchedule {
    private final ScheduleType scheduleType;
    private final double initialValue;
    private final double decayRate;
    private final double step;

    public StepSchedule(@JsonProperty(value="scheduleType") ScheduleType scheduleType, @JsonProperty(value="initialValue") double initialValue, @JsonProperty(value="decayRate") double decayRate, @JsonProperty(value="step") double step) {
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.decayRate = decayRate;
        this.step = step;
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        int i = this.scheduleType == ScheduleType.ITERATION ? iteration : epoch;
        return this.initialValue * Math.pow(this.decayRate, Math.floor((double)i / this.step));
    }

    @Override
    public ISchedule clone() {
        return new StepSchedule(this.scheduleType, this.initialValue, this.decayRate, this.step);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public double getDecayRate() {
        return this.decayRate;
    }

    public double getStep() {
        return this.step;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepSchedule)) {
            return false;
        }
        StepSchedule other = (StepSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !((Object)((Object)this$scheduleType)).equals((Object)other$scheduleType)) {
            return false;
        }
        if (Double.compare(this.getInitialValue(), other.getInitialValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getDecayRate(), other.getDecayRate()) != 0) {
            return false;
        }
        return Double.compare(this.getStep(), other.getStep()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof StepSchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)((Object)$scheduleType)).hashCode());
        long $initialValue = Double.doubleToLongBits(this.getInitialValue());
        result = result * 59 + (int)($initialValue >>> 32 ^ $initialValue);
        long $decayRate = Double.doubleToLongBits(this.getDecayRate());
        result = result * 59 + (int)($decayRate >>> 32 ^ $decayRate);
        long $step = Double.doubleToLongBits(this.getStep());
        result = result * 59 + (int)($step >>> 32 ^ $step);
        return result;
    }

    public String toString() {
        return "StepSchedule(scheduleType=" + (Object)((Object)this.getScheduleType()) + ", initialValue=" + this.getInitialValue() + ", decayRate=" + this.getDecayRate() + ", step=" + this.getStep() + ")";
    }
}

