/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.NadamUpdater;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Nadam
implements IUpdater {
    public static final double DEFAULT_NADAM_LEARNING_RATE = 0.001;
    public static final double DEFAULT_NADAM_EPSILON = 1.0E-8;
    public static final double DEFAULT_NADAM_BETA1_MEAN_DECAY = 0.9;
    public static final double DEFAULT_NADAM_BETA2_VAR_DECAY = 0.999;
    private double learningRate;
    private ISchedule learningRateSchedule;
    private double beta1;
    private double beta2;
    private double epsilon;

    public Nadam() {
        this(0.001, 0.9, 0.999, 1.0E-8);
    }

    public Nadam(double learningRate) {
        this(learningRate, null, 0.9, 0.999, 1.0E-8);
    }

    public Nadam(ISchedule learningRateSchedule) {
        this(Double.NaN, learningRateSchedule, 0.9, 0.999, 1.0E-8);
    }

    public Nadam(double learningRate, double beta1, double beta2, double epsilon) {
        this(learningRate, null, beta1, beta2, epsilon);
    }

    private Nadam(@JsonProperty(value="learningRate") double learningRate, @JsonProperty(value="learningRateSchedule") ISchedule learningRateSchedule, @JsonProperty(value="beta1") double beta1, @JsonProperty(value="beta2") double beta2, @JsonProperty(value="epsilon") double epsilon) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
    }

    @Override
    public long stateSize(long numParams) {
        return 2L * numParams;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        NadamUpdater u = new NadamUpdater(this);
        int[] gradientShape = viewArray.shape();
        gradientShape = Arrays.copyOf(gradientShape, gradientShape.length);
        gradientShape[1] = gradientShape[1] / 2;
        u.setStateViewArray(viewArray, gradientShape, viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public Nadam clone() {
        return new Nadam(this.learningRate, this.beta1, this.beta2, this.epsilon);
    }

    @Override
    public double getLearningRate(int iteration, int epoch) {
        if (this.learningRateSchedule != null) {
            return this.learningRateSchedule.valueAt(iteration, epoch);
        }
        return this.learningRate;
    }

    @Override
    public boolean hasLearningRate() {
        return true;
    }

    @Override
    public void setLrAndSchedule(double lr, ISchedule lrSchedule) {
        this.learningRate = lr;
        this.learningRateSchedule = lrSchedule;
    }

    private static double $default$learningRate() {
        return 0.001;
    }

    private static double $default$beta1() {
        return 0.9;
    }

    private static double $default$beta2() {
        return 0.999;
    }

    private static double $default$epsilon() {
        return 1.0E-8;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public ISchedule getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public double getBeta1() {
        return this.beta1;
    }

    public double getBeta2() {
        return this.beta2;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ISchedule learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setBeta1(double beta1) {
        this.beta1 = beta1;
    }

    public void setBeta2(double beta2) {
        this.beta2 = beta2;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nadam)) {
            return false;
        }
        Nadam other = (Nadam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        ISchedule this$learningRateSchedule = this.getLearningRateSchedule();
        ISchedule other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule)) {
            return false;
        }
        if (Double.compare(this.getBeta1(), other.getBeta1()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta2(), other.getBeta2()) != 0) {
            return false;
        }
        return Double.compare(this.getEpsilon(), other.getEpsilon()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nadam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        ISchedule $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        long $beta1 = Double.doubleToLongBits(this.getBeta1());
        result = result * 59 + (int)($beta1 >>> 32 ^ $beta1);
        long $beta2 = Double.doubleToLongBits(this.getBeta2());
        result = result * 59 + (int)($beta2 >>> 32 ^ $beta2);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        return result;
    }

    public String toString() {
        return "Nadam(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", beta1=" + this.getBeta1() + ", beta2=" + this.getBeta2() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public static class Builder {
        private boolean learningRate$set;
        private double learningRate;
        private ISchedule learningRateSchedule;
        private boolean beta1$set;
        private double beta1;
        private boolean beta2$set;
        private double beta2;
        private boolean epsilon$set;
        private double epsilon;

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            this.learningRate$set = true;
            return this;
        }

        public Builder learningRateSchedule(ISchedule learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder beta1(double beta1) {
            this.beta1 = beta1;
            this.beta1$set = true;
            return this;
        }

        public Builder beta2(double beta2) {
            this.beta2 = beta2;
            this.beta2$set = true;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            this.epsilon$set = true;
            return this;
        }

        public Nadam build() {
            double learningRate = this.learningRate;
            if (!this.learningRate$set) {
                learningRate = Nadam.$default$learningRate();
            }
            double beta1 = this.beta1;
            if (!this.beta1$set) {
                beta1 = Nadam.$default$beta1();
            }
            double beta2 = this.beta2;
            if (!this.beta2$set) {
                beta2 = Nadam.$default$beta2();
            }
            double epsilon = this.epsilon;
            if (!this.epsilon$set) {
                epsilon = Nadam.$default$epsilon();
            }
            return new Nadam(learningRate, this.learningRateSchedule, beta1, beta2, epsilon);
        }

        public String toString() {
            return "Nadam.Builder(learningRate=" + this.learningRate + ", learningRateSchedule=" + this.learningRateSchedule + ", beta1=" + this.beta1 + ", beta2=" + this.beta2 + ", epsilon=" + this.epsilon + ")";
        }
    }
}

