/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldMax;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.AdaMax;
import org.nd4j.linalg.ops.transforms.Transforms;

public class AdaMaxUpdater
implements GradientUpdater<AdaMax> {
    private final AdaMax config;
    private INDArray m;
    private INDArray u;
    private char gradientReshapeOrder;

    public AdaMaxUpdater(AdaMax config) {
        this.config = config;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, int[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVector()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(0);
        }
        int length = viewArray.length();
        this.m = viewArray.get(NDArrayIndex.point(0), NDArrayIndex.interval(0, length / 2));
        this.u = viewArray.get(NDArrayIndex.point(0), NDArrayIndex.interval(length / 2, length));
        this.m = Shape.newShapeNoCopy(this.m, gradientShape, gradientOrder == 'f');
        this.u = Shape.newShapeNoCopy(this.u, gradientShape, gradientOrder == 'f');
        if (this.m == null || this.u == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view arrays");
        }
        this.gradientReshapeOrder = gradientOrder;
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration, int epoch) {
        if (this.m == null || this.u == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        this.m.muli(this.config.getBeta1()).addi(gradient.mul(1.0 - this.config.getBeta1()));
        this.u.muli(this.config.getBeta2());
        Transforms.abs(gradient, false);
        Nd4j.getExecutioner().exec(new OldMax(this.u, gradient, this.u, this.u.length()));
        double beta1t = FastMath.pow((double)this.config.getBeta1(), (int)(iteration + 1));
        double learningRate = this.config.getLearningRate(iteration, epoch);
        double alphat = learningRate / (1.0 - beta1t);
        if (Double.isNaN(alphat) || Double.isInfinite(alphat) || alphat == 0.0) {
            alphat = this.config.getEpsilon();
        }
        this.u.addi(1.0E-32);
        gradient.assign(this.m).muli(alphat).divi(this.u);
    }

    @Override
    public AdaMax getConfig() {
        return this.config;
    }

    public INDArray getM() {
        return this.m;
    }

    public INDArray getU() {
        return this.u;
    }

    public char getGradientReshapeOrder() {
        return this.gradientReshapeOrder;
    }

    public void setM(INDArray m) {
        this.m = m;
    }

    public void setU(INDArray u) {
        this.u = u;
    }

    public void setGradientReshapeOrder(char gradientReshapeOrder) {
        this.gradientReshapeOrder = gradientReshapeOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaMaxUpdater)) {
            return false;
        }
        AdaMaxUpdater other = (AdaMaxUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdaMax this$config = this.getConfig();
        AdaMax other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$m = this.getM();
        INDArray other$m = other.getM();
        if (this$m == null ? other$m != null : !this$m.equals(other$m)) {
            return false;
        }
        INDArray this$u = this.getU();
        INDArray other$u = other.getU();
        if (this$u == null ? other$u != null : !this$u.equals(other$u)) {
            return false;
        }
        return this.getGradientReshapeOrder() == other.getGradientReshapeOrder();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaMaxUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdaMax $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $m = this.getM();
        result = result * 59 + ($m == null ? 43 : $m.hashCode());
        INDArray $u = this.getU();
        result = result * 59 + ($u == null ? 43 : $u.hashCode());
        result = result * 59 + this.getGradientReshapeOrder();
        return result;
    }

    public String toString() {
        return "AdaMaxUpdater(config=" + this.getConfig() + ", m=" + this.getM() + ", u=" + this.getU() + ", gradientReshapeOrder=" + this.getGradientReshapeOrder() + ")";
    }
}

