/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;

public class Max
extends BaseDynamicTransformOp {
    public Max() {
    }

    public Max(SameDiff sameDiff, @NonNull SDVariable first, @NonNull SDVariable second) {
        this(sameDiff, new SDVariable[]{first, second}, false);
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
    }

    public Max(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(sameDiff, args, inPlace);
    }

    public Max(INDArray[] inputs, INDArray[] outputs) {
        super(inputs, outputs);
    }

    @Override
    public String opName() {
        return "maximum";
    }

    @Override
    public String onnxName() {
        return "Max";
    }

    @Override
    public String tensorflowName() {
        return "Maximum";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable max = this.outputVariables()[0];
        SDVariable eq1 = this.sameDiff.eq(this.larg(), max);
        SDVariable eq2 = this.sameDiff.eq(this.rarg(), max);
        return Arrays.asList(eq1.mul(f1.get(0)), eq2.mul(f1.get(0)));
    }
}

